/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InvalidLineNumberException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class LineBreakpoint<P extends JavaBreakpointProperties>
extends BreakpointWithHighlighter<P> {
    private static final Logger j = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.LineBreakpoint");
    @NonNls
    public static final Key<LineBreakpoint> CATEGORY = BreakpointCategory.lookup("line_breakpoints");
    private static final Pattern k = Pattern.compile(".*\\$\\d*$");

    protected LineBreakpoint(Project project2, XBreakpoint xBreakpoint) {
        super(project2, xBreakpoint);
    }

    @Override
    protected Icon getDisabledIcon(boolean bl2) {
        block4: {
            Icon icon;
            block6: {
                block5: {
                    try {
                        try {
                            if (DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this) == null) break block4;
                            if (!bl2) break block5;
                        }
                        catch (ClassNotPreparedException classNotPreparedException) {
                            throw LineBreakpoint.c(classNotPreparedException);
                        }
                        icon = AllIcons.Debugger.Db_muted_dep_line_breakpoint;
                        break block6;
                    }
                    catch (ClassNotPreparedException classNotPreparedException) {
                        throw LineBreakpoint.c(classNotPreparedException);
                    }
                }
                icon = AllIcons.Debugger.Db_dep_line_breakpoint;
            }
            return icon;
        }
        return null;
    }

    @Override
    protected Icon getInvalidIcon(boolean bl2) {
        Icon icon;
        try {
            icon = bl2 ? AllIcons.Debugger.Db_muted_invalid_breakpoint : AllIcons.Debugger.Db_invalid_breakpoint;
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw LineBreakpoint.c(classNotPreparedException);
        }
        return icon;
    }

    @Override
    protected Icon getVerifiedIcon(boolean bl2) {
        Icon icon;
        block6: {
            Icon icon2;
            block8: {
                block7: {
                    try {
                        try {
                            if (!this.isRemoveAfterHit()) break block6;
                            if (!bl2) break block7;
                        }
                        catch (ClassNotPreparedException classNotPreparedException) {
                            throw LineBreakpoint.c(classNotPreparedException);
                        }
                        icon2 = AllIcons.Debugger.Db_muted_temporary_breakpoint;
                        break block8;
                    }
                    catch (ClassNotPreparedException classNotPreparedException) {
                        throw LineBreakpoint.c(classNotPreparedException);
                    }
                }
                icon2 = AllIcons.Debugger.Db_temporary_breakpoint;
            }
            return icon2;
        }
        try {
            icon = bl2 ? AllIcons.Debugger.Db_muted_verified_breakpoint : AllIcons.Debugger.Db_verified_breakpoint;
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw LineBreakpoint.c(classNotPreparedException);
        }
        return icon;
    }

    @Override
    protected Icon getVerifiedWarningsIcon(boolean bl2) {
        Icon icon;
        try {
            icon = bl2 ? AllIcons.Debugger.Db_muted_verified_warning_breakpoint : AllIcons.Debugger.Db_verified_warning_breakpoint;
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw LineBreakpoint.c(classNotPreparedException);
        }
        return icon;
    }

    @Override
    public Key<LineBreakpoint> getCategory() {
        return CATEGORY;
    }

    @Override
    protected void createOrWaitPrepare(DebugProcessImpl debugProcessImpl, String string) {
        try {
            if (this.a(debugProcessImpl, string)) {
                super.createOrWaitPrepare(debugProcessImpl, string);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw LineBreakpoint.c(classNotPreparedException);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    protected void createRequestForPreparedClass(DebugProcessImpl debugProcessImpl, ReferenceType referenceType) {
        block42: {
            block37: {
                block38: {
                    if (this.a(debugProcessImpl, referenceType.name())) break block37;
                    try {
                        block44: {
                            if (!j.isDebugEnabled()) break block38;
                            break block44;
                            catch (ClassNotPreparedException classNotPreparedException) {
                                throw LineBreakpoint.c(classNotPreparedException);
                            }
                        }
                        j.debug(referenceType.name() + " is out of debug-process scope, breakpoint request won't be created for line " + this.getLineIndex());
                    }
                    catch (ClassNotPreparedException classNotPreparedException) {
                        throw LineBreakpoint.c(classNotPreparedException);
                    }
                }
                return;
            }
            try {
                block43: {
                    block45: {
                        List<Location> list = debugProcessImpl.getPositionManager().locationsOfLine(referenceType, this.getSourcePosition());
                        if (list.isEmpty()) break block45;
                        for (Location location : list) {
                            block39: {
                                boolean bl2;
                                StringBuilder stringBuilder;
                                block41: {
                                    block40: {
                                        block46: {
                                            if (!j.isDebugEnabled()) break block39;
                                            stringBuilder = new StringBuilder().append("Found location [codeIndex=").append(location.codeIndex()).append("] for reference type ").append(referenceType.name()).append(" at line ").append(this.getLineIndex()).append("; isObsolete: ");
                                            if (!debugProcessImpl.getVirtualMachineProxy().versionHigher("1.4")) break block40;
                                            break block46;
                                            catch (ClassNotPreparedException classNotPreparedException) {
                                                throw LineBreakpoint.c(classNotPreparedException);
                                            }
                                        }
                                        try {
                                            block47: {
                                                if (!location.method().isObsolete()) break block40;
                                                break block47;
                                                catch (ClassNotPreparedException classNotPreparedException) {
                                                    throw LineBreakpoint.c(classNotPreparedException);
                                                }
                                            }
                                            bl2 = true;
                                            break block41;
                                        }
                                        catch (ClassNotPreparedException classNotPreparedException) {
                                            throw LineBreakpoint.c(classNotPreparedException);
                                        }
                                    }
                                    bl2 = false;
                                }
                                j.debug(stringBuilder.append(bl2).toString());
                            }
                            try {
                                if (!this.acceptLocation(debugProcessImpl, referenceType, location)) {
                                    continue;
                                }
                            }
                            catch (ClassNotPreparedException classNotPreparedException) {
                                throw LineBreakpoint.c(classNotPreparedException);
                            }
                            try {
                                LineBreakpoint.createLocationBreakpointRequest(this, location, debugProcessImpl);
                                if (!j.isDebugEnabled()) continue;
                                j.debug("Created breakpoint request for reference type " + referenceType.name() + " at line " + this.getLineIndex() + "; codeIndex=" + location.codeIndex());
                            }
                            catch (ClassNotPreparedException classNotPreparedException) {
                                throw LineBreakpoint.c(classNotPreparedException);
                            }
                        }
                        break block42;
                    }
                    if (DebuggerUtilsEx.allLineLocations(referenceType) != null) break block43;
                    try {
                        block48: {
                            debugProcessImpl.getRequestsManager().setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.no.line.info", (Object[])new Object[]{referenceType.name()}));
                            if (!j.isDebugEnabled()) break block42;
                            break block48;
                            catch (ClassNotPreparedException classNotPreparedException) {
                                throw LineBreakpoint.c(classNotPreparedException);
                            }
                        }
                        j.debug("No line number info in " + referenceType.name());
                        break block42;
                    }
                    catch (ClassNotPreparedException classNotPreparedException) {
                        throw LineBreakpoint.c(classNotPreparedException);
                    }
                }
                try {
                    debugProcessImpl.getRequestsManager().setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.no.executable.code", (Object[])new Object[]{this.getLineIndex() + 1, referenceType.name()}));
                    if (j.isDebugEnabled()) {
                        j.debug("No locations of type " + referenceType.name() + " found at line " + this.getLineIndex());
                    }
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw LineBreakpoint.c(classNotPreparedException);
                }
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                try {
                    if (j.isDebugEnabled()) {
                        j.debug("ClassNotPreparedException: " + classNotPreparedException.getMessage());
                    }
                }
                catch (ClassNotPreparedException classNotPreparedException2) {
                    throw LineBreakpoint.c(classNotPreparedException2);
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
                try {
                    if (j.isDebugEnabled()) {
                        j.debug("ObjectCollectedException: " + objectCollectedException.getMessage());
                    }
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw LineBreakpoint.c(classNotPreparedException);
                }
            }
            catch (InvalidLineNumberException invalidLineNumberException) {
                try {
                    if (j.isDebugEnabled()) {
                        j.debug("InvalidLineNumberException: " + invalidLineNumberException.getMessage());
                    }
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw LineBreakpoint.c(classNotPreparedException);
                }
                debugProcessImpl.getRequestsManager().setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.bad.line.number", (Object[])new Object[0]));
            }
            catch (Exception exception) {
                j.info((Throwable)exception);
            }
        }
        this.updateUI();
    }

    private static boolean a(ReferenceType referenceType) {
        try {
            if (referenceType instanceof ClassType) {
                return k.matcher(referenceType.name()).matches();
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw LineBreakpoint.c(classNotPreparedException);
        }
        return false;
    }

    protected boolean acceptLocation(DebugProcessImpl debugProcessImpl, ReferenceType referenceType, Location location) {
        block11: {
            Method method = location.method();
            try {
                block13: {
                    try {
                        block12: {
                            try {
                                try {
                                    if (!LineBreakpoint.a(referenceType)) break block11;
                                    if (!method.isConstructor()) break block12;
                                }
                                catch (ClassNotPreparedException classNotPreparedException) {
                                    throw LineBreakpoint.c(classNotPreparedException);
                                }
                                if (location.codeIndex() == 0L) break block13;
                            }
                            catch (ClassNotPreparedException classNotPreparedException) {
                                throw LineBreakpoint.c(classNotPreparedException);
                            }
                        }
                        if (!method.isBridge()) break block11;
                    }
                    catch (ClassNotPreparedException classNotPreparedException) {
                        throw LineBreakpoint.c(classNotPreparedException);
                    }
                }
                return false;
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                throw LineBreakpoint.c(classNotPreparedException);
            }
        }
        SourcePosition sourcePosition = debugProcessImpl.getPositionManager().getSourcePosition(location);
        try {
            if (sourcePosition == null) {
                return false;
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw LineBreakpoint.c(classNotPreparedException);
        }
        return (Boolean)ReadAction.compute(() -> {
            JavaLineBreakpointType javaLineBreakpointType = this.getXBreakpointType();
            try {
                if (javaLineBreakpointType == null) {
                    return true;
                }
            }
            catch (RuntimeException runtimeException) {
                throw LineBreakpoint.c(runtimeException);
            }
            return javaLineBreakpointType.matchesPosition(this, sourcePosition);
        });
    }

    @Nullable
    protected JavaLineBreakpointType getXBreakpointType() {
        XBreakpointType xBreakpointType = this.myXBreakpoint.getType();
        try {
            if (xBreakpointType instanceof JavaLineBreakpointType) {
                return (JavaLineBreakpointType)xBreakpointType;
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw LineBreakpoint.c(classNotPreparedException);
        }
        return null;
    }

    private boolean a(DebugProcessImpl debugProcessImpl, String string) {
        block15: {
            SourcePosition sourcePosition = this.getSourcePosition();
            if (sourcePosition != null) {
                Collection<VirtualFile> collection;
                ProjectFileIndex projectFileIndex;
                VirtualFile virtualFile;
                block17: {
                    Object object;
                    StringBuilder stringBuilder;
                    Logger logger;
                    block19: {
                        block18: {
                            block16: {
                                virtualFile = sourcePosition.getFile().getVirtualFile();
                                projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
                                try {
                                    try {
                                        try {
                                            if (virtualFile == null || !projectFileIndex.isUnderSourceRootOfType(virtualFile, JavaModuleSourceRootTypes.SOURCES)) break block15;
                                        }
                                        catch (ClassNotPreparedException classNotPreparedException) {
                                            throw LineBreakpoint.c(classNotPreparedException);
                                        }
                                        if (!debugProcessImpl.getSearchScope().contains(virtualFile)) break block16;
                                    }
                                    catch (ClassNotPreparedException classNotPreparedException) {
                                        throw LineBreakpoint.c(classNotPreparedException);
                                    }
                                    return true;
                                }
                                catch (ClassNotPreparedException classNotPreparedException) {
                                    throw LineBreakpoint.c(classNotPreparedException);
                                }
                            }
                            collection = this.b(string, debugProcessImpl.getSearchScope(), projectFileIndex);
                            try {
                                try {
                                    if (!j.isDebugEnabled()) break block17;
                                    logger = j;
                                    stringBuilder = new StringBuilder().append("Found ");
                                    if (collection != null) break block18;
                                }
                                catch (ClassNotPreparedException classNotPreparedException) {
                                    throw LineBreakpoint.c(classNotPreparedException);
                                }
                                object = "null";
                                break block19;
                            }
                            catch (ClassNotPreparedException classNotPreparedException) {
                                throw LineBreakpoint.c(classNotPreparedException);
                            }
                        }
                        object = collection.size();
                    }
                    logger.debug(stringBuilder.append(object).append(" candidate containing files for class ").append(string).toString());
                }
                try {
                    if (collection == null) {
                        return true;
                    }
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw LineBreakpoint.c(classNotPreparedException);
                }
                if (j.isDebugEnabled()) {
                    GlobalSearchScope globalSearchScope = debugProcessImpl.getSearchScope();
                    boolean bl2 = globalSearchScope.contains(virtualFile);
                    List list = ContainerUtil.map((Object[])JavaPsiFacade.getInstance((Project)this.myProject).findClasses(string, globalSearchScope), psiClass -> psiClass.getContainingFile().getVirtualFile());
                    List list2 = ContainerUtil.map((Object[])JavaPsiFacade.getInstance((Project)this.myProject).findClasses(string, (GlobalSearchScope)new EverythingGlobalScope(this.myProject)), psiClass -> psiClass.getContainingFile().getVirtualFile());
                    VirtualFile virtualFile2 = projectFileIndex.getContentRootForFile(virtualFile);
                    Module module2 = projectFileIndex.getModuleForFile(virtualFile);
                    j.debug("Did not find '" + string + "' in " + globalSearchScope + "; contains=" + bl2 + "; contentRoot=" + virtualFile2 + "; module = " + module2 + "; all files in index are: " + list + "; all possible files are: " + list2);
                }
                return false;
            }
        }
        return true;
    }

    @Nullable
    private Collection<VirtualFile> b(String string, GlobalSearchScope globalSearchScope, ProjectFileIndex projectFileIndex) {
        String string2;
        int n2 = string.indexOf("$");
        try {
            string2 = n2 >= 0 ? string.substring(0, n2) : string;
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw LineBreakpoint.c(classNotPreparedException);
        }
        String string3 = string2;
        return (Collection)ReadAction.compute(() -> {
            PsiClass[] psiClassArray = JavaPsiFacade.getInstance((Project)this.myProject).findClasses(string3, globalSearchScope);
            try {
                if (j.isDebugEnabled()) {
                    j.debug("Found " + psiClassArray.length + " classes " + string3 + " in scope " + globalSearchScope);
                }
            }
            catch (RuntimeException runtimeException) {
                throw LineBreakpoint.c(runtimeException);
            }
            try {
                if (psiClassArray.length == 0) {
                    return null;
                }
            }
            catch (RuntimeException runtimeException) {
                throw LineBreakpoint.c(runtimeException);
            }
            ArrayList<StringBuilder> arrayList = new ArrayList<StringBuilder>(psiClassArray.length);
            for (PsiClass psiClass : psiClassArray) {
                StringBuilder stringBuilder;
                block19: {
                    PsiFile psiFile = psiClass.getContainingFile();
                    if (j.isDebugEnabled()) {
                        stringBuilder = new StringBuilder();
                        stringBuilder.append("Checking class ").append(psiClass.getQualifiedName());
                        stringBuilder.append("\n\t").append("PsiFile=").append(psiFile);
                        if (psiFile != null) {
                            VirtualFile virtualFile = psiFile.getVirtualFile();
                            try {
                                stringBuilder.append("\n\t").append("VirtualFile=").append(virtualFile);
                                if (virtualFile != null) {
                                    stringBuilder.append("\n\t").append("isInSourceContent=").append(projectFileIndex.isUnderSourceRootOfType(virtualFile, JavaModuleSourceRootTypes.SOURCES));
                                }
                            }
                            catch (RuntimeException runtimeException) {
                                throw LineBreakpoint.c(runtimeException);
                            }
                        }
                        j.debug(stringBuilder.toString());
                    }
                    try {
                        if (psiFile == null) {
                            return null;
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw LineBreakpoint.c(runtimeException);
                    }
                    stringBuilder = psiFile.getVirtualFile();
                    try {
                        try {
                            if (stringBuilder != null && projectFileIndex.isUnderSourceRootOfType((VirtualFile)stringBuilder, JavaModuleSourceRootTypes.SOURCES)) break block19;
                        }
                        catch (RuntimeException runtimeException) {
                            throw LineBreakpoint.c(runtimeException);
                        }
                        return null;
                    }
                    catch (RuntimeException runtimeException) {
                        throw LineBreakpoint.c(runtimeException);
                    }
                }
                arrayList.add(stringBuilder);
            }
            return arrayList;
        });
    }

    @Override
    protected String calculateEventClass(EvaluationContextImpl evaluationContextImpl, LocatableEvent locatableEvent) throws EvaluateException {
        String string = null;
        ObjectReference objectReference = (ObjectReference)evaluationContextImpl.computeThisObject();
        if (objectReference != null) {
            string = objectReference.referenceType().name();
        } else {
            StackFrameProxyImpl stackFrameProxyImpl = evaluationContextImpl.getFrameProxy();
            if (stackFrameProxyImpl != null) {
                string = stackFrameProxyImpl.location().declaringType().name();
            }
        }
        return string;
    }

    @Override
    public String getShortName() {
        return this.a(false, 30);
    }

    @Override
    public String getDisplayName() {
        return this.a(true, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String a(boolean bl2, int n2) {
        block53: {
            int n3;
            block42: {
                boolean bl3;
                String string;
                boolean bl4;
                String string2;
                block41: {
                    block40: {
                        String string3;
                        boolean bl5;
                        block39: {
                            block38: {
                                if (!this.isValid()) break block53;
                                n3 = this.myXBreakpoint.getSourcePosition().getLine() + 1;
                                string2 = this.getClassName();
                                if (string2 == null) break block38;
                                try {
                                    block54: {
                                        if (string2.length() <= 0) break block38;
                                        break block54;
                                        catch (ClassNotPreparedException classNotPreparedException) {
                                            throw LineBreakpoint.c(classNotPreparedException);
                                        }
                                    }
                                    bl5 = true;
                                    break block39;
                                }
                                catch (ClassNotPreparedException classNotPreparedException) {
                                    throw LineBreakpoint.c(classNotPreparedException);
                                }
                            }
                            bl5 = false;
                        }
                        bl4 = bl5;
                        String string4 = this.getMethodName();
                        try {
                            string3 = string4 != null ? string4 + "()" : null;
                        }
                        catch (ClassNotPreparedException classNotPreparedException) {
                            throw LineBreakpoint.c(classNotPreparedException);
                        }
                        string = string3;
                        if (string == null) break block40;
                        try {
                            block55: {
                                if (string.length() <= 0) break block40;
                                break block55;
                                catch (ClassNotPreparedException classNotPreparedException) {
                                    throw LineBreakpoint.c(classNotPreparedException);
                                }
                            }
                            bl3 = true;
                            break block41;
                        }
                        catch (ClassNotPreparedException classNotPreparedException) {
                            throw LineBreakpoint.c(classNotPreparedException);
                        }
                    }
                    bl3 = false;
                }
                boolean bl6 = bl3;
                try {
                    if (!bl4 && !bl6) break block42;
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw LineBreakpoint.c(classNotPreparedException);
                }
                StringBuilder stringBuilder = StringBuilderSpinAllocator.alloc();
                try {
                    block52: {
                        String string5;
                        block49: {
                            block51: {
                                block50: {
                                    boolean bl7;
                                    block56: {
                                        block44: {
                                            int n4;
                                            int n5;
                                            block48: {
                                                block47: {
                                                    int n6;
                                                    int n7;
                                                    block46: {
                                                        block45: {
                                                            block43: {
                                                                bl7 = this.myXBreakpoint.getSourcePosition().getFile().getName().equals(string2);
                                                                string5 = null;
                                                                if (!bl4) break block56;
                                                                int n8 = string2.lastIndexOf(".");
                                                                try {
                                                                    if (n8 < 0 || bl7) break block43;
                                                                }
                                                                catch (ClassNotPreparedException classNotPreparedException) {
                                                                    throw LineBreakpoint.c(classNotPreparedException);
                                                                }
                                                                string5 = string2.substring(0, n8);
                                                                string2 = string2.substring(n8 + 1);
                                                            }
                                                            if (n2 == -1) break block44;
                                                            try {
                                                                block57: {
                                                                    n7 = string2.length();
                                                                    if (!bl6) break block45;
                                                                    break block57;
                                                                    catch (ClassNotPreparedException classNotPreparedException) {
                                                                        throw LineBreakpoint.c(classNotPreparedException);
                                                                    }
                                                                }
                                                                n6 = string.length();
                                                                break block46;
                                                            }
                                                            catch (ClassNotPreparedException classNotPreparedException) {
                                                                throw LineBreakpoint.c(classNotPreparedException);
                                                            }
                                                        }
                                                        n6 = 0;
                                                    }
                                                    if (n7 + n6 <= n2 + 3) break block44;
                                                    try {
                                                        block58: {
                                                            n5 = n2;
                                                            if (!bl6) break block47;
                                                            break block58;
                                                            catch (ClassNotPreparedException classNotPreparedException) {
                                                                throw LineBreakpoint.c(classNotPreparedException);
                                                            }
                                                        }
                                                        n4 = string.length();
                                                        break block48;
                                                    }
                                                    catch (ClassNotPreparedException classNotPreparedException) {
                                                        throw LineBreakpoint.c(classNotPreparedException);
                                                    }
                                                }
                                                n4 = 0;
                                            }
                                            int n9 = n5 - n4;
                                            try {
                                                if (n9 <= 0 || n9 >= string2.length()) break block44;
                                            }
                                            catch (ClassNotPreparedException classNotPreparedException) {
                                                throw LineBreakpoint.c(classNotPreparedException);
                                            }
                                            string2 = string2.substring(string2.length() - n9);
                                            stringBuilder.append("...");
                                        }
                                        stringBuilder.append(string2);
                                    }
                                    if (!bl6) break block49;
                                    try {
                                        block59: {
                                            if (!bl7) break block50;
                                            break block59;
                                            catch (ClassNotPreparedException classNotPreparedException) {
                                                throw LineBreakpoint.c(classNotPreparedException);
                                            }
                                        }
                                        stringBuilder.append(":");
                                        break block51;
                                    }
                                    catch (ClassNotPreparedException classNotPreparedException) {
                                        throw LineBreakpoint.c(classNotPreparedException);
                                    }
                                }
                                try {
                                    if (bl4) {
                                        stringBuilder.append(".");
                                    }
                                }
                                catch (ClassNotPreparedException classNotPreparedException) {
                                    throw LineBreakpoint.c(classNotPreparedException);
                                }
                            }
                            stringBuilder.append(string);
                        }
                        if (!bl2) break block52;
                        try {
                            block60: {
                                if (string5 == null) break block52;
                                break block60;
                                catch (ClassNotPreparedException classNotPreparedException) {
                                    throw LineBreakpoint.c(classNotPreparedException);
                                }
                            }
                            stringBuilder.append(" (").append(string5).append(")");
                        }
                        catch (ClassNotPreparedException classNotPreparedException) {
                            throw LineBreakpoint.c(classNotPreparedException);
                        }
                    }
                    String string6 = DebuggerBundle.message((String)"line.breakpoint.display.name.with.class.or.method", (Object[])new Object[]{n3, stringBuilder.toString()});
                    return string6;
                }
                finally {
                    StringBuilderSpinAllocator.dispose((StringBuilder)stringBuilder);
                }
            }
            return DebuggerBundle.message((String)"line.breakpoint.display.name", (Object[])new Object[]{n3});
        }
        return DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]);
    }

    @Nullable
    private static String a(PsiFile psiFile, int n2) {
        block7: {
            try {
                try {
                    if (n2 >= 0 && !(psiFile instanceof JspFile)) break block7;
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw LineBreakpoint.c(classNotPreparedException);
                }
                return null;
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                throw LineBreakpoint.c(classNotPreparedException);
            }
        }
        try {
            if (psiFile instanceof PsiClassOwner) {
                return (String)ReadAction.compute(() -> {
                    String string;
                    PsiMethod psiMethod = DebuggerUtilsEx.findPsiMethod(psiFile, n2);
                    try {
                        string = psiMethod != null ? psiMethod.getName() : null;
                    }
                    catch (RuntimeException runtimeException) {
                        throw LineBreakpoint.c(runtimeException);
                    }
                    return string;
                });
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw LineBreakpoint.c(classNotPreparedException);
        }
        return null;
    }

    @Override
    public String getEventMessage(LocatableEvent locatableEvent) {
        Location location = locatableEvent.location();
        String string = DebuggerUtilsEx.getSourceName(location, throwable -> this.getFileName());
        return DebuggerBundle.message((String)"status.line.breakpoint.reached", (Object[])new Object[]{DebuggerUtilsEx.getLocationMethodQName(location), string, this.getLineIndex() + 1});
    }

    @Override
    public PsiElement getEvaluationElement() {
        return ContextUtil.getContextElement(this.getSourcePosition());
    }

    public static LineBreakpoint create(@NotNull Project project2, XBreakpoint xBreakpoint) {
        try {
            if (project2 == null) {
                LineBreakpoint.c(0);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw LineBreakpoint.c(classNotPreparedException);
        }
        LineBreakpoint lineBreakpoint = new LineBreakpoint(project2, xBreakpoint);
        return (LineBreakpoint)lineBreakpoint.init();
    }

    public static boolean canAddLineBreakpoint(Project project2, Document document, int n2) {
        block7: {
            try {
                try {
                    if (n2 >= 0 && n2 < document.getLineCount()) break block7;
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw LineBreakpoint.c(classNotPreparedException);
                }
                return false;
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                throw LineBreakpoint.c(classNotPreparedException);
            }
        }
        BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(project2).getBreakpointManager();
        LineBreakpoint lineBreakpoint = breakpointManager.findBreakpoint(document, document.getLineStartOffset(n2), CATEGORY);
        try {
            if (lineBreakpoint != null) {
                return false;
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw LineBreakpoint.c(classNotPreparedException);
        }
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        boolean[] blArray = new boolean[]{false};
        XDebuggerUtil.getInstance().iterateLine(project2, document, n2, psiElement -> {
            block22: {
                block20: {
                    boolean bl2;
                    block24: {
                        block23: {
                            PsiCodeBlock psiCodeBlock;
                            block21: {
                                block18: {
                                    try {
                                        try {
                                            if (!(psiElement instanceof PsiWhiteSpace) && PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiComment.class, (boolean)false) == null) break block18;
                                        }
                                        catch (ClassNotPreparedException classNotPreparedException) {
                                            throw LineBreakpoint.c(classNotPreparedException);
                                        }
                                        return true;
                                    }
                                    catch (ClassNotPreparedException classNotPreparedException) {
                                        throw LineBreakpoint.c(classNotPreparedException);
                                    }
                                }
                                PsiElement psiElement2 = psiElement;
                                while (psiElement != null) {
                                    int n3 = psiElement.getTextOffset();
                                    try {
                                        try {
                                            if (n3 >= 0 && document.getLineNumber(n3) != n2) {
                                                break;
                                            }
                                        }
                                        catch (ClassNotPreparedException classNotPreparedException) {
                                            throw LineBreakpoint.c(classNotPreparedException);
                                        }
                                    }
                                    catch (ClassNotPreparedException classNotPreparedException) {
                                        throw LineBreakpoint.c(classNotPreparedException);
                                    }
                                    psiElement2 = psiElement;
                                    psiElement = psiElement.getParent();
                                }
                                try {
                                    if (!(psiElement2 instanceof PsiMethod) || psiElement2.getTextRange().getEndOffset() < document.getLineEndOffset(n2)) break block20;
                                }
                                catch (ClassNotPreparedException classNotPreparedException) {
                                    throw LineBreakpoint.c(classNotPreparedException);
                                }
                                psiCodeBlock = ((PsiMethod)psiElement2).getBody();
                                try {
                                    if (psiCodeBlock != null) break block21;
                                    blArray[0] = false;
                                    break block22;
                                }
                                catch (ClassNotPreparedException classNotPreparedException) {
                                    throw LineBreakpoint.c(classNotPreparedException);
                                }
                            }
                            PsiStatement[] psiStatementArray = psiCodeBlock.getStatements();
                            try {
                                try {
                                    boolean[] blArray2 = blArray;
                                    int n4 = 0;
                                    if (psiStatementArray.length <= 0 || document.getLineNumber(psiStatementArray[0].getTextOffset()) != n2) break block23;
                                }
                                catch (ClassNotPreparedException classNotPreparedException) {
                                    throw LineBreakpoint.c(classNotPreparedException);
                                }
                                bl2 = true;
                                break block24;
                            }
                            catch (ClassNotPreparedException classNotPreparedException) {
                                throw LineBreakpoint.c(classNotPreparedException);
                            }
                        }
                        bl2 = false;
                    }
                    blArray2[n4] = bl2;
                    break block22;
                }
                blArray[0] = true;
            }
            return false;
        });
        return blArray[0];
    }

    @Nullable
    public String getMethodName() {
        XSourcePosition xSourcePosition = this.myXBreakpoint.getSourcePosition();
        if (xSourcePosition != null) {
            int n2 = xSourcePosition.getOffset();
            return LineBreakpoint.a(DebuggerUtilsEx.getPsiFile(this.myXBreakpoint.getSourcePosition(), this.myProject), n2);
        }
        return null;
    }

    private static /* synthetic */ void c(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/LineBreakpoint", "create"));
    }

    private static RuntimeException c(RuntimeException runtimeException) {
        return runtimeException;
    }
}

