/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.LambdaMethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class StepIntoBreakpoint
extends RunToCursorBreakpoint {
    private static final Logger o = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint");
    @NotNull
    private final BreakpointStepMethodFilter q;
    @Nullable
    private RequestHint p;

    protected StepIntoBreakpoint(@NotNull Project project2, @NotNull SourcePosition sourcePosition, @NotNull BreakpointStepMethodFilter breakpointStepMethodFilter) {
        if (project2 == null) {
            StepIntoBreakpoint.f(0);
        }
        if (sourcePosition == null) {
            StepIntoBreakpoint.f(1);
        }
        if (breakpointStepMethodFilter == null) {
            StepIntoBreakpoint.f(2);
        }
        super(project2, sourcePosition, false);
        this.q = breakpointStepMethodFilter;
    }

    @Override
    protected void createRequestForPreparedClass(DebugProcessImpl debugProcessImpl, ReferenceType referenceType) {
        try {
            int n2;
            CompoundPositionManager compoundPositionManager = debugProcessImpl.getPositionManager();
            List<Location> list = compoundPositionManager.locationsOfLine(referenceType, this.myCustomPosition);
            if (list.isEmpty() && (n2 = this.q.getLastStatementLine()) >= 0) {
                int n3 = this.myCustomPosition.getLine() + 1;
                while (true) {
                    try {
                        if (n3 > n2 || !list.isEmpty()) break;
                    }
                    catch (ClassNotPreparedException classNotPreparedException) {
                        throw StepIntoBreakpoint.c(classNotPreparedException);
                    }
                    list = compoundPositionManager.locationsOfLine(referenceType, SourcePosition.createFromLine((PsiFile)this.myCustomPosition.getFile(), (int)n3++));
                }
            }
            if (!list.isEmpty()) {
                MultiMap multiMap = new MultiMap();
                for (Location location : list) {
                    try {
                        if (!this.acceptLocation(debugProcessImpl, referenceType, location)) continue;
                        multiMap.putValue((Object)location.method(), (Object)location);
                    }
                    catch (ClassNotPreparedException classNotPreparedException) {
                        throw StepIntoBreakpoint.c(classNotPreparedException);
                    }
                }
                Object object = null;
                int n4 = multiMap.size();
                if (n4 == 1) {
                    object = (Location)multiMap.values().iterator().next();
                } else if (this.q instanceof LambdaMethodFilter) {
                    LambdaMethodFilter lambdaMethodFilter = (LambdaMethodFilter)this.q;
                    if (lambdaMethodFilter.getLambdaOrdinal() < n4) {
                        Method[] methodArray = multiMap.keySet().toArray(new Method[n4]);
                        Arrays.sort(methodArray, DebuggerUtilsEx.LAMBDA_ORDINAL_COMPARATOR);
                        object = (Location)multiMap.get((Object)methodArray[lambdaMethodFilter.getLambdaOrdinal()]).iterator().next();
                    }
                } else if (n4 > 0) {
                    object = (Location)multiMap.values().iterator().next();
                }
                StepIntoBreakpoint.createLocationBreakpointRequest(this, (Location)object, debugProcessImpl);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            try {
                if (o.isDebugEnabled()) {
                    o.debug("ClassNotPreparedException: " + classNotPreparedException.getMessage());
                }
            }
            catch (ClassNotPreparedException classNotPreparedException2) {
                throw StepIntoBreakpoint.c(classNotPreparedException2);
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            try {
                if (o.isDebugEnabled()) {
                    o.debug("ObjectCollectedException: " + objectCollectedException.getMessage());
                }
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                throw StepIntoBreakpoint.c(classNotPreparedException);
            }
        }
        catch (Exception exception) {
            o.info((Throwable)exception);
        }
    }

    @Override
    protected boolean acceptLocation(DebugProcessImpl debugProcessImpl, ReferenceType referenceType, Location location) {
        try {
            return this.q.locationMatches(debugProcessImpl, location);
        }
        catch (EvaluateException evaluateException) {
            o.info((Throwable)evaluateException);
            return true;
        }
    }

    @Nullable
    protected static StepIntoBreakpoint create(@NotNull Project project2, @NotNull BreakpointStepMethodFilter breakpointStepMethodFilter) {
        try {
            if (project2 == null) {
                StepIntoBreakpoint.f(3);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw StepIntoBreakpoint.c(classNotPreparedException);
        }
        try {
            if (breakpointStepMethodFilter == null) {
                StepIntoBreakpoint.f(4);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw StepIntoBreakpoint.c(classNotPreparedException);
        }
        SourcePosition sourcePosition = breakpointStepMethodFilter.getBreakpointPosition();
        if (sourcePosition != null) {
            StepIntoBreakpoint stepIntoBreakpoint = new StepIntoBreakpoint(project2, sourcePosition, breakpointStepMethodFilter);
            stepIntoBreakpoint.init();
            return stepIntoBreakpoint;
        }
        return null;
    }

    @Override
    public boolean processLocatableEvent(SuspendContextCommandImpl suspendContextCommandImpl, LocatableEvent locatableEvent) throws LocatableEventRequestor.EventProcessingException {
        boolean bl2;
        block5: {
            bl2 = super.processLocatableEvent(suspendContextCommandImpl, locatableEvent);
            try {
                try {
                    if (!bl2 || this.p == null) break block5;
                }
                catch (LocatableEventRequestor.EventProcessingException eventProcessingException) {
                    throw StepIntoBreakpoint.c(eventProcessingException);
                }
                if (!this.p.isResetIgnoreFilters()) break block5;
            }
            catch (LocatableEventRequestor.EventProcessingException eventProcessingException) {
                throw StepIntoBreakpoint.c(eventProcessingException);
            }
            SuspendContextImpl suspendContextImpl = suspendContextCommandImpl.getSuspendContext();
            if (suspendContextImpl != null) {
                DebugProcessImpl debugProcessImpl = suspendContextImpl.getDebugProcess();
                debugProcessImpl.checkPositionNotFiltered(suspendContextImpl.getThread(), (Consumer<List<ClassFilter>>)((Consumer)list -> debugProcessImpl.getSession().resetIgnoreStepFiltersFlag()));
            }
        }
        return bl2;
    }

    public void setRequestHint(RequestHint requestHint) {
        this.p = requestHint;
    }

    /*
     * Exception decompiling
     */
    private static /* synthetic */ void f(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Exception c(Exception exception) {
        return exception;
    }
}

