/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.tree;

import com.intellij.debugger.ui.impl.tree.TreeBuilderNode;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class TreeBuilder
implements TreeModel {
    private final Object a;
    private TreeBuilderNode c;
    private final EventDispatcher<TreeModelListener> b = EventDispatcher.create(TreeModelListener.class);

    protected TreeBuilder(Object object) {
        this.a = object;
    }

    public Object getUserObject() {
        return this.a;
    }

    public abstract void buildChildren(TreeBuilderNode var1);

    public abstract boolean isExpandable(TreeBuilderNode var1);

    public void setRoot(TreeBuilderNode treeBuilderNode) {
        this.c = treeBuilderNode;
    }

    @Override
    public Object getRoot() {
        return this.c;
    }

    @Override
    public int getChildCount(Object object) {
        return ((TreeBuilderNode)object).getChildCount();
    }

    @Override
    public boolean isLeaf(Object object) {
        return ((TreeBuilderNode)object).isLeaf();
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.b.addListener((EventListener)treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.b.removeListener((EventListener)treeModelListener);
    }

    @Override
    public Object getChild(Object object, int n2) {
        return ((TreeBuilderNode)object).getChildAt(n2);
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return ((TreeBuilderNode)object).getIndex((TreeNode)object2);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        TreeBuilderNode treeBuilderNode = (TreeBuilderNode)treePath.getLastPathComponent();
        treeBuilderNode.setUserObject(object);
        this.nodeChanged(treeBuilderNode);
    }

    public void nodeChanged(TreeNode treeNode) {
        TreeModelEvent treeModelEvent = null;
        TreeNode treeNode2 = treeNode.getParent();
        if (treeNode2 != null) {
            int n2 = treeNode2.getIndex(treeNode);
            treeModelEvent = new TreeModelEvent((Object)this, this.getPathToRoot(treeNode2, 0), new int[]{n2}, new Object[]{treeNode});
        } else if (treeNode == this.getRoot()) {
            treeModelEvent = new TreeModelEvent((Object)this, this.getPathToRoot(treeNode, 0), null, null);
        }
        if (treeModelEvent != null) {
            ((TreeModelListener)this.b.getMulticaster()).treeNodesChanged(treeModelEvent);
        }
    }

    public void nodeStructureChanged(TreeNode treeNode) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, this.getPathToRoot(treeNode, 0), null, null);
        ((TreeModelListener)this.b.getMulticaster()).treeStructureChanged(treeModelEvent);
    }

    protected TreeNode[] getPathToRoot(TreeNode treeNode, int n2) {
        TreeNode[] treeNodeArray;
        if (treeNode == null) {
            if (n2 == 0) {
                return null;
            }
            treeNodeArray = new TreeNode[n2];
        } else {
            treeNodeArray = treeNode == this.c ? new TreeNode[n2] : this.getPathToRoot(treeNode.getParent(), ++n2);
            treeNodeArray[treeNodeArray.length - n2] = treeNode;
        }
        return treeNodeArray;
    }

    public void removeNodeFromParent(TreeBuilderNode treeBuilderNode) {
        TreeBuilderNode treeBuilderNode2 = (TreeBuilderNode)treeBuilderNode.getParent();
        if (treeBuilderNode2 != null) {
            treeBuilderNode2.remove(treeBuilderNode);
        }
    }
}

