/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.JavaValueModifier;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.ArrayElementDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.frame.XValueModifier;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public class ArrayElementDescriptorImpl
extends ValueDescriptorImpl
implements ArrayElementDescriptor {
    private final int q;
    private final ArrayReference p;

    public ArrayElementDescriptorImpl(Project project2, ArrayReference arrayReference, int n2) {
        super(project2);
        this.p = arrayReference;
        this.q = n2;
        this.setLvalue(true);
    }

    @Override
    public int getIndex() {
        return this.q;
    }

    @Override
    public ArrayReference getArray() {
        return this.p;
    }

    @Override
    public String getName() {
        return String.valueOf(this.q);
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        return ArrayElementDescriptorImpl.getArrayElement(this.p, this.q);
    }

    public static Value getArrayElement(ArrayReference arrayReference, int n2) throws EvaluateException {
        try {
            return arrayReference.getValue(n2);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw EvaluateExceptionUtil.ARRAY_WAS_COLLECTED;
        }
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext debuggerContext) throws EvaluateException {
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        try {
            return psiElementFactory.createExpressionFromText("this[" + this.q + "]", null);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            throw new EvaluateException(incorrectOperationException.getMessage(), (Throwable)incorrectOperationException);
        }
    }

    @Override
    public XValueModifier getModifier(JavaValue javaValue) {
        return new JavaValueModifier(javaValue){

            @Override
            protected void setValueImpl(@NotNull String string, @NotNull XValueModifier.XModificationCallback xModificationCallback) {
                block10: {
                    ArrayReference arrayReference;
                    ArrayElementDescriptorImpl arrayElementDescriptorImpl;
                    block11: {
                        try {
                            if (string == null) {
                                1.b(0);
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw 1.a(illegalArgumentException);
                        }
                        try {
                            if (xModificationCallback == null) {
                                1.b(1);
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw 1.a(illegalArgumentException);
                        }
                        arrayElementDescriptorImpl = ArrayElementDescriptorImpl.this;
                        arrayReference = arrayElementDescriptorImpl.getArray();
                        try {
                            try {
                                if (arrayReference == null) break block10;
                                if (!VirtualMachineProxyImpl.isCollected(arrayReference)) break block11;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw 1.a(illegalArgumentException);
                            }
                            Messages.showWarningDialog((Project)ArrayElementDescriptorImpl.this.getProject(), (String)(DebuggerBundle.message((String)"evaluation.error.array.collected", (Object[])new Object[0]) + "\n" + DebuggerBundle.message((String)"warning.recalculate", (Object[])new Object[0])), (String)DebuggerBundle.message((String)"title.set.value", (Object[])new Object[0]));
                            return;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw 1.a(illegalArgumentException);
                        }
                    }
                    final ArrayType arrayType = (ArrayType)arrayReference.referenceType();
                    final DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(ArrayElementDescriptorImpl.this.getProject()).getContext();
                    this.set(string, xModificationCallback, debuggerContextImpl, new JavaValueModifier.SetValueRunnable(){

                        @Override
                        public void setValue(EvaluationContextImpl evaluationContextImpl, Value value) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                            arrayReference.setValue(arrayElementDescriptorImpl.getIndex(), 1.preprocessValue(evaluationContextImpl, value, arrayType.componentType()));
                            1.update(debuggerContextImpl);
                        }

                        @Override
                        public ReferenceType loadClass(EvaluationContextImpl evaluationContextImpl, String string) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
                            return evaluationContextImpl.getDebugProcess().loadClass(evaluationContextImpl, string, arrayType.classLoader());
                        }
                    });
                }
            }

            /*
             * Exception decompiling
             */
            private static /* synthetic */ void b(int var0) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[SWITCH]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
                return illegalArgumentException;
            }
        };
    }
}

