/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.JavaValueModifier;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.evaluation.expression.UnsupportedExpressionException;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluatorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.xdebugger.frame.XValueModifier;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EvaluationDescriptor
extends ValueDescriptorImpl {
    private Modifier p;
    protected TextWithImports myText;

    protected EvaluationDescriptor(TextWithImports textWithImports, Project project2, Value value) {
        super(project2, value);
        this.myText = textWithImports;
    }

    protected EvaluationDescriptor(TextWithImports textWithImports, Project project2) {
        super(project2);
        this.setLvalue(false);
        this.myText = textWithImports;
    }

    protected abstract EvaluationContextImpl getEvaluationContext(EvaluationContextImpl var1);

    protected abstract PsiCodeFragment getEvaluationCode(StackFrameContext var1) throws EvaluateException;

    public PsiCodeFragment createCodeFragment(PsiElement psiElement) {
        TextWithImports textWithImports = this.getEvaluationText();
        return DebuggerUtilsEx.findAppropriateCodeFragmentFactory(textWithImports, psiElement).createCodeFragment(textWithImports, psiElement, this.myProject);
    }

    @Override
    public final Value calcValue(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        try {
            boolean bl2;
            EvaluationDescriptor evaluationDescriptor;
            PsiDocumentManager.getInstance((Project)this.myProject).commitAndRunReadAction(() -> {});
            EvaluationContextImpl evaluationContextImpl2 = this.getEvaluationContext(evaluationContextImpl);
            SourcePosition sourcePosition = ContextUtil.getSourcePosition((StackFrameContext)evaluationContextImpl);
            PsiElement psiElement = ContextUtil.getContextElement((StackFrameContext)evaluationContextImpl, sourcePosition);
            ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)ReadAction.compute(() -> {
                PsiCodeFragment psiCodeFragment = this.getEvaluationCode((StackFrameContext)evaluationContextImpl2);
                try {
                    return DebuggerUtilsEx.findAppropriateCodeFragmentFactory(this.getEvaluationText(), psiElement).getEvaluatorBuilder().build((PsiElement)psiCodeFragment, sourcePosition);
                }
                catch (UnsupportedExpressionException unsupportedExpressionException) {
                    ExpressionEvaluator expressionEvaluator = CompilingEvaluatorImpl.create(this.myProject, psiCodeFragment.getContext(), psiElement -> psiCodeFragment);
                    try {
                        if (expressionEvaluator != null) {
                            return expressionEvaluator;
                        }
                    }
                    catch (UnsupportedExpressionException unsupportedExpressionException2) {
                        throw EvaluationDescriptor.c((Exception)((Object)unsupportedExpressionException2));
                    }
                    throw unsupportedExpressionException;
                }
            });
            try {
                if (!evaluationContextImpl2.getDebugProcess().isAttached()) {
                    throw EvaluateExceptionUtil.PROCESS_EXITED;
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                throw EvaluationDescriptor.c((Exception)((Object)indexNotReadyException));
            }
            StackFrameProxyImpl stackFrameProxyImpl = evaluationContextImpl2.getFrameProxy();
            try {
                if (stackFrameProxyImpl == null) {
                    throw EvaluateExceptionUtil.NULL_STACK_FRAME;
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                throw EvaluationDescriptor.c((Exception)((Object)indexNotReadyException));
            }
            Value value = expressionEvaluator.evaluate((EvaluationContext)evaluationContextImpl2);
            try {
                DebuggerUtilsEx.keep(value, evaluationContextImpl2);
                this.p = expressionEvaluator.getModifier();
                evaluationDescriptor = this;
                bl2 = this.p != null;
            }
            catch (IndexNotReadyException indexNotReadyException) {
                throw EvaluationDescriptor.c((Exception)((Object)indexNotReadyException));
            }
            evaluationDescriptor.setLvalue(bl2);
            return value;
        }
        catch (IndexNotReadyException indexNotReadyException) {
            throw new EvaluateException("Evaluation is not possible during indexing", (Throwable)indexNotReadyException);
        }
        catch (EvaluateException evaluateException) {
            throw new EvaluateException(evaluateException.getLocalizedMessage(), (Throwable)evaluateException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
        }
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext debuggerContext) throws EvaluateException {
        PsiCodeFragment psiCodeFragment = this.getEvaluationCode((StackFrameContext)debuggerContext);
        try {
            if (psiCodeFragment instanceof PsiExpressionCodeFragment) {
                return ((PsiExpressionCodeFragment)psiCodeFragment).getExpression();
            }
        }
        catch (EvaluateException evaluateException) {
            throw EvaluationDescriptor.c((Exception)((Object)evaluateException));
        }
        throw new EvaluateException(DebuggerBundle.message((String)"error.cannot.create.expression.from.code.fragment", (Object[])new Object[0]), null);
    }

    @Override
    protected boolean isPrintExceptionToConsole() {
        return false;
    }

    @Nullable
    public Modifier getModifier() {
        return this.p;
    }

    @Override
    public boolean canSetValue() {
        boolean bl2;
        block7: {
            block6: {
                try {
                    try {
                        try {
                            if (!super.canSetValue() || this.p == null) break block6;
                        }
                        catch (IndexNotReadyException indexNotReadyException) {
                            throw EvaluationDescriptor.c((Exception)((Object)indexNotReadyException));
                        }
                        if (!this.p.canSetValue()) break block6;
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        throw EvaluationDescriptor.c((Exception)((Object)indexNotReadyException));
                    }
                    bl2 = true;
                    break block7;
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    throw EvaluationDescriptor.c((Exception)((Object)indexNotReadyException));
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    public TextWithImports getEvaluationText() {
        return this.myText;
    }

    @Override
    public XValueModifier getModifier(JavaValue javaValue) {
        return new JavaValueModifier(javaValue){

            @Override
            protected void setValueImpl(@NotNull String string, @NotNull XValueModifier.XModificationCallback xModificationCallback) {
                try {
                    if (string == null) {
                        1.b(0);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 1.a(illegalArgumentException);
                }
                try {
                    if (xModificationCallback == null) {
                        1.b(1);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 1.a(illegalArgumentException);
                }
                final EvaluationDescriptor evaluationDescriptor = EvaluationDescriptor.this;
                if (evaluationDescriptor.canSetValue()) {
                    final DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(EvaluationDescriptor.this.getProject()).getContext();
                    this.set(string, xModificationCallback, debuggerContextImpl, new JavaValueModifier.SetValueRunnable(){

                        @Override
                        public void setValue(EvaluationContextImpl evaluationContextImpl, Value value) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                            Modifier modifier = evaluationDescriptor.getModifier();
                            modifier.setValue(1.preprocessValue(evaluationContextImpl, value, modifier.getExpectedType()));
                            1.update(debuggerContextImpl);
                        }

                        @Override
                        public ReferenceType loadClass(EvaluationContextImpl evaluationContextImpl, String string) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
                            return evaluationContextImpl.getDebugProcess().loadClass(evaluationContextImpl, string, evaluationContextImpl.getClassLoader());
                        }
                    });
                }
            }

            /*
             * Exception decompiling
             */
            private static /* synthetic */ void b(int var0) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[SWITCH]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
                return illegalArgumentException;
            }
        };
    }

    private static Exception c(Exception exception) {
        return exception;
    }
}

