/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.JavaValueModifier;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.ViewsGeneralSettings;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.frame.XValueModifier;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldDescriptorImpl
extends ValueDescriptorImpl
implements FieldDescriptor {
    public static final String OUTER_LOCAL_VAR_FIELD_PREFIX = "val$";
    private final Field p;
    private final ObjectReference r;
    private Boolean s;
    private final boolean q;

    public FieldDescriptorImpl(Project project2, ObjectReference objectReference, @NotNull Field field) {
        if (field == null) {
            FieldDescriptorImpl.b(0);
        }
        super(project2);
        this.s = null;
        this.r = objectReference;
        this.p = field;
        this.q = field.isStatic();
        this.setLvalue(!field.isFinal());
    }

    @Override
    public Field getField() {
        return this.p;
    }

    @Override
    public ObjectReference getObject() {
        return this.r;
    }

    @Override
    public void setAncestor(NodeDescriptor nodeDescriptor) {
        super.setAncestor(nodeDescriptor);
        Boolean bl2 = ((FieldDescriptorImpl)nodeDescriptor).s;
        try {
            if (bl2 != null) {
                this.s = bl2;
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw FieldDescriptorImpl.b(objectCollectedException);
        }
    }

    @Override
    public boolean isPrimitive() {
        if (this.s == null) {
            Value value = this.getValue();
            try {
                this.s = value != null ? Boolean.valueOf(super.isPrimitive()) : Boolean.valueOf(DebuggerUtils.isPrimitiveType((String)this.p.typeName()));
            }
            catch (ObjectCollectedException objectCollectedException) {
                throw FieldDescriptorImpl.b(objectCollectedException);
            }
        }
        return this.s;
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            if (this.r != null) {
                Value value = this.r.getValue(this.p);
                if (this.a(value, evaluationContextImpl)) {
                    value = this.r.getValue(this.p);
                }
                return value;
            }
            return this.p.declaringType().getValue(this.p);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
        }
    }

    /*
     * Loose catch block
     */
    private boolean a(Value value, EvaluationContextImpl evaluationContextImpl) {
        block10: {
            block12: {
                block11: {
                    if (!"stackTrace".equals(this.getName())) break block10;
                    if (!ViewsGeneralSettings.getInstance().POPULATE_THROWABLE_STACKTRACE) break block10;
                    break block11;
                    catch (Throwable throwable) {
                        throw FieldDescriptorImpl.b(throwable);
                    }
                }
                if (!(value instanceof ArrayReference)) break block10;
                break block12;
                catch (Throwable throwable) {
                    throw FieldDescriptorImpl.b(throwable);
                }
            }
            try {
                block13: {
                    if (((ArrayReference)value).length() != 0) break block10;
                    break block13;
                    catch (Throwable throwable) {
                        throw FieldDescriptorImpl.b(throwable);
                    }
                }
                if (!DebuggerUtils.instanceOf((Type)this.r.type(), (String)"java.lang.Throwable")) break block10;
            }
            catch (Throwable throwable) {
                throw FieldDescriptorImpl.b(throwable);
            }
            try {
                FieldDescriptorImpl.invokeExceptionGetStackTrace(this.r, evaluationContextImpl);
                return true;
            }
            catch (Throwable throwable) {
                LOG.info(throwable);
            }
        }
        return false;
    }

    public boolean isStatic() {
        return this.q;
    }

    @Override
    public String getName() {
        return this.p.name();
    }

    @Override
    public String calcValueName() {
        String string = super.calcValueName();
        try {
            if (Boolean.TRUE.equals(this.getUserData(SHOW_DECLARING_TYPE))) {
                return NodeRendererSettings.getInstance().getClassRenderer().renderTypeName(this.p.declaringType().name()) + "." + string;
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw FieldDescriptorImpl.b(objectCollectedException);
        }
        return string;
    }

    /*
     * Loose catch block
     */
    public boolean isOuterLocalVariableValue() {
        try {
            boolean bl2;
            block7: {
                block6: {
                    if (!DebuggerUtils.isSynthetic((TypeComponent)this.p)) break block6;
                    try {
                        block8: {
                            if (!this.p.name().startsWith(OUTER_LOCAL_VAR_FIELD_PREFIX)) break block6;
                            break block8;
                            catch (UnsupportedOperationException unsupportedOperationException) {
                                throw FieldDescriptorImpl.b(unsupportedOperationException);
                            }
                        }
                        bl2 = true;
                        break block7;
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        throw FieldDescriptorImpl.b(unsupportedOperationException);
                    }
                }
                bl2 = false;
            }
            return bl2;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return false;
        }
    }

    @Override
    @Nullable
    public String getDeclaredType() {
        return this.p.typeName();
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext debuggerContext) throws EvaluateException {
        String string;
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        if (this.isStatic()) {
            String string2 = this.p.declaringType().name().replace('$', '.');
            string2 = DebuggerTreeNodeExpression.normalize(string2, PositionUtil.getContextElement((StackFrameContext)debuggerContext), this.myProject);
            string = string2 + "." + this.getName();
        } else {
            String string3;
            try {
                string3 = this.isOuterLocalVariableValue() ? StringUtil.trimStart((String)this.getName(), (String)OUTER_LOCAL_VAR_FIELD_PREFIX) : "this." + this.getName();
            }
            catch (IncorrectOperationException incorrectOperationException) {
                throw FieldDescriptorImpl.b(incorrectOperationException);
            }
            string = string3;
        }
        try {
            return psiElementFactory.createExpressionFromText(string, null);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.field.name", (Object[])new Object[]{this.getName()}), (Throwable)incorrectOperationException);
        }
    }

    @Override
    public XValueModifier getModifier(JavaValue javaValue) {
        return new JavaValueModifier(javaValue){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            protected void setValueImpl(@NotNull String string, @NotNull XValueModifier.XModificationCallback xModificationCallback) {
                try {
                    if (string == null) {
                        1.b(0);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 1.a(illegalArgumentException);
                }
                try {
                    if (xModificationCallback == null) {
                        1.b(1);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 1.a(illegalArgumentException);
                }
                final DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(FieldDescriptorImpl.this.getProject()).getContext();
                FieldDescriptorImpl fieldDescriptorImpl = FieldDescriptorImpl.this;
                final Field field = fieldDescriptorImpl.getField();
                if (!field.isStatic()) {
                    final ObjectReference objectReference = fieldDescriptorImpl.getObject();
                    try {
                        if (objectReference == null) return;
                        this.set(string, xModificationCallback, debuggerContextImpl, new JavaValueModifier.SetValueRunnable(){

                            @Override
                            public void setValue(EvaluationContextImpl evaluationContextImpl, Value value) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                                objectReference.setValue(field, 1.preprocessValue(evaluationContextImpl, value, field.type()));
                                1.update(debuggerContextImpl);
                            }

                            @Override
                            public ReferenceType loadClass(EvaluationContextImpl evaluationContextImpl, String string) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
                                return evaluationContextImpl.getDebugProcess().loadClass(evaluationContextImpl, string, field.declaringType().classLoader());
                            }
                        });
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw 1.a(illegalArgumentException);
                    }
                } else {
                    ReferenceType referenceType = field.declaringType();
                    if (!(referenceType instanceof ClassType)) return;
                    final ClassType classType = (ClassType)referenceType;
                    this.set(string, xModificationCallback, debuggerContextImpl, new JavaValueModifier.SetValueRunnable(){

                        @Override
                        public void setValue(EvaluationContextImpl evaluationContextImpl, Value value) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                            classType.setValue(field, 1.preprocessValue(evaluationContextImpl, value, field.type()));
                            1.update(debuggerContextImpl);
                        }

                        @Override
                        public ReferenceType loadClass(EvaluationContextImpl evaluationContextImpl, String string) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
                            return evaluationContextImpl.getDebugProcess().loadClass(evaluationContextImpl, string, field.declaringType().classLoader());
                        }
                    });
                }
            }

            /*
             * Exception decompiling
             */
            private static /* synthetic */ void b(int var0) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[SWITCH]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
                return illegalArgumentException;
            }
        };
    }

    private static /* synthetic */ void b(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/debugger/ui/impl/watch/FieldDescriptorImpl", "<init>"));
    }

    private static Throwable b(Throwable throwable) {
        return throwable;
    }
}

