/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.ImageObjectRenderer;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class GraphicsObjectRenderer
extends CompoundReferenceRenderer
implements FullValueEvaluatorProvider {
    public GraphicsObjectRenderer(NodeRendererSettings nodeRendererSettings) {
        super(nodeRendererSettings, "Graphics", null, null);
        this.setClassName("sun.java2d.SunGraphics2D");
        this.setEnabled(true);
    }

    @Override
    @Nullable
    public XFullValueEvaluator getFullValueEvaluator(EvaluationContextImpl evaluationContextImpl, ValueDescriptorImpl valueDescriptorImpl) {
        try {
            Value value;
            block8: {
                ObjectReference objectReference = (ObjectReference)valueDescriptorImpl.getValue();
                Field field = ((ClassType)objectReference.type()).fieldByName("surfaceData");
                if (field == null) {
                    return null;
                }
                ObjectReference objectReference2 = (ObjectReference)objectReference.getValue(field);
                if (objectReference2 == null) {
                    return null;
                }
                Field field2 = ((ReferenceType)objectReference2.type()).fieldByName("bufImg");
                if (field2 == null) {
                    field2 = ((ReferenceType)objectReference2.type()).fieldByName("offscreenImage");
                }
                if (field2 == null) {
                    return null;
                }
                value = objectReference2.getValue(field2);
                Type type = value.type();
                try {
                    if (type instanceof ReferenceType && DebuggerUtils.instanceOf((Type)type, (String)"java.awt.Image")) break block8;
                }
                catch (Exception exception) {
                    throw GraphicsObjectRenderer.b(exception);
                }
                return null;
            }
            return new ImageObjectRenderer.IconPopupEvaluator(DebuggerBundle.message((String)"message.node.show.image", (Object[])new Object[0]), evaluationContextImpl){

                @Override
                protected Icon getData() {
                    return ImageObjectRenderer.getIcon(this.getEvaluationContext(), value, "imageToBytes");
                }
            };
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

