/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.debugger.ui.tree.render.PrimitiveRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ByteType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharType;
import com.sun.jdi.CharValue;
import com.sun.jdi.IntegerType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongType;
import com.sun.jdi.LongValue;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HexRenderer
extends NodeRendererImpl {
    @NonNls
    public static final String UNIQUE_ID = "HexRenderer";
    private static final Logger b = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.HexRenderer");

    public HexRenderer() {
        this.setEnabled(false);
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    @NonNls
    public String getName() {
        return "Hex";
    }

    @Override
    public void setName(String string) {
    }

    @Override
    public HexRenderer clone() {
        return (HexRenderer)super.clone();
    }

    @Override
    public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener descriptorLabelListener) {
        Value value = valueDescriptor.getValue();
        StringBuilder stringBuilder = new StringBuilder();
        try {
            if (value == null) {
                return "null";
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw HexRenderer.a(illegalArgumentException);
        }
        try {
            if (value instanceof CharValue) {
                PrimitiveRenderer.appendCharValue((CharValue)value, stringBuilder);
                stringBuilder.append(' ');
                HexRenderer.appendHexValue((PrimitiveValue)value, stringBuilder);
                return stringBuilder.toString();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw HexRenderer.a(illegalArgumentException);
        }
        HexRenderer.appendHexValue((PrimitiveValue)value, stringBuilder);
        return stringBuilder.toString();
    }

    static void appendHexValue(@NotNull PrimitiveValue primitiveValue, StringBuilder stringBuilder) {
        block16: {
            try {
                if (primitiveValue == null) {
                    HexRenderer.b(0);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw HexRenderer.a(illegalArgumentException);
            }
            if (primitiveValue instanceof CharValue) {
                long l2 = primitiveValue.longValue();
                stringBuilder.append("0x").append(Long.toHexString(l2).toUpperCase());
            } else if (primitiveValue instanceof ByteValue) {
                String string = Integer.toHexString(primitiveValue.byteValue()).toUpperCase();
                if (string.length() > 2) {
                    string = string.substring(string.length() - 2);
                }
                stringBuilder.append("0x").append(string);
            } else if (primitiveValue instanceof ShortValue) {
                String string = Integer.toHexString(primitiveValue.shortValue()).toUpperCase();
                if (string.length() > 4) {
                    string = string.substring(string.length() - 4);
                }
                stringBuilder.append("0x").append(string);
            } else {
                block17: {
                    block15: {
                        try {
                            if (!(primitiveValue instanceof IntegerValue)) break block15;
                            stringBuilder.append("0x").append(Integer.toHexString(primitiveValue.intValue()).toUpperCase());
                            break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw HexRenderer.a(illegalArgumentException);
                        }
                    }
                    try {
                        if (!(primitiveValue instanceof LongValue)) break block17;
                        stringBuilder.append("0x").append(Long.toHexString(primitiveValue.longValue()).toUpperCase());
                        break block16;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw HexRenderer.a(illegalArgumentException);
                    }
                }
                b.assertTrue(false);
            }
        }
    }

    @Override
    public boolean isApplicable(Type type) {
        boolean bl2;
        block15: {
            block14: {
                try {
                    if (type == null) {
                        return false;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw HexRenderer.a(illegalArgumentException);
                }
                try {
                    block13: {
                        try {
                            try {
                                try {
                                    try {
                                        if (type instanceof CharType || type instanceof ByteType) break block13;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw HexRenderer.a(illegalArgumentException);
                                    }
                                    if (type instanceof ShortType) break block13;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw HexRenderer.a(illegalArgumentException);
                                }
                                if (type instanceof IntegerType) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw HexRenderer.a(illegalArgumentException);
                            }
                            if (!(type instanceof LongType)) break block14;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw HexRenderer.a(illegalArgumentException);
                        }
                    }
                    bl2 = true;
                    break block15;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw HexRenderer.a(illegalArgumentException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    private static /* synthetic */ void b(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/debugger/ui/tree/render/HexRenderer", "appendHexValue"));
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }
}

