/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.CustomPopupFullValueEvaluator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.rt.debugger.ImageSerializer;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ByteValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.Value;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.intellij.images.editor.impl.ImageEditorManagerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImageObjectRenderer
extends CompoundReferenceRenderer
implements FullValueEvaluatorProvider {
    private static final Logger e = Logger.getInstance(ImageObjectRenderer.class);

    public ImageObjectRenderer(NodeRendererSettings nodeRendererSettings) {
        super(nodeRendererSettings, "Image", null, null);
        this.setClassName("java.awt.Image");
        this.setEnabled(true);
    }

    @Override
    @Nullable
    public XFullValueEvaluator getFullValueEvaluator(EvaluationContextImpl evaluationContextImpl, final ValueDescriptorImpl valueDescriptorImpl) {
        return new IconPopupEvaluator(DebuggerBundle.message((String)"message.node.show.image", (Object[])new Object[0]), evaluationContextImpl){

            @Override
            protected Icon getData() {
                return ImageObjectRenderer.getIcon(this.getEvaluationContext(), valueDescriptorImpl.getValue(), "imageToBytes");
            }
        };
    }

    static JComponent createIconViewer(@Nullable Icon icon) {
        if (icon == null) {
            return new JLabel("No data", 0);
        }
        int n2 = icon.getIconWidth();
        int n3 = icon.getIconHeight();
        BufferedImage bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(n2, n3, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        return ImageEditorManagerImpl.createImageEditorUI((BufferedImage)bufferedImage);
    }

    @Nullable
    static ImageIcon getIcon(EvaluationContext evaluationContext, Value value, String string) {
        try {
            Value value2 = ImageObjectRenderer.a(evaluationContext, value, string);
            byte[] byArray = ImageObjectRenderer.a(value2);
            if (byArray != null) {
                return new ImageIcon(byArray);
            }
        }
        catch (Exception exception) {
            e.info("Exception while getting image data", (Throwable)exception);
        }
        return null;
    }

    private static Value a(EvaluationContext evaluationContext, Value value, String string) throws EvaluateException {
        DebugProcess debugProcess = evaluationContext.getDebugProcess();
        EvaluationContext evaluationContext2 = evaluationContext.createEvaluationContext(value);
        ClassType classType = ClassLoadingUtils.getHelperClass(ImageSerializer.class.getName(), evaluationContext2, debugProcess);
        if (classType != null) {
            List<Method> list = classType.methodsByName(string);
            try {
                if (!list.isEmpty()) {
                    return debugProcess.invokeMethod(evaluationContext2, classType, list.get(0), Collections.singletonList(value));
                }
            }
            catch (EvaluateException evaluateException) {
                throw ImageObjectRenderer.a(evaluateException);
            }
        }
        return null;
    }

    private static byte[] a(Value value) {
        if (value instanceof ArrayReference) {
            List<Value> list = ((ArrayReference)value).getValues();
            byte[] byArray = new byte[list.size()];
            int n2 = 0;
            for (Value value2 : list) {
                if (value2 instanceof ByteValue) {
                    byArray[n2++] = ((ByteValue)value2).value();
                    continue;
                }
                return null;
            }
            return byArray;
        }
        return null;
    }

    private static EvaluateException a(EvaluateException evaluateException) {
        return evaluateException;
    }

    /*
     * Exception performing whole class analysis ignored.
     */
    static abstract class IconPopupEvaluator
    extends CustomPopupFullValueEvaluator<Icon> {
        public IconPopupEvaluator(@NotNull String string, @NotNull EvaluationContextImpl evaluationContextImpl) {
            if (string == null) {
                IconPopupEvaluator.c(0);
            }
            if (evaluationContextImpl == null) {
                IconPopupEvaluator.c(1);
            }
            super(string, evaluationContextImpl);
        }

        @Override
        protected JComponent createComponent(Icon icon) {
            return ImageObjectRenderer.createIconViewer(icon);
        }

        /*
         * Exception decompiling
         */
        private static /* synthetic */ void c(int var0) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static IllegalArgumentException d(IllegalArgumentException illegalArgumentException) {
            return illegalArgumentException;
        }
    }
}

