/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.execution.filters.ExceptionFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StackTraceElementObjectRenderer
extends CompoundReferenceRenderer
implements FullValueEvaluatorProvider {
    private static final Logger e = Logger.getInstance(StackTraceElementObjectRenderer.class);

    public StackTraceElementObjectRenderer(NodeRendererSettings nodeRendererSettings) {
        super(nodeRendererSettings, "StackTraceElement", null, null);
        this.setClassName("java.lang.StackTraceElement");
        this.setEnabled(true);
    }

    @Override
    @Nullable
    public XFullValueEvaluator getFullValueEvaluator(final EvaluationContextImpl evaluationContextImpl, final ValueDescriptorImpl valueDescriptorImpl) {
        return new JavaValue.JavaFullValueEvaluator(DebuggerBundle.message((String)"message.node.navigate", (Object[])new Object[0]), evaluationContextImpl){

            @Override
            public void evaluate(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback xFullValueEvaluationCallback) {
                try {
                    if (xFullValueEvaluationCallback == null) {
                        1.b(0);
                    }
                }
                catch (EvaluateException evaluateException) {
                    throw 1.b((Exception)((Object)evaluateException));
                }
                Value value = valueDescriptorImpl.getValue();
                ClassType classType = (ClassType)value.type();
                Method method = classType.concreteMethodByName("toString", "()Ljava/lang/String;");
                if (method != null) {
                    try {
                        Value value2 = evaluationContextImpl.getDebugProcess().invokeMethod((EvaluationContext)evaluationContextImpl, (ObjectReference)value, method, Collections.emptyList());
                        if (value2 instanceof StringReference) {
                            xFullValueEvaluationCallback.evaluated("");
                            String string = ((StringReference)value2).value();
                            ApplicationManager.getApplication().runReadAction(() -> {
                                ExceptionFilter exceptionFilter = new ExceptionFilter(evaluationContextImpl.getDebugProcess().getSession().getSearchScope());
                                Filter.Result result2 = exceptionFilter.applyFilter(string, string.length());
                                if (result2 != null) {
                                    HyperlinkInfo hyperlinkInfo = result2.getFirstHyperlinkInfo();
                                    try {
                                        if (hyperlinkInfo != null) {
                                            DebuggerUIUtil.invokeLater(() -> hyperlinkInfo.navigate(valueDescriptorImpl.getProject()));
                                        }
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw 1.b(illegalArgumentException);
                                    }
                                }
                            });
                        }
                    }
                    catch (EvaluateException evaluateException) {
                        e.info("Exception while getting stack info", (Throwable)evaluateException);
                    }
                }
            }

            public boolean isShowValuePopup() {
                return false;
            }

            private static /* synthetic */ void b(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/ui/tree/render/StackTraceElementObjectRenderer$1", "evaluate"));
            }

            private static Exception b(Exception exception) {
                return exception;
            }
        };
    }
}

