/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;

public abstract class UnboxableTypeRenderer
extends CompoundReferenceRenderer {
    public UnboxableTypeRenderer(String string, NodeRendererSettings nodeRendererSettings) {
        super(nodeRendererSettings, StringUtil.getShortName((String)string), new LabelRenderer(){

            @Override
            public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
                return DebuggerUtils.getValueAsString((EvaluationContext)evaluationContext, (Value)UnBoxingEvaluator.getInnerPrimitiveValue((ObjectReference)valueDescriptor.getValue()));
            }

            @Override
            public boolean isOnDemand(EvaluationContext evaluationContext, ValueDescriptor valueDescriptor) {
                return false;
            }
        }, null);
        LOG.assertTrue(UnBoxingEvaluator.isTypeUnboxable(string));
        this.setClassName(string);
        this.setEnabled(true);
    }

    @Override
    public boolean isApplicable(Type type) {
        return type instanceof ReferenceType && StringUtil.equals((CharSequence)type.name(), (CharSequence)this.getClassName());
    }

    public static class DoubleRenderer
    extends UnboxableTypeRenderer {
        public DoubleRenderer(NodeRendererSettings nodeRendererSettings) {
            super("java.lang.Double", nodeRendererSettings);
        }
    }

    public static class FloatRenderer
    extends UnboxableTypeRenderer {
        public FloatRenderer(NodeRendererSettings nodeRendererSettings) {
            super("java.lang.Float", nodeRendererSettings);
        }
    }

    public static class LongRenderer
    extends UnboxableTypeRenderer {
        public LongRenderer(NodeRendererSettings nodeRendererSettings) {
            super("java.lang.Long", nodeRendererSettings);
        }
    }

    public static class IntegerRenderer
    extends UnboxableTypeRenderer {
        public IntegerRenderer(NodeRendererSettings nodeRendererSettings) {
            super("java.lang.Integer", nodeRendererSettings);
        }
    }

    public static class ShortRenderer
    extends UnboxableTypeRenderer {
        public ShortRenderer(NodeRendererSettings nodeRendererSettings) {
            super("java.lang.Short", nodeRendererSettings);
        }
    }

    public static class CharacterRenderer
    extends UnboxableTypeRenderer {
        public CharacterRenderer(NodeRendererSettings nodeRendererSettings) {
            super("java.lang.Character", nodeRendererSettings);
        }
    }

    public static class ByteRenderer
    extends UnboxableTypeRenderer {
        public ByteRenderer(NodeRendererSettings nodeRendererSettings) {
            super("java.lang.Byte", nodeRendererSettings);
        }
    }

    public static class BooleanRenderer
    extends UnboxableTypeRenderer {
        public BooleanRenderer(NodeRendererSettings nodeRendererSettings) {
            super("java.lang.Boolean", nodeRendererSettings);
        }
    }
}

