/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.componentTree;

import com.intellij.designer.clipboard.SimpleTransferable;
import com.intellij.designer.componentTree.ComponentTree;
import com.intellij.designer.componentTree.TreeTransfer;
import com.intellij.designer.designSurface.ComponentTargetFilter;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.tools.CreationTool;
import com.intellij.designer.designSurface.tools.ToolProvider;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadComponentVisitor;
import com.intellij.designer.model.RadLayout;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.designer.utils.Cursors;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ArrayUtil;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;

public class TreeDropListener
extends DropTargetAdapter {
    private final EditableArea i;
    private final ToolProvider h;
    private final Class[] g;
    private final OperationContext b = new OperationContext();
    private DropTargetDragEvent c;
    private EditOperation f;
    private RadComponent e;
    private boolean j;
    private boolean a;
    private static final Cursor d = Cursors.getMoveCursor();

    public TreeDropListener(ComponentTree componentTree, EditableArea editableArea, ToolProvider toolProvider) {
        this((JComponent)((Object)componentTree), editableArea, toolProvider, TreeDropListener.class, PaletteItem.class);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            componentTree.setDragEnabled(true);
            componentTree.setTransferHandler(new TreeTransfer(TreeDropListener.class));
        }
    }

    public TreeDropListener(JComponent jComponent, EditableArea editableArea, ToolProvider toolProvider, Class ... classArray) {
        this.i = editableArea;
        this.b.setArea(editableArea);
        this.h = toolProvider;
        this.g = classArray;
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            jComponent.setDropTarget(new DropTarget(jComponent, this));
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.a();
        this.b(false);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.c = dropTargetDragEvent;
        this.b();
        this.f();
        this.g();
        this.d();
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
        this.a();
        this.c();
        this.b(true);
        dropTargetDropEvent.dropComplete(true);
    }

    private void d() {
        if (this.f != null) {
            this.f.showFeedback();
        }
        this.a = true;
    }

    private void a() {
        if (this.a) {
            this.a = false;
            if (this.f != null) {
                this.f.eraseFeedback();
            }
        }
    }

    /*
     * Loose catch block
     */
    private void b() {
        block10: {
            block11: {
                this.b.setLocation(this.e());
                if (this.b.getComponents() != null) break block10;
                try {
                    block12: {
                        if (ArrayUtil.contains((Object)SimpleTransferable.getData(this.c.getTransferable(), Class.class), (Object[])this.g)) break block11;
                        break block12;
                        catch (Throwable throwable) {
                            throw TreeDropListener.b(throwable);
                        }
                    }
                    this.b.setComponents(Collections.emptyList());
                    return;
                }
                catch (Throwable throwable) {
                    throw TreeDropListener.b(throwable);
                }
            }
            if (this.h.getActiveTool() instanceof CreationTool) {
                this.b.setType("create_children");
                CreationTool creationTool = (CreationTool)this.h.getActiveTool();
                try {
                    this.b.setComponents(Collections.singletonList(creationTool.getFactory().create()));
                }
                catch (Throwable throwable) {
                    this.b.setComponents(Collections.emptyList());
                    this.h.loadDefaultTool();
                }
                return;
            }
            List<RadComponent> list = RadComponent.getPureSelection(this.i.getSelection());
            RadComponent radComponent = null;
            for (RadComponent radComponent2 : list) {
                if (radComponent == null) {
                    radComponent = radComponent2.getParent();
                    continue;
                }
                if (radComponent == radComponent2.getParent()) continue;
                list = Collections.emptyList();
                break;
            }
            this.b.setComponents(list);
            this.b.resetMoveAddEnabled();
            for (RadComponent radComponent2 : list) {
                radComponent2.processDropOperation(this.b);
            }
        }
    }

    private void f() {
        if (this.b.getComponents().isEmpty()) {
            return;
        }
        final ArrayList<RadComponent> arrayList = new ArrayList<RadComponent>(this.b.getComponents());
        if (!this.b.isCreate()) {
            for (RadComponent object2 : this.b.getComponents()) {
                object2.accept(new RadComponentVisitor(){

                    @Override
                    public void endVisit(RadComponent radComponent) {
                        arrayList.add(radComponent);
                    }
                }, true);
            }
        }
        final EditOperation[] editOperationArray = new EditOperation[1];
        ComponentTargetFilter componentTargetFilter = new ComponentTargetFilter(){

            @Override
            public boolean preFilter(RadComponent radComponent) {
                return TreeDropListener.this.b.isCreate() || !arrayList.contains((Object)radComponent);
            }

            @Override
            public boolean resultFilter(RadComponent radComponent) {
                if (!TreeDropListener.this.b.isCreate()) {
                    if (TreeDropListener.this.b.getComponents().get(0).getParent() == radComponent) {
                        TreeDropListener.this.b.setType("move_children");
                    } else {
                        TreeDropListener.this.b.setType("add_children");
                    }
                }
                if (TreeDropListener.this.e == radComponent) {
                    return true;
                }
                RadLayout radLayout = radComponent.getLayout();
                if (radLayout != null) {
                    editOperationArray[0] = radLayout.processChildOperation(TreeDropListener.this.b);
                }
                return editOperationArray[0] != null;
            }
        };
        Point point = this.e();
        RadComponent radComponent = this.i.findTarget(point.x, point.y, componentTargetFilter);
        if (radComponent != this.e) {
            if (this.f != null) {
                this.a();
            }
            this.e = radComponent;
            this.f = editOperationArray[0];
        }
        if (radComponent == null) {
            if (!this.b.isCreate()) {
                this.b.setType(null);
            }
        } else {
            this.f.setComponents(this.b.getComponents());
        }
    }

    private Point e() {
        return this.c.getLocation();
    }

    private void g() {
        if (this.f != null) {
            if (this.b.isMove()) {
                this.a(this.b.isMoveEnabled() && this.f.canExecute());
            } else if (this.b.isAdd()) {
                this.a(this.b.isAddEnabled() && this.f.canExecute());
            } else if (this.b.isCreate()) {
                this.a(this.f.canExecute());
            } else {
                this.a(false);
            }
        } else {
            this.a(false);
        }
    }

    private void a(boolean bl2) {
        this.j = bl2;
        if (bl2) {
            this.c.acceptDrag(this.c.getDropAction());
            this.i.setCursor(this.b.isCreate() ? Cursors.getCopyCursor() : d);
        } else {
            this.c.rejectDrag();
            this.i.setCursor(Cursors.getSystemNoCursor());
        }
    }

    private void c() {
        if (this.j) {
            this.h.execute(Collections.singletonList(this.f), this.b.getMessage());
            if (this.b.isCreate()) {
                this.i.setSelection(this.b.getComponents());
            }
        }
    }

    private void b(boolean bl2) {
        this.b.setComponents(null);
        this.c = null;
        this.f = null;
        this.e = null;
        this.j = false;
        if (bl2 || !this.b.isCreate()) {
            this.b.setType(null);
            this.h.loadDefaultTool();
        }
        this.i.setCursor(null);
    }

    private static Throwable b(Throwable throwable) {
        return throwable;
    }
}

