/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface;

import com.intellij.designer.DesignerBundle;
import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.feedbacks.LineMarginBorder;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.InplaceContext;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyEditorListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ThrowableRunnable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class InplaceEditingLayer
extends JComponent {
    private static final Logger f = Logger.getInstance((String)"#com.intellij.designer.designSurface.InplaceEditingLayer");
    private final FocusWatcher h = new FocusWatcher(){

        protected void focusLostImpl(FocusEvent focusEvent) {
            Component component = focusEvent.getOppositeComponent();
            if (focusEvent.isTemporary() || component != null && SwingUtilities.isDescendingFrom(component, this.getTopComponent())) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> InplaceEditingLayer.this.a(true), ModalityState.NON_MODAL);
        }
    };
    private final ComponentSelectionListener d = new ComponentSelectionListener(){

        @Override
        public void selectionChanged(EditableArea editableArea) {
            InplaceEditingLayer.this.a(true);
        }
    };
    private PropertyEditorListener g = new PropertyEditorListener(){

        public void valueCommitted(PropertyEditor propertyEditor, boolean bl2, boolean bl3) {
            InplaceEditingLayer.this.a(true);
        }

        public void editingCanceled(PropertyEditor propertyEditor) {
            InplaceEditingLayer.this.a(false);
        }

        public void preferredSizeChanged(PropertyEditor propertyEditor) {
            InplaceEditingLayer.this.a();
        }
    };
    private RadComponent a;
    private List<Property> i;
    private List<PropertyEditor> j;
    private final DesignerEditorPanel c;
    private JComponent e;
    private int b;

    public InplaceEditingLayer(DesignerEditorPanel designerEditorPanel) {
        this.c = designerEditorPanel;
    }

    public void startEditing(@Nullable InplaceContext inplaceContext) {
        try {
            block13: {
                JComponent jComponent;
                JComponent jComponent2;
                block12: {
                    List<RadComponent> list = this.c.getSurfaceArea().getSelection();
                    if (list.size() != 1) {
                        return;
                    }
                    this.a = list.get(0);
                    this.i = this.a.getInplaceProperties();
                    if (this.i.isEmpty()) {
                        this.a = null;
                        this.i = null;
                        return;
                    }
                    this.e = new JPanel((LayoutManager)new GridLayoutManager(this.i.size(), 2));
                    this.e.setBorder(new LineMarginBorder(5, 5, 5, 5));
                    new AnAction(){

                        public void actionPerformed(AnActionEvent anActionEvent) {
                            InplaceEditingLayer.this.a(false);
                        }
                    }.registerCustomShortcutSet(CommonShortcuts.ESCAPE, this.e);
                    this.j = new ArrayList<PropertyEditor>();
                    jComponent2 = null;
                    Font font = null;
                    if (inplaceContext == null) {
                        inplaceContext = new InplaceContext();
                    }
                    int n2 = 0;
                    for (Property object2 : this.i) {
                        jComponent = new JLabel(object2.getName() + ":");
                        if (font == null) {
                            font = jComponent.getFont().deriveFont(1);
                        }
                        jComponent.setFont(font);
                        this.e.add((Component)jComponent, new GridConstraints(n2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
                        PropertyEditor propertyEditor = object2.getEditor();
                        this.j.add(propertyEditor);
                        JComponent jComponent3 = propertyEditor.getComponent((PropertiesContainer)this.a, (PropertyContext)this.c, object2.getValue((PropertiesContainer)this.a), inplaceContext);
                        this.e.add((Component)jComponent3, new GridConstraints(n2++, 1, 1, 1, 0, 1, 2, 0, null, null, null));
                        if (jComponent2 != null) continue;
                        jComponent2 = propertyEditor.getPreferredFocusedComponent();
                    }
                    for (PropertyEditor propertyEditor : this.j) {
                        propertyEditor.addPropertyEditorListener(this.g);
                    }
                    Rectangle rectangle = this.a.getBounds(this);
                    Dimension dimension = this.e.getPreferredSize();
                    this.b = Math.max(dimension.width, rectangle.width);
                    this.e.setBounds(rectangle.x, rectangle.y, this.b, dimension.height);
                    this.add(this.e);
                    this.c.getSurfaceArea().addSelectionListener(this.d);
                    if (jComponent2 == null) {
                        jComponent2 = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)this.e);
                    }
                    if (jComponent2 == null) {
                        jComponent2 = this.e;
                    }
                    try {
                        if (!jComponent2.requestFocusInWindow()) break block12;
                        this.h.install((Component)this.e);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        throw InplaceEditingLayer.b(throwable);
                    }
                }
                this.grabFocus();
                jComponent = jComponent2;
                ApplicationManager.getApplication().invokeLater(() -> {
                    jComponent.requestFocusInWindow();
                    this.h.install((Component)this.e);
                });
            }
            this.enableEvents(16L);
            this.repaint();
        }
        catch (Throwable throwable) {
            f.error(throwable);
        }
    }

    private void a(boolean bl2) {
        this.c.getSurfaceArea().removeSelectionListener(this.d);
        if (this.e != null) {
            if (bl2) {
                this.c.getToolProvider().execute((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> {
                    int n2 = this.i.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Property property = this.i.get(i2);
                        Object object = property.getValue((PropertiesContainer)this.a);
                        Object object2 = this.j.get(i2).getValue();
                        try {
                            if (Comparing.equal((Object)object, (Object)object2)) continue;
                            property.setValue((PropertiesContainer)this.a, object2);
                            continue;
                        }
                        catch (Exception exception) {
                            throw InplaceEditingLayer.b(exception);
                        }
                    }
                }), DesignerBundle.message("command.set.property.value", new Object[0]), true);
            }
            for (PropertyEditor propertyEditor : this.j) {
                propertyEditor.removePropertyEditorListener(this.g);
            }
            this.b();
            this.h.deinstall((Component)this.e);
            this.e = null;
        }
        this.a = null;
        this.i = null;
        this.j = null;
        this.c.getPreferredFocusedComponent().requestFocusInWindow();
        this.disableEvents(16L);
        this.repaint();
    }

    private void a() {
        this.e.revalidate();
        Dimension dimension = this.e.getPreferredSize();
        this.e.setSize(Math.max(dimension.width, this.b), this.e.getHeight());
        this.e.revalidate();
        this.repaint();
    }

    private void b() {
        LayoutFocusTraversalPolicyExt.setOverridenDefaultComponent((JComponent)this.c.getPreferredFocusedComponent());
        try {
            this.remove(this.e);
        }
        finally {
            LayoutFocusTraversalPolicyExt.setOverridenDefaultComponent(null);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.e != null && (501 == mouseEvent.getID() || 502 == mouseEvent.getID())) {
            this.a(true);
        }
        super.processMouseEvent(mouseEvent);
    }

    public boolean isEditing() {
        return this.e != null;
    }

    private static Throwable b(Throwable throwable) {
        return throwable;
    }
}

