/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import com.intellij.designer.designSurface.tools.SelectionTracker;
import com.intellij.designer.designSurface.tools.TargetingTool;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.utils.Cursors;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Collections;
import java.util.List;

public class DragTracker
extends SelectionTracker {
    private static final Cursor h = Cursors.getMoveCursor();

    public DragTracker(RadComponent radComponent) {
        super(radComponent);
        this.setDefaultCursor(Cursors.RESIZE_ALL);
        this.setDisabledCursor(Cursors.getNoCursor());
    }

    @Override
    protected Cursor getDefaultCursor() {
        return this.myState == 0 ? super.getDefaultCursor() : h;
    }

    @Override
    protected void handleButtonUp(int n2) {
        if (this.myState == 3) {
            this.eraseFeedback();
            this.executeCommand();
            this.myState = 0;
        } else {
            super.handleButtonUp(n2);
        }
    }

    @Override
    protected void handleDragInProgress() {
        if (this.myState == 3) {
            this.updateContext();
            this.b();
            this.showFeedback();
            this.updateCommand();
        }
    }

    @Override
    protected void updateCommand() {
        if (this.myTargetOperation != null) {
            if (this.myContext.isMove()) {
                this.setExecuteEnabled(this.myContext.isMoveEnabled() && this.myTargetOperation.canExecute());
            } else if (this.myContext.isAdd()) {
                this.setExecuteEnabled(this.myContext.isAddEnabled() && this.myTargetOperation.canExecute());
            } else {
                this.setExecuteEnabled(false);
            }
        } else {
            this.setExecuteEnabled(false);
        }
    }

    private void b() {
        if (this.myContext.getComponents().isEmpty()) {
            return;
        }
        TargetingTool.ContainerTargetFilter containerTargetFilter = new TargetingTool.ContainerTargetFilter(){

            @Override
            public boolean preFilter(RadComponent radComponent) {
                return !DragTracker.this.myContext.getComponents().contains((Object)radComponent);
            }

            @Override
            protected void updateContext(RadComponent radComponent) {
                DragTracker.this.updateContextType(radComponent);
            }
        };
        RadComponent radComponent = this.myArea.findTarget(this.myCurrentScreenX, this.myCurrentScreenY, containerTargetFilter);
        this.setTarget(radComponent, containerTargetFilter);
        if (radComponent == null) {
            this.myContext.setType(null);
        } else {
            this.myTargetOperation.setComponents(this.myContext.getComponents());
        }
    }

    protected void updateContextType(RadComponent radComponent) {
        if (this.myContext.getComponents().get(0).getParent() == radComponent) {
            this.myContext.setType("move_children");
        } else {
            this.myContext.setType("add_children");
        }
    }

    @Override
    protected void updateContext() {
        super.updateContext();
        this.myContext.setMoveDelta(new Point(this.moveDeltaWidth(), this.moveDeltaHeight()));
        this.myContext.setSizeDelta(new Dimension());
        this.myContext.setLocation(this.getLocation());
        if (this.myContext.getComponents() == null) {
            List<RadComponent> list = this.calculateContextComponents(RadComponent.getPureSelection(this.myArea.getSelection()));
            this.myContext.setComponents(list);
            for (RadComponent radComponent : list) {
                radComponent.processDropOperation(this.myContext);
            }
        }
    }

    protected List<RadComponent> calculateContextComponents(List<RadComponent> list) {
        RadComponent radComponent = null;
        for (RadComponent radComponent2 : list) {
            if (radComponent == null) {
                radComponent = radComponent2.getParent();
                continue;
            }
            if (radComponent == radComponent2.getParent()) continue;
            list = Collections.emptyList();
            break;
        }
        return list;
    }
}

