/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.palette;

import com.intellij.designer.componentTree.TreeTransfer;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.palette.PaletteGroup;
import com.intellij.designer.palette.PaletteGroupComponent;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicListUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaletteItemsComponent
extends JBList {
    private static final SimpleTextAttributes b = new SimpleTextAttributes(4, null);
    private final PaletteGroup f;
    private final DesignerEditorPanel c;
    private int a = -1;
    private boolean e;
    private Integer d;

    public PaletteItemsComponent(PaletteGroup paletteGroup, @Nullable DesignerEditorPanel designerEditorPanel) {
        this.f = paletteGroup;
        this.c = designerEditorPanel;
        this.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return PaletteItemsComponent.this.f.getItems().size();
            }

            @Override
            public Object getElementAt(int n2) {
                return PaletteItemsComponent.this.f.getItems().get(n2);
            }
        });
        ColoredListCellRenderer coloredListCellRenderer = new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList jList, Object object, int n2, boolean bl2, boolean bl3) {
                SimpleTextAttributes simpleTextAttributes;
                String string;
                2 v2;
                PaletteItem paletteItem;
                block12: {
                    block11: {
                        try {
                            if (jList == null) {
                                2.a(0);
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw 2.a(illegalArgumentException);
                        }
                        this.clear();
                        paletteItem = (PaletteItem)object;
                        boolean bl4 = paletteItem.isEnabled();
                        try {
                            this.setEnabled(bl4);
                            if (!bl4) break block11;
                            this.setIcon(paletteItem.getIcon());
                            break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw 2.a(illegalArgumentException);
                        }
                    }
                    this.setIcon(IconLoader.getDisabledIcon((Icon)paletteItem.getIcon()));
                }
                String string2 = paletteItem.getTitle();
                String string3 = paletteItem.getTooltip();
                String string4 = PaletteItemsComponent.this.c.getVersionLabel(paletteItem.getVersion());
                String string5 = paletteItem.getDeprecatedIn();
                boolean bl5 = PaletteItemsComponent.this.c.isDeprecated(string5);
                try {
                    v2 = this;
                    string = string2;
                    simpleTextAttributes = bl5 ? b : SimpleTextAttributes.REGULAR_ATTRIBUTES;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 2.a(illegalArgumentException);
                }
                v2.append(string, simpleTextAttributes);
                if (!string4.isEmpty()) {
                    string4 = "<sup><i>" + string4 + "</i></sup>";
                }
                if (string3 != null) {
                    String string6 = "";
                    if (bl5) {
                        string6 = String.format("<b>This item is deprecated in version \"%1$s\".<br>", PaletteItemsComponent.this.c.getVersionLabel(string5));
                        String string7 = paletteItem.getDeprecatedHint();
                        if (!StringUtil.isEmpty((String)string7)) {
                            string6 = string6 + string7;
                        }
                        string6 = string6 + "</b><br><br>";
                    }
                    string3 = "<html><body><center><b>" + StringUtil.escapeXml((String)string2) + "</b>" + string4 + "</center><p style='width: 300px'>" + string6 + string3 + "</p></body></html>";
                }
                this.setToolTipText(string3);
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/designer/palette/PaletteItemsComponent$2", "customizeCellRenderer"));
            }

            private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
                return illegalArgumentException;
            }
        };
        coloredListCellRenderer.getIpad().left = 2 * UIUtil.getTreeLeftChildIndent();
        coloredListCellRenderer.getIpad().right = UIUtil.getTreeRightChildIndent();
        this.setCellRenderer((ListCellRenderer)coloredListCellRenderer);
        this.setVisibleRowCount(0);
        this.setLayoutOrientation(2);
        this.setSelectionMode(0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PaletteItemsComponent.this.e = SwingUtilities.isLeftMouseButton(mouseEvent) && PaletteItemsComponent.this.a >= 0 && PaletteItemsComponent.this.locationToIndex(mouseEvent.getPoint()) == PaletteItemsComponent.this.a && !UIUtil.isControlKeyDown((MouseEvent)mouseEvent) && !mouseEvent.isShiftDown();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && PaletteItemsComponent.this.a >= 0 && PaletteItemsComponent.this.locationToIndex(mouseEvent.getPoint()) == PaletteItemsComponent.this.a && !UIUtil.isControlKeyDown((MouseEvent)mouseEvent) && !mouseEvent.isShiftDown() && PaletteItemsComponent.this.e) {
                    PaletteItemsComponent.this.clearSelection();
                }
            }
        });
        this.setDragEnabled(true);
        this.setTransferHandler(new TreeTransfer(PaletteItem.class));
        DnDManager.getInstance().registerSource(new DnDSource(){

            public boolean canStartDragging(DnDAction dnDAction, Point point) {
                int n2 = PaletteItemsComponent.this.locationToIndex(point);
                if (n2 != -1 && PaletteItemsComponent.this.c != null) {
                    PaletteItem paletteItem = PaletteItemsComponent.this.f.getItems().get(n2);
                    PaletteItemsComponent.this.c.activatePaletteItem(paletteItem);
                }
                return false;
            }

            public DnDDragStartBean startDragging(DnDAction dnDAction, Point point) {
                return null;
            }

            @Nullable
            public Pair<Image, Point> createDraggedImage(DnDAction dnDAction, Point point) {
                return null;
            }

            public void dragDropEnd() {
            }

            public void dropActionChanged(int n2) {
            }
        }, (JComponent)((Object)this));
        this.a();
    }

    public void updateUI() {
        this.setUI(new BasicListUI(){
            MouseListener myListener;

            @Override
            protected void updateLayoutState() {
                super.updateLayoutState();
                Insets insets = this.list.getInsets();
                int n2 = this.list.getWidth() - (insets.left + insets.right);
                if (n2 >= this.cellWidth) {
                    int n3 = n2 / this.cellWidth;
                    this.cellWidth = n3 == 0 ? 1 : n2 / n3;
                }
            }

            @Override
            protected void installListeners() {
                this.myListener = new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        PaletteItemsComponent.this.a = list.getSelectedIndex();
                    }
                };
                PaletteItemsComponent.this.addMouseListener(this.myListener);
                super.installListeners();
            }

            @Override
            protected void uninstallListeners() {
                if (this.myListener != null) {
                    PaletteItemsComponent.this.removeMouseListener(this.myListener);
                }
                super.uninstallListeners();
            }
        });
        this.invalidate();
    }

    public int getWidth() {
        return this.d == null ? super.getWidth() : this.d.intValue();
    }

    public int getPreferredHeight(int n2) {
        this.d = n2;
        try {
            int n3 = this.getUI().getPreferredSize((JComponent)((Object)this)).height;
            return n3;
        }
        finally {
            this.d = null;
        }
    }

    public void takeFocusFrom(int n2) {
        if (n2 == -1) {
            n2 = this.getModel().getSize() - 1;
        } else if (this.getModel().getSize() == 0) {
            n2 = -1;
        }
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this), true));
        this.setSelectedIndex(n2);
        if (n2 >= 0) {
            this.ensureIndexIsVisible(n2);
        }
    }

    public void restoreSelection(PaletteItem paletteItem) {
        if (paletteItem == null) {
            this.clearSelection();
        } else {
            int n2 = this.f.getItems().indexOf(paletteItem);
            if (n2 == -1) {
                this.clearSelection();
            } else {
                this.takeFocusFrom(n2);
            }
        }
    }

    private void a() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("selectPreviousRow", new MoveFocusAction(actionMap.get("selectPreviousRow"), false));
        actionMap.put("selectNextRow", new MoveFocusAction(actionMap.get("selectNextRow"), true));
        actionMap.put("selectPreviousColumn", new MoveFocusAction(new ChangeColumnAction(actionMap.get("selectPreviousColumn"), false), false));
        actionMap.put("selectNextColumn", new MoveFocusAction(new ChangeColumnAction(actionMap.get("selectNextColumn"), true), true));
    }

    private class ChangeColumnAction
    extends AbstractAction {
        private final Action a;
        private final boolean b;

        public ChangeColumnAction(Action action, boolean bl2) {
            this.a = action;
            this.b = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n2 = PaletteItemsComponent.this.getSelectedIndex();
            this.a.actionPerformed(actionEvent);
            int n3 = PaletteItemsComponent.this.getSelectedIndex();
            if (this.b && n2 < n3 || !this.b && n2 > n3) {
                return;
            }
            if (this.b) {
                if (n3 == n2 + 1) {
                    ++n3;
                }
                if (n3 < PaletteItemsComponent.this.getModel().getSize() - 1) {
                    PaletteItemsComponent.this.setSelectedIndex(n3 + 1);
                    PaletteItemsComponent.this.scrollRectToVisible(PaletteItemsComponent.this.getCellBounds(n3 + 1, n3 + 1));
                }
            } else if (n3 > 0) {
                PaletteItemsComponent.this.setSelectedIndex(n3 - 1);
                PaletteItemsComponent.this.scrollRectToVisible(PaletteItemsComponent.this.getCellBounds(n3 - 1, n3 - 1));
            }
        }
    }

    private class MoveFocusAction
    extends AbstractAction {
        private final Action b;
        private final boolean a;

        public MoveFocusAction(Action action, boolean bl2) {
            this.b = action;
            this.a = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            int n2 = PaletteItemsComponent.this.getSelectedIndex();
            this.b.actionPerformed(actionEvent);
            int n3 = PaletteItemsComponent.this.getSelectedIndex();
            if (n2 != n3) {
                return;
            }
            if (this.a && n3 == 0) {
                return;
            }
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Container container = keyboardFocusManager.getCurrentFocusCycleRoot();
            FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
            if (focusTraversalPolicy == null) {
                focusTraversalPolicy = keyboardFocusManager.getDefaultFocusTraversalPolicy();
            }
            Component component2 = component = this.a ? focusTraversalPolicy.getComponentAfter(container, (Component)((Object)PaletteItemsComponent.this)) : focusTraversalPolicy.getComponentBefore(container, (Component)((Object)PaletteItemsComponent.this));
            if (component instanceof PaletteGroupComponent) {
                PaletteItemsComponent.this.clearSelection();
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(component, true));
                ((PaletteGroupComponent)component).scrollRectToVisible(component.getBounds());
            }
        }
    }
}

