/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.configurations.ConfigurationUtil;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractApplicationConfigurationProducer<T extends ApplicationConfiguration>
extends JavaRunConfigurationProducerBase<T> {
    public AbstractApplicationConfigurationProducer(ApplicationConfigurationType applicationConfigurationType) {
        super(applicationConfigurationType);
    }

    protected boolean setupConfigurationFromContext(T t2, ConfigurationContext configurationContext, Ref<PsiElement> ref) {
        PsiClass psiClass;
        PsiMethod psiMethod;
        Location location = configurationContext.getLocation();
        if (location == null) {
            return false;
        }
        Location location2 = JavaExecutionUtil.stepIntoSingleClass((Location)location);
        if (location2 == null) {
            return false;
        }
        PsiElement psiElement = location2.getPsiElement();
        if (!psiElement.isPhysical()) {
            return false;
        }
        PsiElement psiElement2 = psiElement;
        while ((psiMethod = AbstractApplicationConfigurationProducer.a(psiElement2)) != null) {
            psiClass = psiMethod.getContainingClass();
            if (ConfigurationUtil.MAIN_CLASS.value((Object)psiClass)) {
                ref.set((Object)psiMethod);
                this.a(t2, psiClass, configurationContext);
                return true;
            }
            psiElement2 = psiMethod.getParent();
        }
        psiClass = ApplicationConfigurationType.getMainClass(psiElement);
        if (psiClass == null) {
            return false;
        }
        ref.set((Object)psiClass);
        this.a(t2, psiClass, configurationContext);
        return true;
    }

    private void a(T t2, PsiClass psiClass, ConfigurationContext configurationContext) {
        ((ApplicationConfiguration)t2).setMainClassName(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass));
        t2.setGeneratedName();
        this.setupConfigurationModule(configurationContext, t2);
    }

    @Nullable
    private static PsiMethod a(PsiElement psiElement) {
        PsiMethod psiMethod;
        while ((psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethod.class)) != null) {
            if (PsiMethodUtil.isMainMethod((PsiMethod)psiMethod)) {
                return psiMethod;
            }
            psiElement = psiMethod.getParent();
        }
        return null;
    }

    public boolean isConfigurationFromContext(T t2, ConfigurationContext configurationContext) {
        PsiElement psiElement = configurationContext.getPsiLocation();
        PsiClass psiClass = ApplicationConfigurationType.getMainClass(psiElement);
        if (psiClass != null && Comparing.equal((String)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass), (String)((ApplicationConfiguration)t2).getMainClassName())) {
            PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethod.class, (boolean)false);
            if (psiMethod != null && TestFrameworks.getInstance().isTestMethod(psiMethod)) {
                return false;
            }
            Module module2 = ((JavaRunConfigurationModule)t2.getConfigurationModule()).getModule();
            if (Comparing.equal((Object)configurationContext.getModule(), (Object)module2)) {
                return true;
            }
            ApplicationConfiguration applicationConfiguration = (ApplicationConfiguration)configurationContext.getRunManager().getConfigurationTemplate(this.getConfigurationFactory()).getConfiguration();
            Module module3 = ((JavaRunConfigurationModule)applicationConfiguration.getConfigurationModule()).getModule();
            if (Comparing.equal((Object)module3, (Object)module2)) {
                return true;
            }
        }
        return false;
    }
}

