/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jshell;

import com.intellij.execution.jshell.JShellDiagnostic;
import com.intellij.execution.jshell.JShellHandler;
import com.intellij.execution.jshell.SnippetEditorDecorator;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJShellFile;
import com.intellij.psi.PsiJShellHolderMethod;
import com.intellij.psi.PsiJShellSyntheticElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExecuteJShellAction
extends AnAction {
    private static final AnAction a = new ExecuteJShellAction();
    private boolean b = false;

    private ExecuteJShellAction() {
        super(AllIcons.Toolwindows.ToolWindowRun);
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        block25: {
            Project project2 = anActionEvent.getProject();
            try {
                if (project2 == null) {
                    return;
                }
            }
            catch (Exception exception) {
                throw ExecuteJShellAction.b(exception);
            }
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(anActionEvent.getDataContext());
            try {
                if (editor == null) {
                    return;
                }
            }
            catch (Exception exception) {
                throw ExecuteJShellAction.b(exception);
            }
            VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(anActionEvent.getDataContext());
            try {
                if (virtualFile == null) {
                    return;
                }
            }
            catch (Exception exception) {
                throw ExecuteJShellAction.b(exception);
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            try {
                TextRange textRange;
                Module module2;
                JShellHandler jShellHandler = JShellHandler.getAssociatedHandler(virtualFile);
                if (jShellHandler == null) {
                    Sdk sdk;
                    Module module3;
                    SnippetEditorDecorator.ConfigurationPane configurationPane = SnippetEditorDecorator.getJShellConfiguration(anActionEvent.getDataContext());
                    try {
                        module3 = configurationPane != null ? configurationPane.getContextModule() : null;
                    }
                    catch (Exception exception) {
                        throw ExecuteJShellAction.b(exception);
                    }
                    module2 = module3;
                    try {
                        sdk = configurationPane != null ? configurationPane.getRuntimeSdk() : null;
                    }
                    catch (Exception exception) {
                        throw ExecuteJShellAction.b(exception);
                    }
                    textRange = sdk;
                    jShellHandler = JShellHandler.create(project2, virtualFile, module2, (Sdk)textRange);
                }
                if (jShellHandler == null) break block25;
                jShellHandler.toFront();
                boolean bl2 = false;
                module2 = editor.getDocument();
                textRange = EditorUtil.getSelectionInAnyMode((Editor)editor);
                if (textRange.isEmpty()) {
                    PsiElement psiElement = this.a(project2, anActionEvent);
                    if (psiElement instanceof PsiJShellFile) {
                        for (PsiElement psiElement2 : ((PsiJShellFile)psiElement).getExecutableSnippets()) {
                            bl2 |= ExecuteJShellAction.a(jShellHandler, psiElement2.getText());
                        }
                    } else if (psiElement != null) {
                        bl2 = ExecuteJShellAction.a(jShellHandler, psiElement.getText());
                    }
                } else {
                    bl2 = ExecuteJShellAction.a(jShellHandler, module2.getText(textRange));
                }
                try {
                    if (!bl2) {
                        JShellDiagnostic.notifyInfo("Nothing to execute", project2);
                    }
                }
                catch (Exception exception) {
                    throw ExecuteJShellAction.b(exception);
                }
            }
            catch (Exception exception) {
                JShellDiagnostic.notifyError(exception, project2);
            }
        }
    }

    private static boolean a(@NotNull JShellHandler jShellHandler, String string) {
        try {
            if (jShellHandler == null) {
                ExecuteJShellAction.a(0);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ExecuteJShellAction.b(illegalArgumentException);
        }
        try {
            if (!StringUtil.isEmptyOrSpaces((String)string)) {
                jShellHandler.evaluate(string.trim());
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ExecuteJShellAction.b(illegalArgumentException);
        }
        return false;
    }

    @Nullable
    private PsiElement a(Project project2, AnActionEvent anActionEvent) {
        block15: {
            Editor editor = (Editor)anActionEvent.getData(CommonDataKeys.EDITOR);
            if (editor != null) {
                Object object;
                PsiElement psiElement;
                PsiFile psiFile;
                block17: {
                    PsiElement psiElement2;
                    block16: {
                        psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
                        try {
                            try {
                                if (!(psiFile instanceof PsiJShellFile)) break block15;
                                if (!this.b) break block16;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw ExecuteJShellAction.b(illegalArgumentException);
                            }
                            psiElement2 = ExecuteJShellAction.a(psiFile, editor.getDocument(), editor.getCaretModel().getOffset());
                            break block17;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw ExecuteJShellAction.b(illegalArgumentException);
                        }
                    }
                    psiElement2 = psiElement = null;
                }
                while (psiElement != null) {
                    PsiElement psiElement3;
                    block18: {
                        psiElement3 = psiElement.getParent();
                        try {
                            if (!(psiElement3 instanceof PsiJShellHolderMethod) || !(psiElement instanceof PsiEmptyStatement)) break block18;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw ExecuteJShellAction.b(illegalArgumentException);
                        }
                        psiElement = psiElement3.getPrevSibling();
                        if (!(psiElement instanceof PsiJShellSyntheticElement)) continue;
                        psiElement = psiElement.getFirstChild();
                        break;
                    }
                    try {
                        try {
                            if (psiElement3 instanceof PsiJShellSyntheticElement || psiElement3 instanceof PsiJShellFile) {
                                break;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw ExecuteJShellAction.b(illegalArgumentException);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ExecuteJShellAction.b(illegalArgumentException);
                    }
                    psiElement = psiElement3;
                }
                try {
                    object = psiElement != null ? psiElement : psiFile;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ExecuteJShellAction.b(illegalArgumentException);
                }
                return object;
            }
        }
        return null;
    }

    private static PsiElement a(PsiFile psiFile, Document document, int n2) {
        int n3 = DocumentUtil.getLineStartOffset((int)n2, (Document)document);
        PsiElement psiElement = null;
        for (int i2 = n2; i2 >= n3; --i2) {
            psiElement = psiFile.findElementAt(i2);
            try {
                try {
                    if (psiElement == null || psiElement instanceof PsiWhiteSpace) continue;
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ExecuteJShellAction.b(illegalArgumentException);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ExecuteJShellAction.b(illegalArgumentException);
            }
        }
        return psiElement;
    }

    public static AnAction getSharedInstance() {
        return a;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/execution/jshell/ExecuteJShellAction", "scheduleEval"));
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

