/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.stacktrace;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.stacktrace.MethodLineLocation;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NonNls;

public class StackTraceLine {
    private final Project b;
    private final String a;
    @NonNls
    protected static final String AT_STR = "at";
    protected static final String AT__STR = "at ";
    @NonNls
    protected static final String INIT_MESSAGE = "<init>";

    public StackTraceLine(Project project2, String string) {
        this.b = project2;
        this.a = string;
    }

    public String getClassName() {
        int n2 = this.a.indexOf(AT_STR);
        try {
            if (n2 < 0) {
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw StackTraceLine.b(numberFormatException);
        }
        n2 += AT__STR.length();
        int n3 = this.c();
        try {
            if (n3 < 0) {
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw StackTraceLine.b(numberFormatException);
        }
        try {
            if (n3 <= n2) {
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw StackTraceLine.b(numberFormatException);
        }
        return this.a.substring(n2, n3);
    }

    private int c() {
        return this.a.lastIndexOf(46, this.b());
    }

    private int b() {
        return this.a.indexOf(40);
    }

    private int a() {
        return this.a.indexOf(41);
    }

    public int getLineNumber() throws NumberFormatException {
        int n2;
        int n3;
        block7: {
            n3 = this.a();
            n2 = this.a.lastIndexOf(58) + 1;
            try {
                block6: {
                    try {
                        try {
                            if (n3 < 0 || n2 < 1) break block6;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw StackTraceLine.b(numberFormatException);
                        }
                        if (n2 < n3) break block7;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw StackTraceLine.b(numberFormatException);
                    }
                }
                throw new NumberFormatException(this.a);
            }
            catch (NumberFormatException numberFormatException) {
                throw StackTraceLine.b(numberFormatException);
            }
        }
        return Integer.parseInt(this.a.substring(n2, n3)) - 1;
    }

    public OpenFileDescriptor getOpenFileDescriptor(VirtualFile virtualFile) {
        int n2;
        try {
            n2 = this.getLineNumber();
        }
        catch (NumberFormatException numberFormatException) {
            return new OpenFileDescriptor(this.b, virtualFile);
        }
        return new OpenFileDescriptor(this.b, virtualFile, n2, 0);
    }

    public OpenFileDescriptor getOpenFileDescriptor(Project project2) {
        Location<PsiMethod> location = this.getMethodLocation(project2);
        try {
            if (location == null) {
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw StackTraceLine.b(numberFormatException);
        }
        return this.getOpenFileDescriptor(((PsiMethod)location.getPsiElement()).getContainingFile().getVirtualFile());
    }

    public String getMethodName() {
        int n2 = this.c();
        try {
            if (n2 == -1) {
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw StackTraceLine.b(numberFormatException);
        }
        return this.a.substring(this.c() + 1, this.b());
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Location<PsiMethod> getMethodLocation(Project project2) {
        PsiElement psiElement;
        int n2;
        String string;
        block16: {
            PsiElement psiElement2;
            String string2;
            block15: {
                string2 = this.getClassName();
                string = this.getMethodName();
                if (string2 == null) return null;
                try {
                    if (string != null) break block15;
                    return null;
                    catch (NumberFormatException numberFormatException) {
                        throw StackTraceLine.b(numberFormatException);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw StackTraceLine.b(numberFormatException);
                }
            }
            try {
                n2 = this.getLineNumber();
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            int n3 = string2.indexOf(36);
            if (n3 != -1) {
                string2 = string2.substring(0, n3);
            }
            PsiClass psiClass = StackTraceLine.a(project2, string2, n2);
            try {
                psiElement2 = psiClass == null ? null : psiClass.getNavigationElement();
            }
            catch (NumberFormatException numberFormatException) {
                throw StackTraceLine.b(numberFormatException);
            }
            psiElement = psiElement2;
            try {
                try {
                    if (psiClass != null && !(psiElement instanceof PsiCompiledElement)) break block16;
                    return null;
                }
                catch (NumberFormatException numberFormatException) {
                    throw StackTraceLine.b(numberFormatException);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw StackTraceLine.b(numberFormatException);
            }
        }
        if (!(psiElement instanceof PsiClass)) return null;
        PsiMethod psiMethod = StackTraceLine.a((PsiClass)psiElement, string, n2);
        try {
            if (psiMethod == null) return null;
            return new MethodLineLocation(project2, psiMethod, (Location<PsiClass>)PsiLocation.fromPsiElement((PsiElement)((PsiClass)psiElement)), n2);
        }
        catch (NumberFormatException numberFormatException) {
            throw StackTraceLine.b(numberFormatException);
        }
    }

    private static PsiClass a(Project project2, String string, int n2) {
        PsiElement psiElement;
        block9: {
            PsiElement psiElement2;
            try {
                if (project2 == null) {
                    return null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw StackTraceLine.b(numberFormatException);
            }
            PsiManager psiManager = PsiManager.getInstance((Project)project2);
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(string, GlobalSearchScope.allScope((Project)project2));
            try {
                psiElement2 = psiClass == null ? null : psiClass.getNavigationElement();
            }
            catch (NumberFormatException numberFormatException) {
                throw StackTraceLine.b(numberFormatException);
            }
            psiElement = psiElement2;
            try {
                try {
                    if (psiClass != null && !(psiElement instanceof PsiCompiledElement)) break block9;
                }
                catch (NumberFormatException numberFormatException) {
                    throw StackTraceLine.b(numberFormatException);
                }
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                throw StackTraceLine.b(numberFormatException);
            }
        }
        PsiFile psiFile = psiElement.getContainingFile();
        return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(StackTraceLine.a(psiFile, n2)), PsiClass.class, (boolean)false);
    }

    private static PsiMethod a(PsiClass psiClass, String string, int n2) {
        PsiMethod[] psiMethodArray = INIT_MESSAGE.equals(string) ? psiClass.getConstructors() : psiClass.findMethodsByName(string, true);
        try {
            if (psiMethodArray.length == 0) {
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw StackTraceLine.b(numberFormatException);
        }
        PsiFile psiFile = psiMethodArray[0].getContainingFile();
        int n3 = StackTraceLine.a(psiFile, n2);
        for (PsiMethod psiMethod : psiMethodArray) {
            try {
                if (!psiMethod.getTextRange().contains(n3)) continue;
                return psiMethod;
            }
            catch (NumberFormatException numberFormatException) {
                throw StackTraceLine.b(numberFormatException);
            }
        }
        return null;
    }

    private static int a(PsiFile psiFile, int n2) {
        LineTokenizer lineTokenizer = new LineTokenizer(psiFile.getViewProvider().getContents());
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                lineTokenizer.advance();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw StackTraceLine.b(numberFormatException);
        }
        return lineTokenizer.getOffset();
    }

    private static NumberFormatException b(NumberFormatException numberFormatException) {
        return numberFormatException;
    }
}

