/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.testDiscovery.TestDiscoveryIndex;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Paths;

public class ConfigureTestDiscoveryAction
extends AnAction {
    public void update(AnActionEvent anActionEvent) {
        anActionEvent.getPresentation().setEnabledAndVisible(Registry.is((String)"testDiscovery.enabled") && anActionEvent.getProject() != null);
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fileChooserDescriptor.setTitle("Choose External Discovery Index Directory");
        fileChooserDescriptor.setDescription("Local directory with indices retrieved from CI \nto be replaced within TeamCity IDEA plugin");
        VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)fileChooserDescriptor, (Project)anActionEvent.getProject(), null);
        if (virtualFile != null) {
            TestDiscoveryIndex.getInstance(anActionEvent.getProject()).setRemoteTestRunDataPath(Paths.get(virtualFile.getPath(), new String[0]));
        }
    }
}

