/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.execution.testDiscovery.TestDiscoveryIndex;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class TestDiscoveryConfigurationProducer
extends JavaRunConfigurationProducerBase<JavaTestConfigurationBase> {
    protected TestDiscoveryConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    protected abstract void setPosition(JavaTestConfigurationBase var1, PsiLocation<PsiMethod> var2);

    protected abstract Pair<String, String> getPosition(JavaTestConfigurationBase var1);

    /*
     * Loose catch block
     */
    protected boolean setupConfigurationFromContext(JavaTestConfigurationBase javaTestConfigurationBase, ConfigurationContext configurationContext, Ref<PsiElement> ref) {
        block27: {
            Location location;
            block26: {
                try {
                    if (!Registry.is((String)"testDiscovery.enabled")) {
                        return false;
                    }
                }
                catch (IOException iOException) {
                    throw TestDiscoveryConfigurationProducer.b(iOException);
                }
                location = configurationContext.getLocation();
                if ($assertionsDisabled) break block26;
                try {
                    block29: {
                        if (location != null) break block26;
                        break block29;
                        catch (IOException iOException) {
                            throw TestDiscoveryConfigurationProducer.b(iOException);
                        }
                    }
                    throw new AssertionError();
                }
                catch (IOException iOException) {
                    throw TestDiscoveryConfigurationProducer.b(iOException);
                }
            }
            Location location2 = JavaExecutionUtil.stepIntoSingleClass((Location)location);
            try {
                if (location2 == null) {
                    return false;
                }
            }
            catch (IOException iOException) {
                throw TestDiscoveryConfigurationProducer.b(iOException);
            }
            PsiMethod psiMethod = TestDiscoveryConfigurationProducer.a(location2);
            Pair<String, String> pair2 = TestDiscoveryConfigurationProducer.a(psiMethod);
            try {
                if (psiMethod == null || pair2 == null) break block27;
            }
            catch (IOException iOException) {
                throw TestDiscoveryConfigurationProducer.b(iOException);
            }
            try {
                TestDiscoveryIndex testDiscoveryIndex;
                Project project2;
                block28: {
                    project2 = javaTestConfigurationBase.getProject();
                    testDiscoveryIndex = TestDiscoveryIndex.getInstance(project2);
                    Collection<String> collection = testDiscoveryIndex.getTestsByMethodName((String)pair2.first, (String)pair2.second);
                    try {
                        if (collection != null && !ContainerUtil.filter(collection, string -> string.startsWith(javaTestConfigurationBase.getFrameworkPrefix())).isEmpty()) break block28;
                    }
                    catch (IOException iOException) {
                        throw TestDiscoveryConfigurationProducer.b(iOException);
                    }
                    return false;
                }
                this.setPosition(javaTestConfigurationBase, (PsiLocation<PsiMethod>)new PsiLocation((PsiElement)psiMethod));
                javaTestConfigurationBase.setName("Tests for " + StringUtil.getShortName((String)((String)pair2.first)) + "." + (String)pair2.second);
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = configurationContext.getRunManager().getConfigurationTemplate(this.getConfigurationFactory());
                Module module2 = ((ModuleBasedConfiguration)runnerAndConfigurationSettings.getConfiguration()).getConfigurationModule().getModule();
                try {
                    if (module2 != null) {
                        javaTestConfigurationBase.setModule(module2);
                    }
                }
                catch (IOException iOException) {
                    throw TestDiscoveryConfigurationProducer.b(iOException);
                }
                Collection<String> collection = testDiscoveryIndex.getTestModulesByMethodName((String)pair2.first, (String)pair2.second, javaTestConfigurationBase.getFrameworkPrefix());
                if (collection.isEmpty()) {
                    return true;
                }
                ArrayList<Module> arrayList = new ArrayList<Module>();
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
                for (String string22 : collection) {
                    Module module3 = moduleManager.findModuleByName(string22);
                    try {
                        if (module3 == null) continue;
                        arrayList.add(module3);
                    }
                    catch (IOException iOException) {
                        throw TestDiscoveryConfigurationProducer.b(iOException);
                    }
                }
                if (arrayList.isEmpty()) {
                    return true;
                }
                HashSet hashSet = new HashSet(Arrays.asList(moduleManager.getModules()));
                arrayList.forEach(arg_0 -> TestDiscoveryConfigurationProducer.a((Set)hashSet, arg_0));
                if (!hashSet.isEmpty()) {
                    String string22;
                    string22 = (Module)hashSet.iterator().next();
                    for (Module module4 : arrayList) {
                        if (!hashSet.contains(module4)) continue;
                        string22 = module4;
                    }
                    javaTestConfigurationBase.setModule((Module)string22);
                }
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    @Override
    protected Module findModule(JavaTestConfigurationBase javaTestConfigurationBase, Module module2) {
        return null;
    }

    private static PsiMethod a(Location location) {
        PsiClass psiClass;
        PsiElement psiElement = location.getPsiElement();
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethod.class);
        if (psiMethod != null && (psiClass = psiMethod.getContainingClass()) != null) {
            TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)psiClass);
            if (testFramework != null) {
                return null;
            }
            return psiMethod;
        }
        return null;
    }

    private static Pair<String, String> a(PsiMethod psiMethod) {
        if (psiMethod == null) {
            return null;
        }
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        String string = psiClass.getQualifiedName();
        if (string != null) {
            return Pair.create((Object)string, (Object)psiMethod.getName());
        }
        return null;
    }

    public boolean isConfigurationFromContext(JavaTestConfigurationBase javaTestConfigurationBase, ConfigurationContext configurationContext) {
        Pair<String, String> pair2 = TestDiscoveryConfigurationProducer.a(TestDiscoveryConfigurationProducer.a(configurationContext.getLocation()));
        return pair2 != null && pair2.equals(this.getPosition(javaTestConfigurationBase));
    }

    private static /* synthetic */ void a(Set set, Module module2) {
        List list = ModuleUtilCore.getAllDependentModules((Module)module2);
        list.add(module2);
        set.retainAll(list);
    }

    private static IOException b(IOException iOException) {
        return iOException;
    }
}

