/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ui.JreProvider;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.PathUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.Nullable;

public class AlternativeJREPanel
extends JPanel
implements PanelWithAnchor {
    private final ComponentWithBrowseButton<TextFieldWithHistory> c;
    private final JBCheckBox b = new JBCheckBox(ExecutionBundle.message((String)"run.configuration.use.alternate.jre.checkbox", (Object[])new Object[0]));
    final TextFieldWithHistory myFieldWithHistory = new TextFieldWithHistory();
    private JComponent a;

    public AlternativeJREPanel() {
        String string;
        Sdk[] sdkArray;
        this.myFieldWithHistory.setHistorySize(-1);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Sdk sdk : sdkArray = ProjectJdkTable.getInstance().getAllJdks()) {
            arrayList.add(sdk.getName());
        }
        for (JreProvider jreProvider : (JreProvider[])JreProvider.EP_NAME.getExtensions()) {
            string = jreProvider.getJrePath();
            if (StringUtil.isEmpty((String)string)) continue;
            arrayList.add(string);
        }
        for (Sdk sdk : sdkArray) {
            File file;
            string = sdk.getHomePath();
            if (!SystemInfo.isMac && (file = new File(sdk.getHomePath(), "jre")).isDirectory()) {
                string = file.getPath();
            }
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        this.myFieldWithHistory.setHistory(arrayList);
        this.c = new ComponentWithBrowseButton((JComponent)this.myFieldWithHistory, null);
        this.c.addBrowseFolderListener(ExecutionBundle.message((String)"run.configuration.select.alternate.jre.label", (Object[])new Object[0]), ExecutionBundle.message((String)"run.configuration.select.jre.dir.label", (Object[])new Object[0]), null, BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR, TextComponentAccessor.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
        this.setLayout((LayoutManager)new MigLayout("ins 0, gap 10, fill, flowx"));
        this.add((Component)this.b, "shrinkx");
        this.add((Component)this.c, "growx, pushx");
        InsertPathAction.addTo((JTextComponent)this.myFieldWithHistory.getTextEditor());
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AlternativeJREPanel.this.a();
            }
        });
        this.a();
        this.setAnchor((JComponent)this.b);
        this.updateUI();
    }

    private void a() {
        boolean bl2 = this.isPathEnabled();
        GuiUtils.enableChildren(this.c, (boolean)bl2, (JComponent[])new JComponent[0]);
        this.myFieldWithHistory.invalidate();
    }

    public String getPath() {
        return FileUtil.toSystemIndependentName((String)((TextFieldWithHistory)this.c.getChildComponent()).getText().trim());
    }

    private void a(@Nullable String string) {
        ((TextFieldWithHistory)this.c.getChildComponent()).setText(StringUtil.notNullize((String)PathUtil.toSystemDependentName((String)string)));
    }

    public boolean isPathEnabled() {
        return this.b.isSelected();
    }

    private void a(boolean bl2) {
        this.b.setSelected(bl2);
        this.a();
    }

    public void init(@Nullable String string, boolean bl2) {
        this.a(bl2);
        this.a(string);
    }

    public JComponent getAnchor() {
        return this.a;
    }

    public void setAnchor(JComponent jComponent) {
        this.a = jComponent;
        this.b.setAnchor(jComponent);
    }
}

