/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public class FormatterTestUtils {
    public static final Map<Action, TestFormatAction> ACTIONS = new EnumMap<Action, TestFormatAction>(Action.class);

    public static void testFormatting(@NotNull Project project2, @NotNull String string, @NotNull String string2, @NotNull String string3, @NotNull Action action) {
        try {
            if (project2 == null) {
                FormatterTestUtils.a(0);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw FormatterTestUtils.b(illegalStateException);
        }
        try {
            if (string == null) {
                FormatterTestUtils.a(1);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw FormatterTestUtils.b(illegalStateException);
        }
        try {
            if (string2 == null) {
                FormatterTestUtils.a(2);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw FormatterTestUtils.b(illegalStateException);
        }
        try {
            if (string3 == null) {
                FormatterTestUtils.a(3);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw FormatterTestUtils.b(illegalStateException);
        }
        try {
            if (action == null) {
                FormatterTestUtils.a(4);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw FormatterTestUtils.b(illegalStateException);
        }
        String string4 = "FTU." + string;
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(string4);
        FormatData formatData = FormatterTestUtils.a(string2);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project2).createFileFromText(string4, fileType, (CharSequence)formatData.text, System.currentTimeMillis(), true);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        Document document = psiDocumentManager.getDocument(psiFile);
        try {
            if (document == null) {
                throw new IllegalStateException("Document is null");
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw FormatterTestUtils.b(illegalStateException);
        }
        TestFormatAction testFormatAction = ACTIONS.get((Object)action);
        try {
            if (testFormatAction == null) {
                throw new IllegalStateException("Format action is null");
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw FormatterTestUtils.b(illegalStateException);
        }
        WriteCommandAction.runWriteCommandAction((Project)project2, () -> testFormatAction.run(psiFile, formatData.startOffset, formatData.endOffset));
        Assert.assertEquals((Object)string3, (Object)document.getText());
    }

    private static FormatData a(@NotNull String string) {
        try {
            if (string == null) {
                FormatterTestUtils.a(5);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw FormatterTestUtils.b(illegalStateException);
        }
        String string2 = "<selection>";
        String string3 = "<selection/>";
        int n2 = string.indexOf("<selection>");
        if (n2 > 0) {
            int n3 = string.indexOf("<selection/>") - "<selection>".length();
            String string4 = string.replace("<selection>", "").replace("<selection/>", "");
            return new FormatData(string4, n2, n3);
        }
        return new FormatData(string, 0, string.length());
    }

    static {
        ACTIONS.put(Action.REFORMAT, new TestFormatAction(){

            @Override
            public void run(PsiFile psiFile, int n2, int n3) {
                Project project2 = psiFile.getProject();
                CodeStyleManager.getInstance((Project)project2).reformatText(psiFile, n2, n3);
            }
        });
        ACTIONS.put(Action.INDENT, new TestFormatAction(){

            @Override
            public void run(PsiFile psiFile, int n2, int n3) {
                Project project2 = psiFile.getProject();
                CodeStyleManager.getInstance((Project)project2).adjustLineIndent(psiFile, n2);
            }
        });
        ACTIONS.put(Action.REFORMAT_WITH_CONTEXT, new TestFormatAction(){

            @Override
            public void run(PsiFile psiFile, int n2, int n3) {
                ArrayList arrayList = ContainerUtil.newArrayList((Object[])new TextRange[]{new TextRange(n2, n3)});
                Project project2 = psiFile.getProject();
                CodeStyleManager.getInstance((Project)project2).reformatTextWithContext(psiFile, (Collection)arrayList);
            }
        });
        ACTIONS.put(Action.REFORMAT_WITH_INSERTED_LINE_CONTEXT, new TestFormatAction(){

            @Override
            public void run(PsiFile psiFile, int n2, int n3) {
                ArrayList arrayList = ContainerUtil.newArrayList((Object[])new TextRange[]{new TextRange(n2, n3)});
                Project project2 = psiFile.getProject();
                CodeStyleManager.getInstance((Project)project2).reformatTextWithContext(psiFile, new ChangedRangesInfo((List)arrayList, (List)arrayList));
            }
        });
    }

    /*
     * Exception decompiling
     */
    private static /* synthetic */ void a(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IllegalStateException b(IllegalStateException illegalStateException) {
        return illegalStateException;
    }

    public static class FormatData {
        public int startOffset;
        public int endOffset;
        public String text;

        public FormatData(String string, int n2, int n3) {
            this.text = string;
            this.startOffset = n2;
            this.endOffset = n3;
        }
    }

    public static enum Action {
        REFORMAT,
        INDENT,
        REFORMAT_WITH_CONTEXT,
        REFORMAT_WITH_INSERTED_LINE_CONTEXT;

    }

    public static interface TestFormatAction {
        public void run(PsiFile var1, int var2, int var3);
    }
}

