/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModuleDescriptor {
    private String h;
    private final MultiMap<File, DetectedSourceRoot> b = new MultiMap();
    private final Set<File> f = new HashSet<File>();
    private final Set<ModuleDescriptor> d = new HashSet<ModuleDescriptor>();
    private static final Set<String> g = new THashSet(Arrays.asList("java", "src", "source", "sources", "C:", "D:", "E:", "F:", "temp", "tmp"), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    private boolean c;
    private List<ModuleBuilder.ModuleConfigurationUpdater> e = new SmartList();
    private ModuleType a;

    public ModuleDescriptor(File file, ModuleType moduleType, Collection<? extends DetectedSourceRoot> collection) {
        this.h = ModuleDescriptor.a(file);
        this.b.putValues((Object)file, collection);
        this.a = moduleType;
    }

    public ModuleDescriptor(File file, ModuleType moduleType, DetectedSourceRoot detectedSourceRoot) {
        this(file, moduleType, Collections.singletonList(detectedSourceRoot));
    }

    public void reuseExisting(boolean bl2) {
        this.c = bl2;
    }

    public void addConfigurationUpdater(ModuleBuilder.ModuleConfigurationUpdater moduleConfigurationUpdater) {
        this.e.add(moduleConfigurationUpdater);
    }

    public void updateModuleConfiguration(Module module2, ModifiableRootModel modifiableRootModel) {
        for (ModuleBuilder.ModuleConfigurationUpdater moduleConfigurationUpdater : this.e) {
            moduleConfigurationUpdater.update(module2, modifiableRootModel);
        }
    }

    public boolean isReuseExistingElement() {
        return this.c;
    }

    public ModuleType getModuleType() {
        return this.a;
    }

    private static String a(File file) {
        for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
            String string = file2.getName();
            try {
                if (g.contains(string)) continue;
                return string;
            }
            catch (InvalidDataException invalidDataException) {
                throw ModuleDescriptor.b(invalidDataException);
            }
        }
        return file.getName();
    }

    public String getName() {
        return this.h;
    }

    public void setName(String string) {
        this.h = string;
    }

    public Set<File> getContentRoots() {
        return Collections.unmodifiableSet(this.b.keySet());
    }

    public Collection<? extends DetectedProjectRoot> getSourceRoots() {
        return this.b.values();
    }

    public Collection<DetectedSourceRoot> getSourceRoots(File file) {
        return this.b.get((Object)file);
    }

    public void addContentRoot(File file) {
        this.b.put((Object)file, new HashSet());
    }

    public Collection<DetectedSourceRoot> removeContentRoot(File file) {
        return this.b.remove((Object)file);
    }

    public void addSourceRoot(File file, DetectedSourceRoot detectedSourceRoot) {
        this.b.putValue((Object)file, (Object)detectedSourceRoot);
    }

    public void addDependencyOn(ModuleDescriptor moduleDescriptor) {
        this.d.add(moduleDescriptor);
    }

    public void removeDependencyOn(ModuleDescriptor moduleDescriptor) {
        this.d.remove(moduleDescriptor);
    }

    public void addLibraryFile(File file) {
        this.f.add(file);
    }

    public Set<File> getLibraryFiles() {
        return this.f;
    }

    public Set<ModuleDescriptor> getDependencies() {
        return Collections.unmodifiableSet(this.d);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Module: ").append(this.getContentRoots()).append(" | ");
        for (DetectedProjectRoot detectedProjectRoot : this.getSourceRoots()) {
            stringBuilder.append(detectedProjectRoot.getDirectory().getName()).append(",");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public void clearModuleDependencies() {
        this.d.clear();
    }

    public void clearLibraryFiles() {
        this.f.clear();
    }

    @NotNull
    public String computeModuleFilePath() throws InvalidDataException {
        String string;
        block4: {
            String string2;
            block5: {
                string = this.getName();
                Set<File> set = this.getContentRoots();
                try {
                    try {
                        if (set.size() <= 0) break block4;
                        string2 = set.iterator().next().getPath() + File.separator + string + ".iml";
                        if (string2 != null) break block5;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw ModuleDescriptor.b(invalidDataException);
                    }
                    ModuleDescriptor.a(0);
                }
                catch (InvalidDataException invalidDataException) {
                    throw ModuleDescriptor.b(invalidDataException);
                }
            }
            return string2;
        }
        throw new InvalidDataException("Module " + string + " has no content roots and will not be created.");
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/importProject/ModuleDescriptor", "computeModuleFilePath"));
    }

    private static InvalidDataException b(InvalidDataException invalidDataException) {
        return invalidDataException;
    }
}

