/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.importProject.ModulesLayoutPanel;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

public class ModulesDetectionStep
extends AbstractStepWithProgress<List<ModuleDescriptor>> {
    private final ProjectStructureDetector m;
    private final ProjectFromSourcesBuilder n;
    private final ProjectDescriptor i;
    private final ModuleInsight o;
    private final Icon l;
    private final String j;
    private ModulesLayoutPanel k;
    int myPreviousStateHashCode = -1;

    public ModulesDetectionStep(ProjectStructureDetector projectStructureDetector, ProjectFromSourcesBuilder projectFromSourcesBuilder, ProjectDescriptor projectDescriptor, ModuleInsight moduleInsight, Icon icon, @NonNls String string) {
        super("Stop module analysis?");
        this.m = projectStructureDetector;
        this.n = projectFromSourcesBuilder;
        this.i = projectDescriptor;
        this.o = moduleInsight;
        this.l = icon;
        this.j = string;
    }

    public void updateDataModel() {
        this.i.setModules(this.k.getChosenEntries());
    }

    @Override
    protected JComponent createResultsPanel() {
        this.k = new ModulesLayoutPanel(this.o, new ModulesLayoutPanel.LibraryFilter(){

            @Override
            public boolean isLibraryChosen(LibraryDescriptor libraryDescriptor) {
                return ModulesDetectionStep.this.i.isLibraryChosen(libraryDescriptor);
            }
        });
        return this.k;
    }

    @Override
    protected String getProgressText() {
        return "Searching for modules. Please wait.";
    }

    @Override
    protected boolean shouldRunProgress() {
        int n2 = this.a();
        try {
            boolean bl2;
            try {
                bl2 = n2 != this.myPreviousStateHashCode;
            }
            catch (InvalidDataException invalidDataException) {
                throw ModulesDetectionStep.b(invalidDataException);
            }
            boolean bl3 = bl2;
            return bl3;
        }
        finally {
            this.myPreviousStateHashCode = n2;
        }
    }

    private int a() {
        int n2;
        String string = this.n.getBaseProjectPath();
        try {
            n2 = string != null ? string.hashCode() : 1;
        }
        catch (InvalidDataException invalidDataException) {
            throw ModulesDetectionStep.b(invalidDataException);
        }
        int n3 = n2;
        for (DetectedProjectRoot object2 : this.n.getProjectRoots(this.m)) {
            n3 = 31 * n3 + object2.getDirectory().hashCode();
        }
        List<LibraryDescriptor> list = this.i.getLibraries();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LibraryDescriptor libraryDescriptor = (LibraryDescriptor)iterator.next();
            Collection<File> collection = libraryDescriptor.getJars();
            for (File file : collection) {
                n3 = 31 * n3 + file.hashCode();
            }
        }
        return n3;
    }

    @Override
    protected List<ModuleDescriptor> calculate() {
        List<ModuleDescriptor> list;
        this.o.scanModules();
        List<ModuleDescriptor> list2 = this.o.getSuggestedModules();
        try {
            list = list2 != null ? list2 : Collections.emptyList();
        }
        catch (InvalidDataException invalidDataException) {
            throw ModulesDetectionStep.b(invalidDataException);
        }
        return list;
    }

    @Override
    public boolean validate() throws ConfigurationException {
        boolean bl2 = super.validate();
        try {
            if (!bl2) {
                return false;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw ModulesDetectionStep.b(invalidDataException);
        }
        List list = this.k.getChosenEntries();
        LinkedHashMap<String, ModuleDescriptor> linkedHashMap = new LinkedHashMap<String, ModuleDescriptor>();
        for (Object object : list) {
            try {
                Object object2 = ((ModuleDescriptor)object).computeModuleFilePath();
                try {
                    if (!new File((String)object2).exists()) continue;
                    linkedHashMap.put(IdeBundle.message((String)"warning.message.the.module.file.0.already.exist.and.will.be.overwritten", (Object[])new Object[]{object2}), (ModuleDescriptor)object);
                }
                catch (InvalidDataException invalidDataException) {
                    throw ModulesDetectionStep.b(invalidDataException);
                }
            }
            catch (InvalidDataException invalidDataException) {
                linkedHashMap.put(invalidDataException.getMessage(), (ModuleDescriptor)object);
            }
        }
        if (!linkedHashMap.isEmpty()) {
            int n2 = Messages.showYesNoCancelDialog((Component)this.getComponent(), (String)IdeBundle.message((String)"warning.text.0.do.you.want.to.overwrite.these.files", (Object[])new Object[]{StringUtil.join(linkedHashMap.keySet(), (String)"\n"), linkedHashMap.size()}), (String)IdeBundle.message((String)"title.file.already.exists", (Object[])new Object[0]), (String)"Overwrite", (String)"Reuse", (String)"Cancel", (Icon)Messages.getQuestionIcon());
            try {
                if (n2 == 2) {
                    return false;
                }
            }
            catch (InvalidDataException invalidDataException) {
                throw ModulesDetectionStep.b(invalidDataException);
            }
            if (n2 != 0) {
                for (Object object2 : linkedHashMap.values()) {
                    ((ModuleDescriptor)object2).reuseExisting(true);
                }
            }
        }
        return true;
    }

    @Override
    protected void onFinished(List<ModuleDescriptor> list, boolean bl2) {
        this.k.rebuild();
    }

    @NonNls
    public String getHelpId() {
        return this.j;
    }

    public Icon getIcon() {
        return this.l;
    }

    private static InvalidDataException b(InvalidDataException invalidDataException) {
        return invalidDataException;
    }
}

