/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.importProject.DetectedRootData;
import com.intellij.ide.util.importProject.DetectedRootsChooser;
import com.intellij.ide.util.importProject.RootDetectionProcessor;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.ide.util.projectWizard.importSources.impl.ProjectFromSourcesBuilderImpl;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class RootsDetectionStep
extends AbstractStepWithProgress<List<DetectedRootData>> {
    private static final String k = "roots_found";
    private static final String m = "roots_not_found";
    private final ProjectFromSourcesBuilderImpl r;
    private final WizardContext p;
    private final StepSequence n;
    private final Icon q;
    private final String l;
    private DetectedRootsChooser j;
    private String i = null;
    private JPanel o;

    public RootsDetectionStep(ProjectFromSourcesBuilderImpl projectFromSourcesBuilderImpl, WizardContext wizardContext, StepSequence stepSequence, Icon icon, @NonNls String string) {
        super(IdeBundle.message((String)"prompt.stop.searching.for.sources", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}));
        this.r = projectFromSourcesBuilderImpl;
        this.p = wizardContext;
        this.n = stepSequence;
        this.q = icon;
        this.l = string;
    }

    @Override
    protected JComponent createResultsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.j = new DetectedRootsChooser();
        this.j.addSelectionListener(new DetectedRootsChooser.RootSelectionListener(){

            @Override
            public void selectionChanged() {
                RootsDetectionStep.this.a();
            }
        });
        String string = IdeBundle.message((String)"label.project.roots.have.been.found", (Object[])new Object[0]);
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        jPanel.add((Component)this.j.getComponent(), new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.insets((int)8, (int)10), 0, 0));
        JButton jButton = new JButton(IdeBundle.message((String)"button.mark.all", (Object[])new Object[0]));
        jPanel.add((Component)jButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)0, (int)10, (int)8, (int)2), 0, 0));
        JButton jButton2 = new JButton(IdeBundle.message((String)"button.unmark.all", (Object[])new Object[0]));
        jPanel.add((Component)jButton2, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)0, (int)0, (int)8, (int)10), 0, 0));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RootsDetectionStep.this.j.setAllElementsMarked(true);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RootsDetectionStep.this.j.setAllElementsMarked(false);
            }
        });
        this.o = new JPanel(new CardLayout());
        this.o.add(k, jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(JBUI.Borders.empty((int)5));
        jPanel2.add("North", (Component)new MultiLineLabel(IdeBundle.message((String)"label.project.roots.not.found", (Object[])new Object[0])));
        this.o.add(m, jPanel2);
        return this.o;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.j.getComponent();
    }

    public void updateDataModel() {
        List<DetectedRootData> list = this.j.getMarkedElements();
        this.r.setupProjectStructure(RootDetectionProcessor.createRootsMap(list));
        this.a();
    }

    private void a() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.add("Existing Sources");
        for (DetectedRootData detectedRootData : this.j.getMarkedElements()) {
            for (ProjectStructureDetector projectStructureDetector : detectedRootData.getSelectedDetectors()) {
                linkedHashSet.add(projectStructureDetector.getDetectorId());
            }
        }
        this.n.setTypes(linkedHashSet);
        this.p.requestWizardButtonsUpdate();
    }

    @Override
    protected boolean shouldRunProgress() {
        String string = this.b();
        return this.i == null ? string != null : !this.i.equals(string);
    }

    @Override
    protected void onFinished(List<DetectedRootData> list, boolean bl2) {
        CardLayout cardLayout = (CardLayout)this.o.getLayout();
        if (list.size() > 0 && !bl2) {
            this.i = this.b();
            this.j.setElements(list);
            this.a();
            cardLayout.show(this.o, k);
        } else {
            this.i = null;
            cardLayout.show(this.o, m);
        }
        this.o.revalidate();
    }

    @Override
    protected List<DetectedRootData> calculate() {
        String string = this.b();
        if (string == null) {
            return Collections.emptyList();
        }
        return RootDetectionProcessor.detectRoots(new File(string));
    }

    @Nullable
    private String b() {
        return this.r.getBaseProjectPath();
    }

    @Override
    protected String getProgressText() {
        String string = this.b();
        return IdeBundle.message((String)"progress.searching.for.sources", (Object[])new Object[]{string != null ? string.replace('/', File.separatorChar) : ""});
    }

    public Icon getIcon() {
        return this.q;
    }

    public String getHelpId() {
        return this.l;
    }
}

