/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.newProjectWizard.modes.WizardMode;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.NamePathComponent;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.util.projectWizard.importSources.impl.ProjectFromSourcesBuilderImpl;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.projectImport.ProjectFormatPanel;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class ProjectNameStep
extends ModuleWizardStep {
    private final JPanel a;
    protected final JPanel myAdditionalContentPanel;
    protected NamePathComponent myNamePathComponent;
    protected final WizardContext myWizardContext;
    @Nullable
    protected final WizardMode myMode;
    private final ProjectFormatPanel b = new ProjectFormatPanel();

    public ProjectNameStep(WizardContext wizardContext, @Nullable WizardMode wizardMode) {
        this.myWizardContext = wizardContext;
        this.myMode = wizardMode;
        this.myNamePathComponent = new NamePathComponent(IdeBundle.message((String)"label.project.name", (Object[])new Object[0]), IdeBundle.message((String)"label.project.files.location", (Object[])new Object[0]), IdeBundle.message((String)"title.select.project.file.directory", (Object[])new Object[]{IdeBundle.message((String)"project.new.wizard.project.identification", (Object[])new Object[0])}), IdeBundle.message((String)"description.select.project.file.directory", (Object[])new Object[]{StringUtil.capitalize((String)IdeBundle.message((String)"project.new.wizard.project.identification", (Object[])new Object[0]))}), true, false);
        String string = this.myWizardContext.getProjectFileDirectory();
        String string2 = this.myWizardContext.getProjectName();
        String string3 = string2 != null ? string2 : ProjectWizardUtil.findNonExistingFileName(string, "untitled", "");
        this.myNamePathComponent.setPath(string2 == null ? string + File.separator + string3 : string);
        this.myNamePathComponent.setNameValue(string3);
        this.myNamePathComponent.getNameComponent().select(0, string3.length());
        this.a = new JPanel(new GridBagLayout());
        this.a.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.a.add((Component)this.myNamePathComponent, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)10, (int)0, (int)20, (int)0), 0, 0));
        if (this.myWizardContext.isCreatingNewProject()) {
            this.myNamePathComponent.add((Component)new JLabel("Project format:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.emptyInsets(), 0, 0));
            this.myNamePathComponent.add((Component)this.b.getStorageFormatComboBox(), new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        }
        this.myNamePathComponent.setVisible(this.isStepVisible());
        this.myAdditionalContentPanel = new JPanel(new GridBagLayout());
        this.a.add((Component)this.myAdditionalContentPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.emptyInsets(), 0, 0));
    }

    public JComponent getComponent() {
        return this.a;
    }

    public boolean isStepVisible() {
        return this.myWizardContext.getProject() == null;
    }

    public void updateDataModel() {
        this.myWizardContext.setProjectName(this.getProjectName());
        String string = this.getProjectFileDirectory();
        this.myWizardContext.setProjectFileDirectory(string);
        ProjectBuilder projectBuilder = this.myWizardContext.getProjectBuilder();
        if (projectBuilder != null) {
            this.myWizardContext.setProjectBuilder(projectBuilder);
            if (projectBuilder instanceof ModuleBuilder) {
                ((ModuleBuilder)projectBuilder).setContentEntryPath(string);
            } else if (projectBuilder instanceof ProjectFromSourcesBuilderImpl) {
                ((ProjectFromSourcesBuilderImpl)projectBuilder).setBaseProjectPath(string);
            }
        }
        this.b.updateData(this.myWizardContext);
    }

    public Icon getIcon() {
        return this.myWizardContext.getStepIcon();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNamePathComponent.getNameComponent();
    }

    public String getHelpId() {
        return "reference.dialogs.new.project.fromCode.name";
    }

    public String getProjectFileDirectory() {
        return this.myNamePathComponent.getPath();
    }

    public String getProjectName() {
        return this.myNamePathComponent.getNameValue();
    }

    public boolean validate() throws ConfigurationException {
        return this.myNamePathComponent.validateNameAndPath(this.myWizardContext, this.b.isDefault());
    }
}

