/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetectionUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.util.ui.JBUI;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourcePathsStep
extends AbstractStepWithProgress<List<JavaModuleSourceRoot>> {
    private static final Logger r = Logger.getInstance((String)"#com.intellij.ide.util.newProjectWizard.SourcePathsStep");
    private String p;
    @NonNls
    private static final String q = "create_source";
    @NonNls
    private static final String v = "choose_source";
    private final SourcePathsBuilder t;
    private final Icon j;
    private final String s;
    private ElementsChooser<JavaModuleSourceRoot> n;
    private String k = null;
    private JRadioButton u;
    private JRadioButton m;
    private JTextField i;
    private JTextField o;
    private JPanel l;

    public SourcePathsStep(SourcePathsBuilder sourcePathsBuilder, Icon icon, @NonNls String string) {
        super(IdeBundle.message((String)"prompt.stop.searching.for.sources", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}));
        this.t = sourcePathsBuilder;
        this.j = icon;
        this.s = string;
    }

    @Override
    protected JComponent createResultsPanel() {
        this.l = new JPanel(new CardLayout());
        this.l.add((Component)this.b(), q);
        this.l.add((Component)this.d(), v);
        return this.l;
    }

    private JComponent b() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        String string = IdeBundle.message((String)"prompt.please.specify.java.sources.directory", (Object[])new Object[0]);
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        this.u = new JRadioButton(IdeBundle.message((String)"radio.create.source.directory", (Object[])new Object[0]), true);
        jPanel.add((Component)this.u, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        this.i = new JTextField(this.suggestSourceDirectoryName());
        final JLabel jLabel2 = new JLabel(IdeBundle.message((String)"prompt.enter.relative.path.to.module.content.root", (Object[])new Object[]{File.separator}));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)30, (int)0, (int)0), 0, 0));
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fileChooserDescriptor.withTreeRootVisible(true);
        final FieldPanel fieldPanel = SourcePathsStep.createFieldPanel((JTextField)this.i, null, (BrowseFilesListener)new BrowsePathListener(this.i, fileChooserDescriptor));
        jPanel.add((Component)fieldPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)30, (int)0, (int)10), 0, 0));
        this.m = new JRadioButton(IdeBundle.message((String)"radio.do.not.create.source.directory", (Object[])new Object[0]), true);
        jPanel.add((Component)this.m, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 0, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        final JLabel jLabel3 = new JLabel(IdeBundle.message((String)"label.source.directory", (Object[])new Object[0]));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 16, 0, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        this.o = new JTextField();
        this.o.setEditable(false);
        this.o.setOpaque(false);
        Insets insets = this.o.getBorder().getBorderInsets(this.o);
        this.o.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        jPanel.add((Component)this.o, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 16, 2, (Insets)JBUI.insets((int)8, (int)10), 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.u);
        buttonGroup.add(this.m);
        this.i.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent documentEvent) {
                SourcePathsStep.this.a();
            }
        });
        this.u.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl2 = itemEvent.getStateChange() == 1;
                jLabel2.setEnabled(bl2);
                fieldPanel.setEnabled(bl2);
                jLabel3.setVisible(bl2);
                SourcePathsStep.this.o.setVisible(bl2);
                if (bl2) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)SourcePathsStep.this.i, true));
                }
            }
        });
        return jPanel;
    }

    @NonNls
    protected String suggestSourceDirectoryName() {
        return "src";
    }

    private void a() {
        block3: {
            block2: {
                String string = this.e();
                try {
                    if (string == null) break block2;
                    this.o.setText(string.replace('/', File.separatorChar));
                    break block3;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SourcePathsStep.b(illegalStateException);
                }
            }
            this.o.setText("");
        }
    }

    private JComponent d() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.n = new ElementsChooser<JavaModuleSourceRoot>(true){

            public String getItemText(@NotNull JavaModuleSourceRoot javaModuleSourceRoot) {
                String string;
                StringBuilder stringBuilder;
                try {
                    if (javaModuleSourceRoot == null) {
                        3.a(0);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 3.a(illegalArgumentException);
                }
                String string2 = javaModuleSourceRoot.getPackagePrefix();
                try {
                    stringBuilder = new StringBuilder().append(javaModuleSourceRoot.getDirectory().getAbsolutePath());
                    string = string2.isEmpty() ? "" : " (" + string2 + ")";
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 3.a(illegalArgumentException);
                }
                return stringBuilder.append(string).append(" [").append(javaModuleSourceRoot.getRootTypeName()).append("]").toString();
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoot", "com/intellij/ide/util/newProjectWizard/SourcePathsStep$3", "getItemText"));
            }

            private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
                return illegalArgumentException;
            }
        };
        String string = IdeBundle.message((String)"label.java.source.files.have.been.found", (Object[])new Object[0]);
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        jPanel.add((Component)this.n, new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.insets((int)8, (int)10), 0, 0));
        JButton jButton = new JButton(IdeBundle.message((String)"button.mark.all", (Object[])new Object[0]));
        jPanel.add((Component)jButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)0, (int)10, (int)8, (int)2), 0, 0));
        JButton jButton2 = new JButton(IdeBundle.message((String)"button.unmark.all", (Object[])new Object[0]));
        jPanel.add((Component)jButton2, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)0, (int)0, (int)8, (int)10), 0, 0));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourcePathsStep.this.n.setAllElementsMarked(true);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourcePathsStep.this.n.setAllElementsMarked(false);
            }
        });
        return jPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent;
        try {
            jComponent = this.u.isSelected() ? this.i : this.n.getComponent();
        }
        catch (IllegalStateException illegalStateException) {
            throw SourcePathsStep.b(illegalStateException);
        }
        return jComponent;
    }

    public void updateDataModel() {
        block8: {
            block7: {
                String string;
                List<Object> list = null;
                if (v.equals(this.p)) {
                    List list2 = this.n.getMarkedElements();
                    if (list2.size() > 0) {
                        list = new ArrayList(list2.size());
                        for (JavaModuleSourceRoot javaModuleSourceRoot : list2) {
                            list.add(Pair.create((Object)FileUtil.toSystemIndependentName((String)javaModuleSourceRoot.getDirectory().getAbsolutePath()), (Object)javaModuleSourceRoot.getPackagePrefix()));
                        }
                    }
                } else if (this.u.isSelected() && (string = this.e()) != null) {
                    list = Collections.singletonList(Pair.create((Object)string, (Object)""));
                }
                try {
                    this.t.setContentEntryPath(this.c());
                    if (list == null) break block7;
                    this.t.setSourcePaths(list);
                    break block8;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SourcePathsStep.b(illegalStateException);
                }
            }
            this.t.setSourcePaths(new ArrayList());
        }
    }

    @Override
    public boolean validate() throws ConfigurationException {
        block18: {
            Object object;
            try {
                if (!super.validate()) {
                    return false;
                }
            }
            catch (IOException iOException) {
                throw SourcePathsStep.b(iOException);
            }
            try {
                if (!q.equals(this.p) || !this.u.isSelected()) break block18;
            }
            catch (IOException iOException) {
                throw SourcePathsStep.b(iOException);
            }
            String string = this.e();
            String string2 = this.i.getText().trim();
            if (string2.length() == 0) {
                object = IdeBundle.message((String)"prompt.relative.path.to.sources.empty", (Object[])new Object[]{FileUtil.toSystemDependentName((String)string)});
                int n2 = Messages.showYesNoCancelDialog((Component)this.i, (String)object, (String)IdeBundle.message((String)"title.mark.source.directory", (Object[])new Object[0]), (String)IdeBundle.message((String)"action.mark", (Object[])new Object[0]), (String)IdeBundle.message((String)"action.do.not.mark", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
                try {
                    if (n2 == 2) {
                        return false;
                    }
                }
                catch (IOException iOException) {
                    throw SourcePathsStep.b(iOException);
                }
                try {
                    if (n2 == 1) {
                        this.m.doClick();
                    }
                }
                catch (IOException iOException) {
                    throw SourcePathsStep.b(iOException);
                }
            }
            if (string != null) {
                object = new File(this.c());
                File file = new File(string);
                try {
                    if (!FileUtil.isAncestor((File)object, (File)file, (boolean)false)) {
                        Messages.showErrorDialog((Component)this.i, (String)IdeBundle.message((String)"error.source.directory.should.be.under.module.content.root.directory", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle());
                        return false;
                    }
                }
                catch (IOException iOException) {
                    throw SourcePathsStep.b(iOException);
                }
                try {
                    VfsUtil.createDirectories((String)file.getPath());
                }
                catch (IOException iOException) {
                    throw new ConfigurationException(iOException.getMessage());
                }
            }
        }
        return true;
    }

    @Nullable
    private String e() {
        String string = this.c();
        if (string != null) {
            String string2;
            String string3 = this.i.getText().trim().replace(File.separatorChar, '/');
            try {
                string2 = string3.length() > 0 ? string + "/" + string3 : string;
            }
            catch (IllegalStateException illegalStateException) {
                throw SourcePathsStep.b(illegalStateException);
            }
            return string2;
        }
        return null;
    }

    @Override
    protected boolean shouldRunProgress() {
        return this.isContentEntryChanged();
    }

    @Override
    protected void onFinished(List<JavaModuleSourceRoot> list, boolean bl2) {
        block12: {
            block11: {
                String string;
                SourcePathsStep sourcePathsStep;
                block10: {
                    block9: {
                        try {
                            if (list.size() <= 0) break block9;
                            this.p = v;
                            this.n.setElements(list, true);
                            break block10;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SourcePathsStep.b(illegalStateException);
                        }
                    }
                    this.p = q;
                    this.a();
                }
                try {
                    sourcePathsStep = this;
                    string = bl2 ? null : this.c();
                }
                catch (IllegalStateException illegalStateException) {
                    throw SourcePathsStep.b(illegalStateException);
                }
                try {
                    sourcePathsStep.b(string);
                    if (!v.equals(this.p)) break block11;
                    this.n.selectElements(list.subList(0, 1));
                    break block12;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SourcePathsStep.b(illegalStateException);
                }
            }
            try {
                if (q.equals(this.p)) {
                    this.i.selectAll();
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw SourcePathsStep.b(illegalStateException);
            }
        }
    }

    private void b(String string) {
        this.k = string;
        ((CardLayout)this.l.getLayout()).show(this.l, this.p);
        this.l.revalidate();
    }

    protected boolean isContentEntryChanged() {
        boolean bl2;
        block8: {
            String string;
            block6: {
                block7: {
                    string = this.c();
                    try {
                        try {
                            if (this.k != null) break block6;
                            if (string == null) break block7;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SourcePathsStep.b(illegalStateException);
                        }
                        bl2 = true;
                        break block8;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SourcePathsStep.b(illegalStateException);
                    }
                }
                bl2 = false;
                break block8;
            }
            try {
                bl2 = !this.k.equals(string);
            }
            catch (IllegalStateException illegalStateException) {
                throw SourcePathsStep.b(illegalStateException);
            }
        }
        return bl2;
    }

    @Override
    protected List<JavaModuleSourceRoot> calculate() {
        return new ArrayList<JavaModuleSourceRoot>(SourcePathsStep.calculateSourceRoots(this.c()));
    }

    @NotNull
    public static Collection<JavaModuleSourceRoot> calculateSourceRoots(String string) {
        Collection<JavaModuleSourceRoot> collection;
        block7: {
            List<JavaModuleSourceRoot> list;
            block8: {
                try {
                    try {
                        if (string != null) break block7;
                        list = Collections.emptyList();
                        if (list != null) break block8;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SourcePathsStep.b(illegalStateException);
                    }
                    SourcePathsStep.a(0);
                }
                catch (IllegalStateException illegalStateException) {
                    throw SourcePathsStep.b(illegalStateException);
                }
            }
            return list;
        }
        try {
            collection = JavaSourceRootDetectionUtil.suggestRoots(new File(string));
            if (collection == null) {
                SourcePathsStep.a(1);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SourcePathsStep.b(illegalStateException);
        }
        return collection;
    }

    @Nullable
    private String c() {
        return this.t.getContentEntryPath();
    }

    protected void setSourceDirectoryName(String string) {
        String string2;
        try {
            string2 = string == null ? "" : string.trim();
        }
        catch (IllegalStateException illegalStateException) {
            throw SourcePathsStep.b(illegalStateException);
        }
        string = string2;
        this.i.setText(string);
    }

    @Override
    protected String getProgressText() {
        String string;
        Object[] objectArray;
        String string2;
        String string3 = this.c();
        try {
            string2 = "progress.searching.for.sources";
            Object[] objectArray2 = new Object[1];
            Object[] objectArray3 = objectArray2;
            objectArray = objectArray2;
            int n2 = 0;
            string = string3 != null ? string3.replace('/', File.separatorChar) : "";
        }
        catch (IllegalStateException illegalStateException) {
            throw SourcePathsStep.b(illegalStateException);
        }
        objectArray3[n2] = string;
        return IdeBundle.message((String)string2, (Object[])objectArray);
    }

    public Icon getIcon() {
        return this.j;
    }

    public String getHelpId() {
        return this.s;
    }

    public String getName() {
        return "Path to Sources";
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/newProjectWizard/SourcePathsStep", "calculateSourceRoots"));
    }

    private static Exception b(Exception exception) {
        return exception;
    }

    private class BrowsePathListener
    extends BrowseFilesListener {
        private final FileChooserDescriptor b;
        private final JTextField a;

        public BrowsePathListener(JTextField jTextField, FileChooserDescriptor fileChooserDescriptor) {
            super(jTextField, IdeBundle.message((String)"prompt.select.source.directory", (Object[])new Object[0]), "", fileChooserDescriptor);
            this.b = fileChooserDescriptor;
            this.a = jTextField;
        }

        @Nullable
        private VirtualFile a() {
            String string = SourcePathsStep.this.c();
            try {
                if (string != null) {
                    return (VirtualFile)WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(string));
                }
            }
            catch (RuntimeException runtimeException) {
                throw BrowsePathListener.b(runtimeException);
            }
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VirtualFile virtualFile = this.a();
            if (virtualFile != null) {
                this.b.setRoots(new VirtualFile[]{virtualFile});
                String string = this.a.getText().trim();
                super.actionPerformed(actionEvent);
                if (!string.equals(this.a.getText().trim())) {
                    boolean bl2;
                    Logger logger;
                    String string2 = this.a.getText().trim().replace(File.separatorChar, '/');
                    VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(string2);
                    try {
                        logger = r;
                        bl2 = virtualFile2 != null;
                    }
                    catch (RuntimeException runtimeException) {
                        throw BrowsePathListener.b(runtimeException);
                    }
                    logger.assertTrue(bl2);
                    this.a.setText(VfsUtilCore.getRelativePath((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (char)File.separatorChar));
                }
            }
        }

        private static RuntimeException b(RuntimeException runtimeException) {
            return runtimeException;
        }
    }
}

