/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.projectWizard.JdkChooserPanel;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkListConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectJdkForModuleStep
extends ModuleWizardStep {
    private final JdkChooserPanel d;
    @NotNull
    private final JPanel a;
    private final WizardContext c;
    private final SdkType b;
    private boolean e = false;
    private final JButton f;

    public ProjectJdkForModuleStep(final WizardContext wizardContext, final SdkType sdkType) {
        this.c = wizardContext;
        this.b = sdkType;
        this.d = new JdkChooserPanel(ProjectJdkForModuleStep.a(wizardContext, sdkType));
        this.a = new JPanel(new GridBagLayout());
        this.a.setBorder(BorderFactory.createEtchedBorder());
        JLabel jLabel = new JLabel(IdeBundle.message((String)"prompt.please.select.module.jdk", (Object[])new Object[]{sdkType.getPresentableName()}));
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        this.a.add((Component)jLabel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10), 0, 0));
        JLabel jLabel2 = new JLabel(IdeBundle.message((String)"label.project.jdk", (Object[])new Object[0]));
        jLabel2.setFont(UIUtil.getLabelFont().deriveFont(1));
        this.a.add((Component)jLabel2, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        this.a.add((Component)this.d, new GridBagConstraints(0, -1, 1, 2, 1.0, 1.0, 18, 1, (Insets)JBUI.insets((int)2, (int)10, (int)10, (int)5), 0, 0));
        JButton jButton = new JButton(IdeBundle.message((String)"button.configure", (Object[])new Object[0]));
        this.a.add((Component)jButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)2, (int)0, (int)5, (int)5), 0, 0));
        this.f = new JButton("Set Default");
        this.f.setMnemonic('D');
        this.a.add((Component)this.f, new GridBagConstraints(1, -1, 1, 1, 0.0, 1.0, 18, 0, (Insets)JBUI.insets((int)2, (int)0, (int)10, (int)5), 0, 0));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Project project2 = ProjectJdkForModuleStep.a(wizardContext, sdkType);
                ProjectStructureConfigurable projectStructureConfigurable = ProjectStructureConfigurable.getInstance(project2);
                JdkListConfigurable jdkListConfigurable = JdkListConfigurable.getInstance(project2);
                ProjectSdksModel projectSdksModel = projectStructureConfigurable.getProjectJdksModel();
                boolean[] blArray = new boolean[1];
                projectSdksModel.reset(project2);
                projectSdksModel.doAdd((JComponent)ProjectJdkForModuleStep.this.a, sdkType, sdk -> {
                    blArray[0] = jdkListConfigurable.addJdkNode((Sdk)sdk, false);
                    ProjectJdkForModuleStep.this.d.updateList((Sdk)sdk, sdkType, projectSdksModel.getSdks());
                    if (!blArray[0]) {
                        try {
                            projectSdksModel.apply((MasterDetailsComponent)jdkListConfigurable);
                        }
                        catch (ConfigurationException configurationException) {
                            // empty catch block
                        }
                    }
                });
            }
        });
        final Project project2 = ProjectManagerEx.getInstanceEx().getDefaultProject();
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Sdk sdk = ProjectJdkForModuleStep.this.getJdk();
                Runnable runnable = () -> ProjectRootManagerEx.getInstanceEx((Project)project2).setProjectSdk(sdk);
                ApplicationManager.getApplication().runWriteAction(runnable);
                ProjectJdkForModuleStep.this.f.setEnabled(false);
            }
        });
        this.d.addSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ProjectJdkForModuleStep.this.f.setEnabled(ProjectJdkForModuleStep.this.getJdk() != ProjectRootManagerEx.getInstanceEx((Project)project2).getProjectSdk());
            }
        });
    }

    @Nullable
    private static Project a(WizardContext wizardContext, SdkType sdkType) {
        Project project2 = wizardContext.getProject();
        if (sdkType != null && project2 == null) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        return project2;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.d.getPreferredFocusedComponent();
    }

    public String getHelpId() {
        return "project.new.page2";
    }

    public JComponent getComponent() {
        return this.a;
    }

    public void updateDataModel() {
        this.c.setProjectJdk(this.getJdk());
    }

    public void updateStep() {
        if (!this.e) {
            this.d.fillList(this.b, null);
            Sdk sdk = ProjectJdkForModuleStep.a(this.c);
            if (sdk != null) {
                this.d.selectJdk(sdk);
            }
            this.f.setEnabled(sdk != null);
            this.e = true;
        }
    }

    public Sdk getJdk() {
        return this.d.getChosenJdk();
    }

    public Object[] getAllJdks() {
        return this.d.getAllJdks();
    }

    public Icon getIcon() {
        return this.c.getStepIcon();
    }

    @Nullable
    private static Sdk a(WizardContext wizardContext) {
        Project project2 = ProjectManagerEx.getInstanceEx().getDefaultProject();
        Sdk sdk = ProjectRootManagerEx.getInstanceEx((Project)project2).getProjectSdk();
        if (sdk == null) {
            return AddModuleWizard.getMostRecentSuitableSdk(wizardContext);
        }
        return sdk;
    }

    public boolean validate() {
        int n2;
        Sdk sdk = this.d.getChosenJdk();
        return sdk != null || (n2 = Messages.showOkCancelDialog((String)IdeBundle.message((String)"prompt.confirm.project.no.jdk", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.no.jdk.specified", (Object[])new Object[0]), (Icon)Messages.getWarningIcon())) == 0;
    }
}

