/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAttachSourceProvider
implements AttachSourcesProvider {
    private static final Logger a = Logger.getInstance(AbstractAttachSourceProvider.class);

    @Nullable
    protected static VirtualFile getJarByPsiFile(@Nullable PsiFile psiFile) {
        VirtualFile virtualFile;
        if (psiFile != null && (virtualFile = psiFile.getVirtualFile()) != null) {
            VirtualFileSystem virtualFileSystem = virtualFile.getFileSystem();
            try {
                if (virtualFileSystem instanceof JarFileSystem) {
                    return ((JarFileSystem)virtualFileSystem).getLocalByEntry(virtualFile);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw AbstractAttachSourceProvider.a(illegalArgumentException);
            }
        }
        return null;
    }

    @Nullable
    protected static Library getLibraryFromOrderEntriesList(List<LibraryOrderEntry> list) {
        try {
            if (list.isEmpty()) {
                return null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw AbstractAttachSourceProvider.a(illegalArgumentException);
        }
        Library library = list.get(0).getLibrary();
        try {
            if (library == null) {
                return null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw AbstractAttachSourceProvider.a(illegalArgumentException);
        }
        int n2 = 1;
        while (true) {
            block11: {
                try {
                    try {
                        if (n2 >= list.size()) break;
                        if (library.equals(list.get(n2).getLibrary())) break block11;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw AbstractAttachSourceProvider.a(illegalArgumentException);
                    }
                    return null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw AbstractAttachSourceProvider.a(illegalArgumentException);
                }
            }
            ++n2;
        }
        return library;
    }

    protected void addSourceFile(@Nullable VirtualFile virtualFile, @NotNull Library library) {
        block5: {
            try {
                if (library == null) {
                    AbstractAttachSourceProvider.a(0);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw AbstractAttachSourceProvider.a(illegalArgumentException);
            }
            try {
                if (virtualFile == null || Arrays.asList(library.getFiles(OrderRootType.SOURCES)).contains(virtualFile)) break block5;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw AbstractAttachSourceProvider.a(illegalArgumentException);
            }
            Library.ModifiableModel modifiableModel = library.getModifiableModel();
            modifiableModel.addRoot(virtualFile, OrderRootType.SOURCES);
            modifiableModel.commit();
        }
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/jarFinder/AbstractAttachSourceProvider", "addSourceFile"));
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    protected static abstract class DownloadSourcesAction
    implements AttachSourcesProvider.AttachSourcesAction {
        protected final Project myProject;
        protected final String myUrl;
        protected final String myMessageGroupId;

        public DownloadSourcesAction(Project project2, String string, String string2) {
            this.myProject = project2;
            this.myUrl = string2;
            this.myMessageGroupId = string;
        }

        public String getName() {
            return "Download Sources";
        }

        public String getBusyText() {
            return "Downloading Sources...";
        }

        protected abstract void storeFile(byte[] var1);

        public ActionCallback perform(List<LibraryOrderEntry> list) {
            final ActionCallback actionCallback = new ActionCallback();
            Task.Backgroundable backgroundable = new Task.Backgroundable(this.myProject, "Downloading Sources", true){

                public void run(@NotNull ProgressIndicator progressIndicator) {
                    byte[] byArray;
                    try {
                        if (progressIndicator == null) {
                            1.a(0);
                        }
                    }
                    catch (IOException iOException) {
                        throw 1.b(iOException);
                    }
                    try {
                        a.info("Downloading sources JAR: " + myUrl);
                        progressIndicator.checkCanceled();
                        byArray = HttpRequests.request((String)myUrl).readBytes(progressIndicator);
                    }
                    catch (IOException iOException) {
                        a.warn((Throwable)iOException);
                        ApplicationManager.getApplication().invokeLater(() -> {
                            String string = "Failed to download sources: " + myUrl;
                            new Notification(myMessageGroupId, "Downloading failed", string, NotificationType.ERROR).notify(this.getProject());
                            actionCallback.setDone();
                        });
                        return;
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        try {
                            WriteAction.run(() -> this.storeFile(byArray));
                        }
                        finally {
                            actionCallback.setDone();
                        }
                    });
                }

                public void onCancel() {
                    actionCallback.setRejected();
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarFinder/AbstractAttachSourceProvider$DownloadSourcesAction$1", "run"));
                }

                private static IOException b(IOException iOException) {
                    return iOException;
                }
            };
            backgroundable.queue();
            return actionCallback;
        }
    }

    protected class AttachExistingSourceAction
    implements AttachSourcesProvider.AttachSourcesAction {
        private final String c;
        private final VirtualFile b;
        private final Library a;

        public AttachExistingSourceAction(VirtualFile virtualFile, Library library, String string) {
            this.b = virtualFile;
            this.a = library;
            this.c = string;
        }

        public String getName() {
            return this.c;
        }

        public String getBusyText() {
            return this.getName();
        }

        public ActionCallback perform(List<LibraryOrderEntry> list) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            ActionCallback actionCallback = new ActionCallback();
            try {
                actionCallback.setDone();
                if (!this.b.isValid()) {
                    return actionCallback;
                }
            }
            catch (RuntimeException runtimeException) {
                throw AttachExistingSourceAction.b(runtimeException);
            }
            try {
                if (this.a != AbstractAttachSourceProvider.getLibraryFromOrderEntriesList(list)) {
                    return actionCallback;
                }
            }
            catch (RuntimeException runtimeException) {
                throw AttachExistingSourceAction.b(runtimeException);
            }
            WriteAction.run(() -> AbstractAttachSourceProvider.this.addSourceFile(this.b, this.a));
            return actionCallback;
        }

        private static RuntimeException b(RuntimeException runtimeException) {
            return runtimeException;
        }
    }
}

