/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.Parameterized;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

public class PathManagerEx {
    private static final ConcurrentMap<Class, TestDataLookupStrategy> a;
    private static final ConcurrentMap<String, Class> d;
    private static Set<String> c;
    private static final Map<TestDataLookupStrategy, List<String>> b;
    static final /* synthetic */ boolean $assertionsDisabled;

    private PathManagerEx() {
    }

    @NonNls
    public static String getTestDataPath() throws IllegalStateException {
        TestDataLookupStrategy testDataLookupStrategy = PathManagerEx.guessTestDataLookupStrategy();
        return PathManagerEx.getTestDataPath(testDataLookupStrategy);
    }

    public static String getTestDataPath(String string) throws IllegalStateException {
        return PathManagerEx.getTestDataPath() + string.replace('/', File.separatorChar);
    }

    public static String getTestDataPath(Class<?> clazz) throws IllegalStateException {
        TestDataLookupStrategy testDataLookupStrategy;
        try {
            testDataLookupStrategy = PathManagerEx.c() ? TestDataLookupStrategy.COMMUNITY : PathManagerEx.c(clazz);
        }
        catch (IllegalStateException illegalStateException) {
            throw PathManagerEx.b(illegalStateException);
        }
        TestDataLookupStrategy testDataLookupStrategy2 = testDataLookupStrategy;
        return PathManagerEx.getTestDataPath(testDataLookupStrategy2);
    }

    @NotNull
    public static String getCommunityHomePath() {
        String string;
        String string2;
        String string3 = PathManager.getHomePath();
        try {
            string2 = PathManagerEx.c() ? string3 : string3 + File.separator + "community";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PathManagerEx.b(illegalArgumentException);
        }
        try {
            string = string2;
            if (string2 == null) {
                PathManagerEx.a(0);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PathManagerEx.b(illegalArgumentException);
        }
        return string;
    }

    public static String getHomePath(Class<?> clazz) {
        String string;
        TestDataLookupStrategy testDataLookupStrategy;
        try {
            testDataLookupStrategy = PathManagerEx.c() ? TestDataLookupStrategy.COMMUNITY : PathManagerEx.c(clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PathManagerEx.b(illegalArgumentException);
        }
        TestDataLookupStrategy testDataLookupStrategy2 = testDataLookupStrategy;
        try {
            string = testDataLookupStrategy2 == TestDataLookupStrategy.COMMUNITY_FROM_ULTIMATE ? PathManagerEx.getCommunityHomePath() : PathManager.getHomePath();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PathManagerEx.b(illegalArgumentException);
        }
        return string;
    }

    public static File findFileUnderCommunityHome(String string) {
        File file = new File(PathManagerEx.getCommunityHomePath(), FileUtil.toSystemDependentName((String)string));
        try {
            if (!file.exists()) {
                throw new IllegalArgumentException("Cannot find file '" + string + "' under '" + PathManagerEx.getCommunityHomePath() + "' directory");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PathManagerEx.b(illegalArgumentException);
        }
        return file;
    }

    public static File findFileUnderProjectHome(String string, Class<? extends TestCase> clazz) {
        String string2 = PathManagerEx.getHomePath(clazz);
        File file = new File(string2, FileUtil.toSystemDependentName((String)string));
        try {
            if (!file.exists()) {
                throw new IllegalArgumentException("Cannot find file '" + string + "' under '" + string2 + "' directory");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PathManagerEx.b(illegalArgumentException);
        }
        return file;
    }

    private static boolean c() {
        boolean bl2;
        FileSystemLocation fileSystemLocation = PathManagerEx.b();
        try {
            bl2 = fileSystemLocation == FileSystemLocation.COMMUNITY;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PathManagerEx.b(illegalArgumentException);
        }
        return bl2;
    }

    @NonNls
    public static String getTestDataPath(TestDataLookupStrategy testDataLookupStrategy) throws IllegalStateException {
        String string = PathManager.getHomePath();
        List<String> list = b.get((Object)testDataLookupStrategy);
        try {
            if (list.isEmpty()) {
                throw new IllegalStateException(String.format("Can't determine test data path. Reason: no predefined relative paths are configured for test data lookup strategy %s. Configured mappings: %s", new Object[]{testDataLookupStrategy, b}));
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw PathManagerEx.b(illegalStateException);
        }
        File file = null;
        for (String string2 : list) {
            file = new File(string, string2);
            try {
                if (!file.isDirectory()) continue;
                return file.getPath();
            }
            catch (IllegalStateException illegalStateException) {
                throw PathManagerEx.b(illegalStateException);
            }
        }
        try {
            if (file == null) {
                throw new IllegalStateException("Can't determine test data path. Looks like programming error - reached 'if' block that was never expected to be executed");
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw PathManagerEx.b(illegalStateException);
        }
        return file.getPath();
    }

    public static TestDataLookupStrategy guessTestDataLookupStrategy() {
        TestDataLookupStrategy testDataLookupStrategy = PathManagerEx.a();
        if (testDataLookupStrategy == null) {
            testDataLookupStrategy = PathManagerEx.d();
        }
        return testDataLookupStrategy;
    }

    @Nullable
    private static TestDataLookupStrategy a() {
        TestDataLookupStrategy testDataLookupStrategy;
        Class<?> clazz;
        StackTraceElement[] stackTraceElementArray;
        try {
            if (PathManagerEx.c()) {
                return TestDataLookupStrategy.COMMUNITY;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PathManagerEx.b(illegalArgumentException);
        }
        Class<?> clazz2 = null;
        Class<?> clazz3 = null;
        for (StackTraceElement stackTraceElement : stackTraceElementArray = new Exception().getStackTrace()) {
            String string = stackTraceElement.getClassName();
            Class<?> clazz4 = PathManagerEx.a(string);
            try {
                try {
                    try {
                        if (clazz4 == null || TestCase.class == clazz4) continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw PathManagerEx.b(illegalArgumentException);
                    }
                    if (!PathManagerEx.b(clazz4)) {
                        continue;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw PathManagerEx.b(illegalArgumentException);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw PathManagerEx.b(illegalArgumentException);
            }
            try {
                if (PathManagerEx.c(clazz4) == TestDataLookupStrategy.ULTIMATE) {
                    return TestDataLookupStrategy.ULTIMATE;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw PathManagerEx.b(illegalArgumentException);
            }
            if ((clazz4.getModifiers() & 0x400) == 0) {
                clazz2 = clazz4;
                continue;
            }
            clazz3 = clazz4;
        }
        try {
            clazz = clazz2 == null ? clazz3 : clazz2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PathManagerEx.b(illegalArgumentException);
        }
        StackTraceElement[] stackTraceElementArray2 = clazz;
        try {
            testDataLookupStrategy = stackTraceElementArray2 == null ? null : PathManagerEx.c(stackTraceElementArray2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PathManagerEx.b(illegalArgumentException);
        }
        return testDataLookupStrategy;
    }

    @Nullable
    private static Class<?> a(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = (Class<?>)d.get(string);
        try {
            if (clazz != null) {
                return clazz;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PathManagerEx.b(illegalArgumentException);
        }
        ClassLoader classLoader2 = PathManagerEx.class.getClassLoader();
        ClassLoader classLoader3 = ClassLoader.getSystemClassLoader();
        for (ClassLoader classLoader4 : Arrays.asList(classLoader, classLoader2, classLoader3)) {
            clazz = PathManagerEx.a(string, classLoader4);
            try {
                if (clazz == null) continue;
                d.put(string, clazz);
                return clazz;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw PathManagerEx.b(illegalArgumentException);
            }
        }
        d.put(string, TestCase.class);
        return null;
    }

    @Nullable
    private static Class<?> a(String string, ClassLoader classLoader) {
        try {
            return Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            return null;
        }
    }

    private static boolean b(Class<?> clazz) {
        boolean bl2;
        block8: {
            block7: {
                try {
                    block6: {
                        try {
                            try {
                                if (TestCase.class.isAssignableFrom(clazz) || TestFrameworkUtil.isJUnit4TestClass(clazz)) break block6;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw PathManagerEx.b(illegalArgumentException);
                            }
                            if (!Parameterized.class.isAssignableFrom(clazz)) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw PathManagerEx.b(illegalArgumentException);
                        }
                    }
                    bl2 = true;
                    break block8;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw PathManagerEx.b(illegalArgumentException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    @Nullable
    private static TestDataLookupStrategy c(Class<?> clazz) {
        TestDataLookupStrategy testDataLookupStrategy;
        TestDataLookupStrategy testDataLookupStrategy2 = (TestDataLookupStrategy)((Object)a.get(clazz));
        try {
            if (testDataLookupStrategy2 != null) {
                return testDataLookupStrategy2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PathManagerEx.b(illegalArgumentException);
        }
        FileSystemLocation fileSystemLocation = PathManagerEx.a(clazz);
        try {
            testDataLookupStrategy = fileSystemLocation == FileSystemLocation.COMMUNITY ? TestDataLookupStrategy.COMMUNITY_FROM_ULTIMATE : TestDataLookupStrategy.ULTIMATE;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PathManagerEx.b(illegalArgumentException);
        }
        testDataLookupStrategy2 = testDataLookupStrategy;
        a.put(clazz, testDataLookupStrategy2);
        return testDataLookupStrategy2;
    }

    public static void replaceLookupStrategy(Class<?> clazz, Class<?> ... classArray) {
        a.clear();
        for (Class<?> clazz2 : classArray) {
            a.put(clazz2, PathManagerEx.c(clazz));
        }
    }

    private static FileSystemLocation a(Class<?> clazz) {
        FileSystemLocation fileSystemLocation;
        String string = PathManager.getJarPathForClass(clazz);
        try {
            if (string == null) {
                throw new IllegalStateException("Cannot find root directory for " + clazz);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PathManagerEx.b(illegalArgumentException);
        }
        File file = new File(string);
        try {
            if (!file.exists()) {
                throw new IllegalStateException("Classes root " + file + " doesn't exist");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PathManagerEx.b(illegalArgumentException);
        }
        try {
            if (!file.isDirectory()) {
                return FileSystemLocation.ULTIMATE;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PathManagerEx.b(illegalArgumentException);
        }
        String string2 = file.getName();
        String string3 = "ModuleChunk(";
        if (string2.startsWith(string3)) {
            string2 = StringUtil.trimStart((String)string2, (String)string3);
            string2 = string2.substring(0, string2.indexOf(44));
        }
        try {
            fileSystemLocation = PathManagerEx.e().contains(string2) ? FileSystemLocation.COMMUNITY : FileSystemLocation.ULTIMATE;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PathManagerEx.b(illegalArgumentException);
        }
        return fileSystemLocation;
    }

    /*
     * Loose catch block
     */
    private static synchronized Set<String> e() {
        try {
            if (c != null) {
                return c;
            }
        }
        catch (JDOMException jDOMException) {
            throw PathManagerEx.b((Exception)((Object)jDOMException));
        }
        c = new THashSet();
        File file = PathManagerEx.findFileUnderCommunityHome(".idea/modules.xml");
        try {
            if (!file.exists()) {
                throw new IllegalStateException("Cannot obtain test data path: " + file.getAbsolutePath() + " not found");
            }
        }
        catch (JDOMException jDOMException) {
            throw PathManagerEx.b((Exception)((Object)jDOMException));
        }
        try {
            Element element;
            block13: {
                element = JDomSerializationUtil.findComponent((Element)JDOMUtil.load((File)file), (String)"ProjectModuleManager");
                if ($assertionsDisabled) break block13;
                try {
                    block14: {
                        if (element != null) break block13;
                        break block14;
                        catch (JDOMException jDOMException) {
                            throw PathManagerEx.b((Exception)((Object)jDOMException));
                        }
                    }
                    throw new AssertionError();
                }
                catch (JDOMException jDOMException) {
                    throw PathManagerEx.b((Exception)((Object)jDOMException));
                }
            }
            for (ModulePath modulePath : ModuleManagerImpl.getPathsToModuleFiles((Element)element)) {
                c.add(modulePath.getModuleName());
            }
            return c;
        }
        catch (IOException | JDOMException throwable) {
            throw new RuntimeException("Cannot read modules from " + file.getAbsolutePath(), throwable);
        }
    }

    private static FileSystemLocation b() {
        FileSystemLocation fileSystemLocation;
        try {
            fileSystemLocation = new File(PathManager.getHomePath(), "community/.idea").isDirectory() ? FileSystemLocation.ULTIMATE : FileSystemLocation.COMMUNITY;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PathManagerEx.b(illegalArgumentException);
        }
        return fileSystemLocation;
    }

    private static TestDataLookupStrategy d() {
        String string = PathManager.getHomePath();
        for (Map.Entry<TestDataLookupStrategy, List<String>> entry : b.entrySet()) {
            for (String string2 : entry.getValue()) {
                try {
                    if (!new File(string, string2).isDirectory()) continue;
                    return entry.getKey();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw PathManagerEx.b(illegalArgumentException);
                }
            }
        }
        return TestDataLookupStrategy.ULTIMATE;
    }

    static {
        boolean bl2;
        try {
            bl2 = !PathManagerEx.class.desiredAssertionStatus();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PathManagerEx.b(illegalArgumentException);
        }
        $assertionsDisabled = bl2;
        a = ContainerUtil.newConcurrentMap();
        d = ContainerUtil.newConcurrentMap();
        b = new EnumMap<TestDataLookupStrategy, List<String>>(TestDataLookupStrategy.class);
        b.put(TestDataLookupStrategy.ULTIMATE, Collections.singletonList(FileUtil.toSystemDependentName((String)"testData")));
        b.put(TestDataLookupStrategy.COMMUNITY, Collections.singletonList(FileUtil.toSystemDependentName((String)"java/java-tests/testData")));
        b.put(TestDataLookupStrategy.COMMUNITY_FROM_ULTIMATE, Collections.singletonList(FileUtil.toSystemDependentName((String)"community/java/java-tests/testData")));
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/ex/PathManagerEx", "getCommunityHomePath"));
    }

    private static Exception b(Exception exception) {
        return exception;
    }

    public static enum TestDataLookupStrategy {
        ULTIMATE,
        COMMUNITY,
        COMMUNITY_FROM_ULTIMATE;

    }

    private static enum FileSystemLocation {
        ULTIMATE,
        COMMUNITY;

    }
}

