/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.wizard.AbstractExternalProjectImportProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.projectImport.ProjectImportProvider;

public class AttachExternalProjectAction
extends AnAction {
    public AttachExternalProjectAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.attach.external.project.text", (Object[])new Object[]{"external"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.attach.external.project.description", (Object[])new Object[]{"external"}));
    }

    public void update(AnActionEvent anActionEvent) {
        ProjectSystemId projectSystemId = (ProjectSystemId)ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID.getData(anActionEvent.getDataContext());
        if (projectSystemId != null) {
            String string = projectSystemId.getReadableName();
            anActionEvent.getPresentation().setText(ExternalSystemBundle.message((String)"action.attach.external.project.text", (Object[])new Object[]{string}));
            anActionEvent.getPresentation().setDescription(ExternalSystemBundle.message((String)"action.attach.external.project.description", (Object[])new Object[]{string}));
        }
        anActionEvent.getPresentation().setIcon(SystemInfoRt.isMac ? AllIcons.ToolbarDecorator.Mac.Add : AllIcons.ToolbarDecorator.Add);
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        ProjectSystemId projectSystemId = (ProjectSystemId)ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID.getData(anActionEvent.getDataContext());
        if (projectSystemId == null) {
            return;
        }
        ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)projectSystemId);
        if (externalSystemManager == null) {
            return;
        }
        Project project2 = anActionEvent.getProject();
        if (project2 == null) {
            return;
        }
        ProjectImportProvider[] projectImportProviderArray = new ProjectImportProvider[1];
        for (ProjectImportProvider projectImportProvider : (ProjectImportProvider[])ProjectImportProvider.PROJECT_IMPORT_PROVIDER.getExtensions()) {
            if (!(projectImportProvider instanceof AbstractExternalProjectImportProvider) || !projectSystemId.equals((Object)((AbstractExternalProjectImportProvider)projectImportProvider).getExternalSystemId())) continue;
            projectImportProviderArray[0] = projectImportProvider;
            break;
        }
        if (projectImportProviderArray[0] == null) {
            return;
        }
        AddModuleWizard addModuleWizard = ImportModuleAction.selectFileAndCreateWizard(project2, null, externalSystemManager.getExternalProjectDescriptor(), projectImportProviderArray);
        if (addModuleWizard != null && (addModuleWizard.getStepCount() <= 0 || addModuleWizard.showAndGet())) {
            ImportModuleAction.createFromWizard(project2, addModuleWizard);
        }
    }
}

