/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import javax.swing.JTree;
import org.jetbrains.annotations.Nullable;

public abstract class ExternalSystemTreeAction
extends ExternalSystemAction {
    @Override
    protected boolean isEnabled(AnActionEvent anActionEvent) {
        return super.isEnabled(anActionEvent) && ExternalSystemTreeAction.getTree(anActionEvent) != null;
    }

    @Nullable
    protected static JTree getTree(AnActionEvent anActionEvent) {
        return (JTree)ExternalSystemDataKeys.PROJECTS_TREE.getData(anActionEvent.getDataContext());
    }

    public static class ExpandAll
    extends ExternalSystemTreeAction {
        public void actionPerformed(AnActionEvent anActionEvent) {
            JTree jTree = ExpandAll.getTree(anActionEvent);
            if (jTree == null) {
                return;
            }
            for (int i2 = 0; i2 < jTree.getRowCount(); ++i2) {
                jTree.expandRow(i2);
            }
        }
    }

    public static class CollapseAll
    extends ExternalSystemTreeAction {
        public void actionPerformed(AnActionEvent anActionEvent) {
            JTree jTree = CollapseAll.getTree(anActionEvent);
            if (jTree == null) {
                return;
            }
            for (int i2 = jTree.getRowCount() - 1; i2 >= 0; --i2) {
                jTree.collapseRow(i2);
            }
        }
    }
}

