/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureLibraryTableModifiableModelProvider;
import com.intellij.openapi.util.Disposer;
import java.lang.reflect.Proxy;
import org.jetbrains.annotations.Nullable;

public class IdeaModifiableModelsProvider
implements ModifiableModelsProvider {
    @Nullable
    public ModifiableRootModel getModuleModifiableModel(Module module2) {
        ModuleEditor moduleEditor;
        Project project2 = module2.getProject();
        ModulesConfigurator modulesConfigurator = IdeaModifiableModelsProvider.a(project2);
        if (modulesConfigurator != null && !modulesConfigurator.isModuleModelCommitted() && (moduleEditor = modulesConfigurator.getModuleEditor(module2)) != null) {
            return moduleEditor.getModifiableRootModelProxy();
        }
        return ModuleRootManager.getInstance((Module)module2).getModifiableModel();
    }

    @Nullable
    private static ModulesConfigurator a(Project project2) {
        StructureConfigurableContext structureConfigurableContext = IdeaModifiableModelsProvider.b(project2);
        return structureConfigurableContext != null ? structureConfigurableContext.getModulesConfigurator() : null;
    }

    public void commitModuleModifiableModel(ModifiableRootModel modifiableRootModel) {
        if (!(modifiableRootModel instanceof Proxy)) {
            modifiableRootModel.commit();
        }
    }

    public void disposeModuleModifiableModel(ModifiableRootModel modifiableRootModel) {
        if (!(modifiableRootModel instanceof Proxy)) {
            modifiableRootModel.dispose();
        }
    }

    public ModifiableFacetModel getFacetModifiableModel(Module module2) {
        ModulesConfigurator modulesConfigurator = IdeaModifiableModelsProvider.a(module2.getProject());
        if (modulesConfigurator != null) {
            return modulesConfigurator.getFacetsConfigurator().getOrCreateModifiableModel(module2);
        }
        return FacetManager.getInstance((Module)module2).createModifiableModel();
    }

    public void commitFacetModifiableModel(Module module2, ModifiableFacetModel modifiableFacetModel) {
        ModulesConfigurator modulesConfigurator = IdeaModifiableModelsProvider.a(module2.getProject());
        if (modulesConfigurator == null || !(modulesConfigurator.getFacetsConfigurator().getFacetModel(module2) instanceof ModifiableFacetModel)) {
            modifiableFacetModel.commit();
        }
    }

    public LibraryTable.ModifiableModel getLibraryTableModifiableModel() {
        Project[] projectArray;
        for (Project project2 : projectArray = ProjectManager.getInstance().getOpenProjects()) {
            LibraryTable.ModifiableModel modifiableModel;
            if (!project2.isInitialized()) continue;
            StructureConfigurableContext structureConfigurableContext = IdeaModifiableModelsProvider.b(project2);
            StructureLibraryTableModifiableModelProvider structureLibraryTableModifiableModelProvider = structureConfigurableContext != null ? structureConfigurableContext.createModifiableModelProvider("application") : null;
            LibraryTable.ModifiableModel modifiableModel2 = modifiableModel = structureLibraryTableModifiableModelProvider != null ? structureLibraryTableModifiableModelProvider.getModifiableModel() : null;
            if (modifiableModel == null) continue;
            return modifiableModel;
        }
        return LibraryTablesRegistrar.getInstance().getLibraryTable().getModifiableModel();
    }

    public LibraryTable.ModifiableModel getLibraryTableModifiableModel(Project project2) {
        StructureConfigurableContext structureConfigurableContext = IdeaModifiableModelsProvider.b(project2);
        if (structureConfigurableContext != null) {
            StructureLibraryTableModifiableModelProvider structureLibraryTableModifiableModelProvider = structureConfigurableContext.createModifiableModelProvider("project");
            return structureLibraryTableModifiableModelProvider.getModifiableModel();
        }
        return LibraryTablesRegistrar.getInstance().getLibraryTable(project2).getModifiableModel();
    }

    public void disposeLibraryTableModifiableModel(LibraryTable.ModifiableModel modifiableModel) {
        if (!(modifiableModel instanceof LibrariesModifiableModel)) {
            Disposer.dispose((Disposable)modifiableModel);
        }
    }

    @Nullable
    private static StructureConfigurableContext b(Project project2) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return null;
        }
        ProjectStructureConfigurable projectStructureConfigurable = ProjectStructureConfigurable.getInstance(project2);
        return projectStructureConfigurable.isUiInitialized() ? projectStructureConfigurable.getContext() : null;
    }
}

