/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectConfigurable;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class BuildElementsEditor
extends ModuleElementsEditor {
    private JRadioButton g;
    private JRadioButton a;
    private CommitableFieldPanel f;
    private CommitableFieldPanel d;
    private JCheckBox b;
    private JLabel e;
    private JLabel c;

    protected BuildElementsEditor(ModuleConfigurationState moduleConfigurationState) {
        super(moduleConfigurationState);
    }

    public JComponent createComponentImpl() {
        this.g = new JRadioButton(ProjectBundle.message((String)"project.inherit.compile.output.path", (Object[])new Object[0]));
        this.a = new JRadioButton(ProjectBundle.message((String)"project.module.compile.output.path", (Object[])new Object[0]));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.g);
        buttonGroup.add(this.a);
        this.f = this.a(ProjectBundle.message((String)"module.paths.output.title", (Object[])new Object[0]), new CommitPathRunnable(){

            @Override
            public void saveUrl(String string) {
                if (BuildElementsEditor.this.g.isSelected()) {
                    return;
                }
                BuildElementsEditor.this.getCompilerExtension().setCompilerOutputPath(string);
                BuildElementsEditor.this.fireConfigurationChanged();
            }
        });
        this.d = this.a(ProjectBundle.message((String)"module.paths.test.output.title", (Object[])new Object[0]), new CommitPathRunnable(){

            @Override
            public void saveUrl(String string) {
                if (BuildElementsEditor.this.g.isSelected()) {
                    return;
                }
                BuildElementsEditor.this.getCompilerExtension().setCompilerOutputPathForTests(string);
                BuildElementsEditor.this.fireConfigurationChanged();
            }
        });
        this.b = new JCheckBox(ProjectBundle.message((String)"module.paths.exclude.output.checkbox", (Object[])new Object[0]), this.getCompilerExtension().isExcludeOutput());
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildElementsEditor.this.getCompilerExtension().setExcludeOutput(BuildElementsEditor.this.b.isSelected());
                BuildElementsEditor.this.fireConfigurationChanged();
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.g, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insets((int)6, (int)0, (int)0, (int)4), 0, 0));
        jPanel.add((Component)this.a, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insets((int)6, (int)0, (int)0, (int)4), 0, 0));
        this.e = new JLabel(ProjectBundle.message((String)"module.paths.output.label", (Object[])new Object[0]));
        jPanel.add((Component)this.e, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, (Insets)JBUI.insets((int)6, (int)12, (int)0, (int)4), 0, 0));
        jPanel.add((Component)((Object)this.f), new GridBagConstraints(1, -1, 2, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.insets((int)6, (int)4, (int)0, (int)0), 0, 0));
        this.c = new JLabel(ProjectBundle.message((String)"module.paths.test.output.label", (Object[])new Object[0]));
        jPanel.add((Component)this.c, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, (Insets)JBUI.insets((int)6, (int)16, (int)0, (int)4), 0, 0));
        jPanel.add((Component)((Object)this.d), new GridBagConstraints(1, -1, 2, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.insets((int)6, (int)4, (int)0, (int)0), 0, 0));
        jPanel.add((Component)this.b, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insets((int)6, (int)16, (int)0, (int)0), 0, 0));
        boolean bl2 = this.getCompilerExtension().isCompilerOutputPathInherited();
        this.g.setSelected(bl2);
        this.a.setSelected(!bl2);
        this.a();
        this.a(!bl2);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildElementsEditor.this.a(!BuildElementsEditor.this.g.isSelected());
            }
        };
        this.g.addActionListener(actionListener);
        this.a.addActionListener(actionListener);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)ProjectBundle.message((String)"project.roots.output.compiler.title", (Object[])new Object[0]), (boolean)true));
        jPanel2.add((Component)jPanel, "North");
        return jPanel2;
    }

    private void a() {
        if (this.getCompilerExtension().isCompilerOutputPathInherited()) {
            ProjectConfigurable projectConfigurable = ProjectStructureConfigurable.getInstance(this.myProject).getProjectConfig();
            if (projectConfigurable == null) {
                return;
            }
            String string = projectConfigurable.getCompilerOutputUrl();
            this.moduleCompileOutputChanged(string, this.getModel().getModule().getName());
        } else {
            String string;
            VirtualFile virtualFile = this.getCompilerExtension().getCompilerOutputPath();
            if (virtualFile != null) {
                this.f.setText(FileUtil.toSystemDependentName((String)virtualFile.getPath()));
            } else {
                string = this.getCompilerExtension().getCompilerOutputUrl();
                if (string != null) {
                    this.f.setText(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)string)));
                }
            }
            string = this.getCompilerExtension().getCompilerOutputPathForTests();
            if (string != null) {
                this.d.setText(FileUtil.toSystemDependentName((String)string.getPath()));
            } else {
                String string2 = this.getCompilerExtension().getCompilerOutputUrlForTests();
                if (string2 != null) {
                    this.d.setText(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)string2)));
                }
            }
        }
    }

    private void a(boolean bl2) {
        UIUtil.setEnabled((Component)((Object)this.f), (boolean)bl2, (boolean)true);
        UIUtil.setEnabled((Component)this.e, (boolean)bl2, (boolean)true);
        UIUtil.setEnabled((Component)((Object)this.d), (boolean)bl2, (boolean)true);
        UIUtil.setEnabled((Component)this.c, (boolean)bl2, (boolean)true);
        this.b.setEnabled(bl2);
        this.getCompilerExtension().inheritCompilerOutputPath(!bl2);
        this.a();
        this.fireConfigurationChanged();
    }

    private CommitableFieldPanel a(String string, CommitPathRunnable commitPathRunnable) {
        ExtendableTextField extendableTextField = new ExtendableTextField();
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fileChooserDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)this.getModel().getModule());
        fileChooserDescriptor.setHideIgnored(false);
        InsertPathAction.addTo((JTextComponent)extendableTextField, (FileChooserDescriptor)fileChooserDescriptor);
        FileChooserFactory.getInstance().installFileCompletion((JTextField)extendableTextField, fileChooserDescriptor, true, null);
        final Runnable runnable = () -> this.a((JTextField)extendableTextField, commitPathRunnable);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                runnable.run();
            }
        };
        this.a.addActionListener(actionListener);
        extendableTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                runnable.run();
            }
        });
        return new CommitableFieldPanel((JTextField)extendableTextField, null, null, (ActionListener)new BrowseFilesListener((JTextField)extendableTextField, string, "", fileChooserDescriptor){

            public void actionPerformed(ActionEvent actionEvent) {
                super.actionPerformed(actionEvent);
                runnable.run();
            }
        }, null, runnable);
    }

    public void saveData() {
        this.f.commit();
        this.d.commit();
        this.getCompilerExtension().commit();
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"output.tab.title", (Object[])new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "project.structureModulesPage.outputJavadoc";
    }

    public void moduleStateChanged() {
        this.b.setSelected(this.getCompilerExtension().isExcludeOutput());
    }

    public void moduleCompileOutputChanged(String string, String string2) {
        if (this.getCompilerExtension().isCompilerOutputPathInherited()) {
            if (string != null) {
                this.f.setText(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)(string + "/" + "production" + "/" + string2))));
                this.d.setText(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)(string + "/" + "test" + "/" + string2))));
            } else {
                this.f.setText(null);
                this.d.setText(null);
            }
        }
    }

    public CompilerModuleExtension getCompilerExtension() {
        return (CompilerModuleExtension)this.getModel().getModuleExtension(CompilerModuleExtension.class);
    }

    private /* synthetic */ void a(JTextField jTextField, CommitPathRunnable commitPathRunnable) {
        block8: {
            String string;
            String string2;
            block7: {
                try {
                    if (!this.getModel().isWritable()) {
                        return;
                    }
                }
                catch (IOException iOException) {
                    throw BuildElementsEditor.b(iOException);
                }
                string2 = jTextField.getText().trim();
                try {
                    if (string2.length() != 0) break block7;
                    commitPathRunnable.saveUrl(null);
                    break block8;
                }
                catch (IOException iOException) {
                    throw BuildElementsEditor.b(iOException);
                }
            }
            try {
                string = FileUtil.resolveShortWindowsName((String)string2);
            }
            catch (IOException iOException) {
                string = string2;
            }
            commitPathRunnable.saveUrl(VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)string)));
        }
    }

    private static IOException b(IOException iOException) {
        return iOException;
    }

    private static class CommitableFieldPanel
    extends FieldPanel {
        private final Runnable a;

        public CommitableFieldPanel(JTextField jTextField, String string, String string2, ActionListener actionListener, Runnable runnable, Runnable runnable2) {
            super(jTextField, string, string2, actionListener, runnable);
            this.a = runnable2;
        }

        public void commit() {
            this.a.run();
        }
    }

    private static interface CommitPathRunnable {
        public void saveUrl(String var1);
    }
}

