/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.ColoredListCellRendererWrapper;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class LanguageLevelCombo
extends ComboBox {
    private boolean a;
    private final String b;

    public LanguageLevelCombo(String string) {
        this.b = string;
        for (LanguageLevel languageLevel : LanguageLevel.values()) {
            this.addItem(languageLevel);
        }
        this.setRenderer((ListCellRenderer)new ColoredListCellRendererWrapper(){

            protected void doCustomize(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
                if (object instanceof LanguageLevel) {
                    this.append(((LanguageLevel)object).getPresentableText());
                } else if (object instanceof String) {
                    this.append((String)object);
                    LanguageLevel languageLevel = LanguageLevelCombo.this.getDefaultLevel();
                    if (languageLevel != null) {
                        this.append(" (" + languageLevel.getPresentableText() + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }
            }
        });
    }

    public void reset(@NotNull Project project2) {
        block7: {
            LanguageLevelProjectExtension languageLevelProjectExtension;
            block6: {
                try {
                    if (project2 == null) {
                        LanguageLevelCombo.a(0);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw LanguageLevelCombo.a(illegalArgumentException);
                }
                this.removeAllItems();
                for (LanguageLevel languageLevel : LanguageLevel.values()) {
                    this.addItem(languageLevel);
                }
                Sdk sdk = ProjectRootManagerEx.getInstanceEx((Project)project2).getProjectSdk();
                this.sdkUpdated(sdk, project2.isDefault());
                languageLevelProjectExtension = LanguageLevelProjectExtension.getInstance((Project)project2);
                try {
                    if (!languageLevelProjectExtension.isDefault()) break block6;
                    this.setSelectedItem(this.b);
                    break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw LanguageLevelCombo.a(illegalArgumentException);
                }
            }
            this.setSelectedItem(languageLevelProjectExtension.getLanguageLevel());
        }
    }

    protected abstract LanguageLevel getDefaultLevel();

    void sdkUpdated(Sdk sdk, boolean bl2) {
        JavaSdkVersion javaSdkVersion;
        LanguageLevel languageLevel = null;
        if (sdk != null && (javaSdkVersion = JavaSdk.getInstance().getVersion(sdk)) != null) {
            languageLevel = javaSdkVersion.getMaxLanguageLevel();
        }
        this.a(languageLevel, bl2);
    }

    private void a(LanguageLevel languageLevel, boolean bl2) {
        block16: {
            block15: {
                boolean bl3;
                block18: {
                    block17: {
                        try {
                            try {
                                try {
                                    try {
                                        if (languageLevel != null || bl2) break block15;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw LanguageLevelCombo.a(illegalArgumentException);
                                    }
                                    if (!this.a()) break block16;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw LanguageLevelCombo.a(illegalArgumentException);
                                }
                                if (this.getSelectedItem() != this.b) break block17;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw LanguageLevelCombo.a(illegalArgumentException);
                            }
                            bl3 = true;
                            break block18;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw LanguageLevelCombo.a(illegalArgumentException);
                        }
                    }
                    bl3 = false;
                }
                boolean bl4 = bl3;
                try {
                    if (bl4) {
                        this.setSelectedItem(this.getDefaultLevel());
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw LanguageLevelCombo.a(illegalArgumentException);
                }
                this.a = bl4;
                this.removeItem(this.b);
                break block16;
            }
            try {
                try {
                    if (this.a()) break block16;
                    this.addDefaultItem();
                    if (!this.a) break block16;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw LanguageLevelCombo.a(illegalArgumentException);
                }
                this.setSelectedIndex(0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw LanguageLevelCombo.a(illegalArgumentException);
            }
        }
        this.repaint();
    }

    private boolean a() {
        return this.getItemAt(0) instanceof String;
    }

    void addDefaultItem() {
        this.insertItemAt(this.b, 0);
    }

    public LanguageLevel getSelectedLevel() {
        LanguageLevel languageLevel;
        Object object = this.getSelectedItem();
        try {
            languageLevel = object instanceof LanguageLevel ? (LanguageLevel)object : this.getDefaultLevel();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LanguageLevelCombo.a(illegalArgumentException);
        }
        return languageLevel;
    }

    public boolean isDefault() {
        boolean bl2;
        try {
            bl2 = !(this.getSelectedItem() instanceof LanguageLevel);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LanguageLevelCombo.a(illegalArgumentException);
        }
        return bl2;
    }

    public void setSelectedItem(Object object) {
        Object object2;
        LanguageLevelCombo languageLevelCombo;
        try {
            languageLevelCombo = this;
            object2 = object == null ? this.b : object;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LanguageLevelCombo.a(illegalArgumentException);
        }
        super.setSelectedItem(object2);
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/ui/configuration/LanguageLevelCombo", "reset"));
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }
}

