/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.JdkComboBox;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class ModuleJdkConfigurable
implements Disposable {
    private JdkComboBox d;
    private JPanel f;
    private ClasspathEditor b;
    private final ProjectSdksModel e;
    private boolean a = false;
    private final SdkModel.Listener c = new SdkModel.Listener(){

        public void sdkAdded(Sdk sdk) {
            ModuleJdkConfigurable.this.a();
        }

        public void beforeSdkRemove(Sdk sdk) {
            ModuleJdkConfigurable.this.a();
        }

        public void sdkChanged(Sdk sdk, String string) {
            ModuleJdkConfigurable.this.a();
        }

        public void sdkHomeSelected(Sdk sdk, String string) {
            ModuleJdkConfigurable.this.a();
        }
    };

    public ModuleJdkConfigurable(ClasspathEditor classpathEditor, ProjectSdksModel projectSdksModel) {
        this.b = classpathEditor;
        this.e = projectSdksModel;
        this.e.addListener(this.c);
        this.c();
    }

    public JComponent createComponent() {
        return this.f;
    }

    private void a() {
        this.a = true;
        this.d.reloadModel(new JdkComboBox.ProjectJdkComboBoxItem(), this.getRootModel().getModule().getProject());
        this.reset();
        this.a = false;
    }

    protected abstract ModifiableRootModel getRootModel();

    private void c() {
        this.f = new JPanel(new GridBagLayout());
        this.d = new JdkComboBox(this.e);
        this.d.insertItemAt(new JdkComboBox.ProjectJdkComboBoxItem(), 0);
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ModuleJdkConfigurable.this.a) {
                    return;
                }
                Sdk sdk = ModuleJdkConfigurable.this.d.getSelectedJdk();
                ModuleJdkConfigurable.this.b.setSdk(sdk);
                ModuleJdkConfigurable.this.d();
            }
        });
        this.f.add((Component)new JLabel(ProjectBundle.message((String)"module.libraries.target.jdk.module.radio", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, (Insets)JBUI.insetsRight((int)6), 0, 0));
        this.f.add((Component)((Object)this.d), new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 0, (Insets)JBUI.insetsRight((int)4), 0, 0));
        Project project2 = this.getRootModel().getModule().getProject();
        JButton jButton = new JButton(ApplicationBundle.message((String)"button.new", (Object[])new Object[0]));
        this.d.setSetupButton(jButton, project2, this.e, (JdkComboBox.JdkComboBoxItem)new JdkComboBox.ProjectJdkComboBoxItem(), (Condition<Sdk>)((Condition)sdk -> {
            int n2;
            Sdk sdk2 = this.e.getProjectSdk();
            if (sdk2 == null && (n2 = Messages.showYesNoDialog((Component)this.f, (String)ProjectBundle.message((String)"project.roots.no.jdk.on.project.message", (Object[])new Object[0]), (String)ProjectBundle.message((String)"project.roots.no.jdk.on.project.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon())) == 0) {
                this.e.setProjectSdk(sdk);
                return true;
            }
            return false;
        }), true);
        this.f.add((Component)jButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, (Insets)JBUI.insetsRight((int)4), 0, 0));
        JButton jButton2 = new JButton(ApplicationBundle.message((String)"button.edit", (Object[])new Object[0]));
        this.d.setEditButton(jButton2, this.getRootModel().getModule().getProject(), (Computable<Sdk>)((Computable)() -> this.getRootModel().getSdk()));
        this.f.add((Component)jButton2, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        this.f.setBorder(JBUI.Borders.empty((int)6));
    }

    private void d() {
        Module module2 = this.getRootModel().getModule();
        Project project2 = module2.getProject();
        StructureConfigurableContext structureConfigurableContext = ModuleStructureConfigurable.getInstance(project2).getContext();
        structureConfigurableContext.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(structureConfigurableContext, module2));
    }

    public void reset() {
        this.a = true;
        String string = this.getRootModel().getSdkName();
        if (string != null && !this.getRootModel().isSdkInherited()) {
            Sdk sdk = this.e.findSdk(string);
            if (sdk != null) {
                this.d.setSelectedJdk(sdk);
            } else {
                this.d.setInvalidJdk(string);
                this.d();
            }
        } else {
            this.d.setSelectedJdk(null);
        }
        this.a = false;
    }

    public void dispose() {
        this.b = null;
        this.d = null;
        this.f = null;
        this.e.removeListener(this.c);
    }
}

