/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.core.JavaCoreBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.impl.LanguageLevelProjectExtensionImpl;
import com.intellij.openapi.roots.ui.configuration.GeneralProjectSettingsElement;
import com.intellij.openapi.roots.ui.configuration.LanguageLevelCombo;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectJdkConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.project.ProjectKt;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectConfigurable
extends ProjectStructureElementConfigurable<Project>
implements DetailsComponent.Facade {
    private final Project b;
    private LanguageLevelCombo c;
    private ProjectJdkConfigurable k;
    private FieldPanel e;
    private JTextField d;
    private JPanel f;
    private final StructureConfigurableContext a;
    private final ModulesConfigurator j;
    private JPanel g;
    private boolean h = false;
    private DetailsComponent i;
    private final GeneralProjectSettingsElement l;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ProjectConfigurable(Project project2, StructureConfigurableContext structureConfigurableContext, ModulesConfigurator modulesConfigurator, ProjectSdksModel projectSdksModel) {
        this.b = project2;
        this.a = structureConfigurableContext;
        this.j = modulesConfigurator;
        this.c();
        this.l = new GeneralProjectSettingsElement(structureConfigurableContext);
        final ProjectStructureDaemonAnalyzer projectStructureDaemonAnalyzer = structureConfigurableContext.getDaemonAnalyzer();
        this.j.addAllModuleChangeListener(new ModuleEditor.ChangeListener(){

            @Override
            public void moduleStateChanged(ModifiableRootModel modifiableRootModel) {
                projectStructureDaemonAnalyzer.queueUpdate(ProjectConfigurable.this.l);
            }
        });
        this.a(projectSdksModel);
    }

    @Override
    public ProjectStructureElement getProjectStructureElement() {
        return this.l;
    }

    public DetailsComponent getDetailsComponent() {
        return this.i;
    }

    public JComponent createOptionsPanel() {
        this.i = new DetailsComponent(false, false);
        this.i.setContent((JComponent)this.f);
        this.i.setText(new String[]{this.getBannerSlogan()});
        this.k.createComponent();
        return this.i.getComponent();
    }

    private void a(ProjectSdksModel projectSdksModel) {
        this.f = new JPanel(new GridBagLayout());
        this.f.setPreferredSize((Dimension)JBUI.size((int)700, (int)500));
        if (ProjectKt.isDirectoryBased((Project)this.b)) {
            JPanel jPanel = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel("<html><body><b>Project name:</b></body></html>", 2);
            jPanel.add((Component)jLabel, "North");
            this.d = new JTextField();
            this.d.setColumns(40);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(Box.createHorizontalStrut(4));
            jPanel2.add(this.d);
            jPanel.add((Component)jPanel2, "Center");
            JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
            jPanel3.add(jPanel);
            jPanel3.setAlignmentX(0.0f);
            this.f.add((Component)jPanel3, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insets((int)4, (int)0, (int)10, (int)0), 0, 0));
        }
        this.k = new ProjectJdkConfigurable(this.b, projectSdksModel);
        this.f.add((Component)this.k.createComponent(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insetsTop((int)4), 0, 0));
        this.f.add((Component)this.g, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 0, (Insets)JBUI.insetsTop((int)4), 0, 0));
        this.f.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.e.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                if (ProjectConfigurable.this.h) {
                    return;
                }
                ProjectConfigurable.this.j.processModuleCompilerOutputChanged(ProjectConfigurable.this.getCompilerOutputUrl());
            }
        });
        this.k.addChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectConfigurable.this.c.sdkUpdated(ProjectConfigurable.this.k.getSelectedProjectJdk(), ProjectConfigurable.this.b.isDefault());
                LanguageLevelProjectExtensionImpl.getInstanceImpl((Project)ProjectConfigurable.this.b).setCurrentLevel(ProjectConfigurable.this.c.getSelectedLevel());
            }
        });
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LanguageLevelProjectExtensionImpl.getInstanceImpl((Project)ProjectConfigurable.this.b).setCurrentLevel(ProjectConfigurable.this.c.getSelectedLevel());
            }
        });
    }

    public void disposeUIResources() {
        try {
            if (this.k != null) {
                this.k.disposeUIResources();
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectConfigurable.a(illegalStateException);
        }
    }

    public void reset() {
        this.h = true;
        try {
            this.k.reset();
            String string = this.a();
            try {
                if (string != null) {
                    this.e.setText(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)string)));
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw ProjectConfigurable.a(illegalStateException);
            }
            try {
                this.c.reset(this.b);
                if (this.d != null) {
                    this.d.setText(this.b.getName());
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw ProjectConfigurable.a(illegalStateException);
            }
        }
        finally {
            this.h = false;
        }
        this.a.getDaemonAnalyzer().queueUpdate(this.l);
    }

    public void apply() throws ConfigurationException {
        CompilerProjectExtension compilerProjectExtension;
        block9: {
            block8: {
                compilerProjectExtension = CompilerProjectExtension.getInstance((Project)this.b);
                try {
                    try {
                        if ($assertionsDisabled || compilerProjectExtension != null) break block8;
                    }
                    catch (ConfigurationException configurationException) {
                        throw ProjectConfigurable.a((Exception)((Object)configurationException));
                    }
                    throw new AssertionError(this.b);
                }
                catch (ConfigurationException configurationException) {
                    throw ProjectConfigurable.a((Exception)((Object)configurationException));
                }
            }
            try {
                try {
                    if (this.d == null || !StringUtil.isEmptyOrSpaces((String)this.d.getText())) break block9;
                }
                catch (ConfigurationException configurationException) {
                    throw ProjectConfigurable.a((Exception)((Object)configurationException));
                }
                throw new ConfigurationException("Please, specify project name!");
            }
            catch (ConfigurationException configurationException) {
                throw ProjectConfigurable.a((Exception)((Object)configurationException));
            }
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            block12: {
                block13: {
                    block11: {
                        String string = this.e.getText();
                        try {
                            if (string == null || string.length() <= 0) break block11;
                        }
                        catch (IOException iOException) {
                            throw ProjectConfigurable.a(iOException);
                        }
                        try {
                            string = FileUtil.resolveShortWindowsName((String)string);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        string = FileUtil.toSystemIndependentName((String)string);
                        compilerProjectExtension.setCompilerOutputUrl(VfsUtilCore.pathToUrl((String)string));
                        break block13;
                    }
                    compilerProjectExtension.setCompilerOutputPointer(null);
                }
                LanguageLevelProjectExtension languageLevelProjectExtension = LanguageLevelProjectExtension.getInstance((Project)this.b);
                LanguageLevel languageLevel = this.c.getSelectedLevel();
                try {
                    if (languageLevel != null) {
                        languageLevelProjectExtension.setLanguageLevel(languageLevel);
                    }
                }
                catch (IOException iOException) {
                    throw ProjectConfigurable.a(iOException);
                }
                try {
                    try {
                        languageLevelProjectExtension.setDefault(Boolean.valueOf(this.c.isDefault()));
                        this.k.apply();
                        if (this.d == null) break block12;
                        ((ProjectEx)this.b).setProjectName(this.getProjectName());
                        if (this.i == null) break block12;
                    }
                    catch (IOException iOException) {
                        throw ProjectConfigurable.a(iOException);
                    }
                    this.i.setText(new String[]{this.getBannerSlogan()});
                }
                catch (IOException iOException) {
                    throw ProjectConfigurable.a(iOException);
                }
            }
        });
    }

    public void setDisplayName(String string) {
    }

    public Project getEditableObject() {
        return this.b;
    }

    public String getBannerSlogan() {
        return ProjectBundle.message((String)"project.roots.project.banner.text", (Object[])new Object[]{this.b.getName()});
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"project.roots.project.display.name", (Object[])new Object[0]);
    }

    public Icon getIcon(boolean bl2) {
        return AllIcons.Nodes.Project;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settingsdialog.project.structure.general";
    }

    public boolean isModified() {
        block16: {
            LanguageLevelProjectExtension languageLevelProjectExtension = LanguageLevelProjectExtension.getInstance((Project)this.b);
            try {
                block15: {
                    try {
                        try {
                            if (languageLevelProjectExtension.isDefault() != this.c.isDefault()) break block15;
                            if (languageLevelProjectExtension.isDefault()) break block16;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw ProjectConfigurable.a(illegalStateException);
                        }
                        if (languageLevelProjectExtension.getLanguageLevel().equals((Object)this.c.getSelectedLevel())) break block16;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw ProjectConfigurable.a(illegalStateException);
                    }
                }
                return true;
            }
            catch (IllegalStateException illegalStateException) {
                throw ProjectConfigurable.a(illegalStateException);
            }
        }
        String string = this.a();
        try {
            if (!Comparing.strEqual((String)FileUtil.toSystemIndependentName((String)VfsUtilCore.urlToPath((String)string)), (String)FileUtil.toSystemIndependentName((String)this.e.getText()))) {
                return true;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectConfigurable.a(illegalStateException);
        }
        try {
            if (this.k.isModified()) {
                return true;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectConfigurable.a(illegalStateException);
        }
        try {
            if (!this.getProjectName().equals(this.b.getName())) {
                return true;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectConfigurable.a(illegalStateException);
        }
        return false;
    }

    @NotNull
    public String getProjectName() {
        String string;
        String string2;
        try {
            string2 = this.d != null ? this.d.getText().trim() : this.b.getName();
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectConfigurable.a(illegalStateException);
        }
        try {
            string = string2;
            if (string2 == null) {
                ProjectConfigurable.a(0);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectConfigurable.a(illegalStateException);
        }
        return string;
    }

    @Nullable
    private String a() {
        String string;
        CompilerProjectExtension compilerProjectExtension = CompilerProjectExtension.getInstance((Project)this.b);
        try {
            string = compilerProjectExtension != null ? compilerProjectExtension.getCompilerOutputUrl() : null;
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectConfigurable.a(illegalStateException);
        }
        return string;
    }

    private void b() {
        this.c = new LanguageLevelCombo(JavaCoreBundle.message((String)"default.language.level.description", (Object[])new Object[0])){

            @Override
            protected LanguageLevel getDefaultLevel() {
                Sdk sdk = ProjectConfigurable.this.k.getSelectedProjectJdk();
                if (sdk == null) {
                    return null;
                }
                JavaSdkVersion javaSdkVersion = JavaSdk.getInstance().getVersion(sdk);
                return javaSdkVersion == null ? null : javaSdkVersion.getMaxLanguageLevel();
            }
        };
        ExtendableTextField extendableTextField = new ExtendableTextField();
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        InsertPathAction.addTo((JTextComponent)extendableTextField, (FileChooserDescriptor)fileChooserDescriptor);
        fileChooserDescriptor.setHideIgnored(false);
        BrowseFilesListener browseFilesListener = new BrowseFilesListener((JTextField)extendableTextField, "", ProjectBundle.message((String)"project.compiler.output", (Object[])new Object[0]), fileChooserDescriptor);
        this.e = new FieldPanel((JTextField)extendableTextField, null, null, (ActionListener)browseFilesListener, EmptyRunnable.getInstance());
        FileChooserFactory.getInstance().installFileCompletion(this.e.getTextField(), fileChooserDescriptor, true, null);
    }

    public String getCompilerOutputUrl() {
        return VfsUtilCore.pathToUrl((String)this.e.getText().trim());
    }

    static {
        boolean bl2;
        try {
            bl2 = !ProjectConfigurable.class.desiredAssertionStatus();
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectConfigurable.a(illegalStateException);
        }
        $assertionsDisabled = bl2;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/ProjectConfigurable", "getProjectName"));
    }

    private /* synthetic */ void c() {
        JPanel jPanel;
        this.b();
        this.g = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, 5, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.a(jLabel, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.language.level"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        LanguageLevelCombo languageLevelCombo = this.c;
        jPanel2.add((Component)((Object)languageLevelCombo), new GridConstraints(0, 0, 1, 1, 8, 0, 7, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.a(jLabel2, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.compiler.output"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 6, 0, null, null, null));
        FieldPanel fieldPanel = this.e;
        jPanel3.add((Component)fieldPanel, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.g;
    }

    private /* synthetic */ void a(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c2 = '\u0000';
        int n2 = -1;
        int n3 = 0;
        while (true) {
            block13: {
                try {
                    try {
                        try {
                            if (n3 >= string.length()) break;
                            if (string.charAt(n3) != '&') break block13;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw ProjectConfigurable.a(illegalStateException);
                        }
                        if (++n3 == string.length()) {
                            break;
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw ProjectConfigurable.a(illegalStateException);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw ProjectConfigurable.a(illegalStateException);
                }
                try {
                    if (bl2 || string.charAt(n3) == '&') break block13;
                }
                catch (IllegalStateException illegalStateException) {
                    throw ProjectConfigurable.a(illegalStateException);
                }
                bl2 = true;
                c2 = string.charAt(n3);
                n2 = stringBuffer.length();
            }
            stringBuffer.append(string.charAt(n3));
            ++n3;
        }
        try {
            jLabel.setText(stringBuffer.toString());
            if (bl2) {
                jLabel.setDisplayedMnemonic(c2);
                jLabel.setDisplayedMnemonicIndex(n2);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectConfigurable.a(illegalStateException);
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

