/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.dependencyAnalysis;

import com.intellij.icons.AllIcons;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDependenciesAnalyzer {
    private final Module b;
    private final boolean a;
    private final boolean e;
    private final boolean c;
    private final List<OrderEntryExplanation> f = new ArrayList<OrderEntryExplanation>();
    private final List<UrlExplanation> d = new ArrayList<UrlExplanation>();

    public ModuleDependenciesAnalyzer(Module module2, boolean bl2, boolean bl3, boolean bl4) {
        this.b = module2;
        this.a = bl2;
        this.e = bl3;
        this.c = bl4;
        this.a();
    }

    public List<UrlExplanation> getUrls() {
        return Collections.unmodifiableList(this.d);
    }

    public List<OrderEntryExplanation> getOrderEntries() {
        return Collections.unmodifiableList(this.f);
    }

    private void a() {
        OrderEnumerator orderEnumerator = ModuleRootManager.getInstance((Module)this.b).orderEntries();
        orderEnumerator.recursively();
        if (!this.c) {
            orderEnumerator.withoutSdk();
        }
        if (this.e) {
            orderEnumerator.compileOnly();
        } else {
            orderEnumerator.runtimeOnly();
        }
        if (this.a) {
            orderEnumerator.productionOnly();
        }
        LinkedHashMap<String, List<OrderPath>> linkedHashMap = new LinkedHashMap<String, List<OrderPath>>();
        OrderRootsEnumerator orderRootsEnumerator = orderEnumerator.classes();
        if (this.e) {
            orderRootsEnumerator.withoutSelfModuleOutput();
        }
        for (String string : orderRootsEnumerator.getUrls()) {
            if (linkedHashMap.containsKey(string)) continue;
            linkedHashMap.put(string, new ArrayList());
        }
        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        new PathWalker(linkedHashMap, linkedHashMap2).examine(this.b, 0);
        for (Map.Entry entry : linkedHashMap2.entrySet()) {
            this.f.add(new OrderEntryExplanation((OrderEntry)entry.getKey(), (List)entry.getValue()));
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            this.d.add(new UrlExplanation((String)entry.getKey(), (List)entry.getValue()));
        }
    }

    public static class UrlExplanation
    extends Explanation {
        private final String a;

        UrlExplanation(String string, List<OrderPath> list) {
            super(list);
            this.a = string;
        }

        public String url() {
            return this.a;
        }

        @Nullable
        public Icon getIcon() {
            VirtualFile virtualFile = this.getLocalFile();
            return virtualFile == null ? AllIcons.General.Error : VirtualFilePresentation.getIcon((VirtualFile)virtualFile);
        }

        @Nullable
        public VirtualFile getLocalFile() {
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(this.a);
            if (virtualFile != null) {
                virtualFile = VfsUtil.getLocalFile((VirtualFile)virtualFile);
            }
            return virtualFile;
        }
    }

    public static class OrderEntryExplanation
    extends Explanation {
        private final OrderEntry a;

        OrderEntryExplanation(OrderEntry orderEntry, List<OrderPath> list) {
            super(list);
            this.a = orderEntry;
        }

        public OrderEntry entry() {
            return this.a;
        }
    }

    public static class Explanation {
        public final List<OrderPath> myPaths;

        Explanation(List<OrderPath> list) {
            this.myPaths = Collections.unmodifiableList(list);
        }

        public List<OrderPath> paths() {
            return this.myPaths;
        }
    }

    public static class OrderEntryPathElement
    extends OrderPathElement {
        private final OrderEntry a;

        public OrderEntryPathElement(OrderEntry orderEntry) {
            this.a = orderEntry;
        }

        public OrderEntry entry() {
            return this.a;
        }

        public int hashCode() {
            return this.a.hashCode();
        }

        public boolean equals(Object object) {
            boolean bl2;
            try {
                if (!(object instanceof OrderEntryPathElement)) {
                    return false;
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw OrderEntryPathElement.b(illegalStateException);
            }
            OrderEntryPathElement orderEntryPathElement = (OrderEntryPathElement)object;
            try {
                bl2 = orderEntryPathElement.a == this.a;
            }
            catch (IllegalStateException illegalStateException) {
                throw OrderEntryPathElement.b(illegalStateException);
            }
            return bl2;
        }

        public String toString() {
            return this.a.getPresentableName();
        }

        @Override
        @NotNull
        public CellAppearanceEx getAppearance(boolean bl2) {
            CellAppearanceEx cellAppearanceEx;
            try {
                cellAppearanceEx = OrderEntryAppearanceService.getInstance().forOrderEntry(this.a.getOwnerModule().getProject(), this.a, bl2);
                if (cellAppearanceEx == null) {
                    OrderEntryPathElement.a(0);
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw OrderEntryPathElement.b(illegalStateException);
            }
            return cellAppearanceEx;
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/dependencyAnalysis/ModuleDependenciesAnalyzer$OrderEntryPathElement", "getAppearance"));
        }

        private static IllegalStateException b(IllegalStateException illegalStateException) {
            return illegalStateException;
        }
    }

    public static abstract class OrderPathElement {
        @NotNull
        public abstract CellAppearanceEx getAppearance(boolean var1);
    }

    public static class OrderPath {
        private final List<OrderPathElement> a;

        public OrderPath(List<OrderPathElement> list) {
            this.a = Collections.unmodifiableList(new ArrayList<OrderPathElement>(list));
        }

        public List<OrderPathElement> entries() {
            return this.a;
        }

        public int hashCode() {
            return this.a.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof OrderPath)) {
                return false;
            }
            return this.a.equals(((OrderPath)object).a);
        }
    }

    private class PathWalker {
        private final Map<String, List<OrderPath>> b;
        private final Map<OrderEntry, List<OrderPath>> a;
        private final ArrayList<OrderPathElement> c = new ArrayList();
        private final HashSet<Module> d = new HashSet();

        public PathWalker(Map<String, List<OrderPath>> map, Map<OrderEntry, List<OrderPath>> map2) {
            this.b = map;
            this.a = map2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void examine(Module module2, int n2) {
            if (this.d.contains(module2)) {
                return;
            }
            this.d.add(module2);
            try {
                OrderEnumerator orderEnumerator = ModuleRootManager.getInstance((Module)module2).orderEntries();
                if (!ModuleDependenciesAnalyzer.this.c || n2 != 0) {
                    orderEnumerator.withoutSdk();
                }
                if (ModuleDependenciesAnalyzer.this.e && n2 != 0) {
                    orderEnumerator.exportedOnly();
                }
                if (ModuleDependenciesAnalyzer.this.a) {
                    orderEnumerator.productionOnly();
                }
                if (ModuleDependenciesAnalyzer.this.e) {
                    orderEnumerator.compileOnly();
                } else {
                    orderEnumerator.runtimeOnly();
                }
                orderEnumerator.forEach(orderEntry -> {
                    this.c.add(new OrderEntryPathElement((OrderEntry)orderEntry));
                    try {
                        if (orderEntry instanceof ModuleOrderEntry) {
                            ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)orderEntry;
                            this.examine(moduleOrderEntry.getModule(), n2 + 1);
                        } else if (orderEntry instanceof ModuleSourceOrderEntry) {
                            if (!ModuleDependenciesAnalyzer.this.a || !ModuleDependenciesAnalyzer.this.e) {
                                CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module2);
                                OrderPath orderPath = new OrderPath(this.c);
                                for (String string : compilerModuleExtension.getOutputRootUrls(!ModuleDependenciesAnalyzer.this.e ? !ModuleDependenciesAnalyzer.this.a : n2 > 0 && !ModuleDependenciesAnalyzer.this.a)) {
                                    this.a(orderPath, string);
                                }
                                this.a((OrderEntry)orderEntry, orderPath);
                            }
                        } else {
                            OrderPath orderPath = new OrderPath(this.c);
                            for (String string : orderEntry.getUrls(OrderRootType.CLASSES)) {
                                this.a(orderPath, string);
                            }
                            this.a((OrderEntry)orderEntry, orderPath);
                        }
                    }
                    finally {
                        this.c.remove(this.c.size() - 1);
                    }
                    return true;
                });
            }
            finally {
                this.d.remove(module2);
            }
        }

        private void a(OrderPath orderPath, String string) {
            List<OrderPath> list = this.b.get(string);
            if (list != null) {
                list.add(orderPath);
            }
        }

        private void a(OrderEntry orderEntry, OrderPath orderPath) {
            List<OrderPath> list = this.a.get(orderEntry);
            if (list == null) {
                list = new ArrayList<OrderPath>();
                this.a.put(orderEntry, list);
            }
            list.add(orderPath);
        }
    }
}

