/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.find.FindBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.ui.ListCellRendererWithRightAlignedComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FindUsagesInProjectStructureActionBase
extends AnAction
implements DumbAware {
    private final JComponent a;
    private final Project b;

    public FindUsagesInProjectStructureActionBase(JComponent jComponent, Project project2) {
        super(ProjectBundle.message((String)"find.usages.action.text", (Object[])new Object[0]), ProjectBundle.message((String)"find.usages.action.text", (Object[])new Object[0]), AllIcons.Actions.Find);
        this.registerCustomShortcutSet(ActionManager.getInstance().getAction("FindUsages").getShortcutSet(), jComponent);
        this.a = jComponent;
        this.b = project2;
    }

    public void update(AnActionEvent anActionEvent) {
        anActionEvent.getPresentation().setEnabled(this.isEnabled());
    }

    protected abstract boolean isEnabled();

    public void actionPerformed(AnActionEvent anActionEvent) {
        ProjectStructureElement projectStructureElement = this.getSelectedElement();
        if (projectStructureElement == null) {
            return;
        }
        Collection<ProjectStructureElementUsage> collection = this.getContext().getDaemonAnalyzer().getUsages(projectStructureElement);
        if (collection.isEmpty()) {
            Messages.showInfoMessage((Component)this.a, (String)FindBundle.message((String)"find.usage.view.no.usages.text", (Object[])new Object[0]), (String)FindBundle.message((String)"find.pointcut.applications.not.found.title", (Object[])new Object[0]));
            return;
        }
        RelativePoint relativePoint = this.getPointToShowResults();
        ProjectStructureElementUsage[] projectStructureElementUsageArray = collection.toArray(new ProjectStructureElementUsage[collection.size()]);
        Arrays.sort(projectStructureElementUsageArray, (projectStructureElementUsage, projectStructureElementUsage2) -> projectStructureElementUsage.getPresentableName().compareToIgnoreCase(projectStructureElementUsage2.getPresentableName()));
        BaseListPopupStep<ProjectStructureElementUsage> baseListPopupStep = new BaseListPopupStep<ProjectStructureElementUsage>(ProjectBundle.message((String)"dependencies.used.in.popup.title", (Object[])new Object[0]), projectStructureElementUsageArray){

            public PopupStep onChosen(ProjectStructureElementUsage projectStructureElementUsage, boolean bl2) {
                PlaceInProjectStructure placeInProjectStructure = projectStructureElementUsage.getPlace();
                try {
                    if (placeInProjectStructure.canNavigate()) {
                        placeInProjectStructure.navigate();
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw 1.b(illegalStateException);
                }
                return FINAL_CHOICE;
            }

            public boolean isSelectable(ProjectStructureElementUsage projectStructureElementUsage) {
                return true;
            }

            @NotNull
            public String getTextFor(ProjectStructureElementUsage projectStructureElementUsage) {
                String string;
                try {
                    string = projectStructureElementUsage.getPresentableName();
                    if (string == null) {
                        1.a(0);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw 1.b(illegalStateException);
                }
                return string;
            }

            public Icon getIconFor(ProjectStructureElementUsage projectStructureElementUsage) {
                return projectStructureElementUsage.getIcon();
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/FindUsagesInProjectStructureActionBase$1", "getTextFor"));
            }

            private static IllegalStateException b(IllegalStateException illegalStateException) {
                return illegalStateException;
            }
        };
        new ListPopupImpl((ListPopupStep)baseListPopupStep){

            protected ListCellRenderer getListElementRenderer() {
                return new ListCellRendererWithRightAlignedComponent<ProjectStructureElementUsage>(){

                    protected void customize(ProjectStructureElementUsage projectStructureElementUsage) {
                        this.setLeftText(projectStructureElementUsage.getPresentableName());
                        this.setIcon(projectStructureElementUsage.getIcon());
                        this.setLeftForeground(projectStructureElementUsage.getPlace().canNavigate() ? UIUtil.getLabelTextForeground() : UIUtil.getLabelDisabledForeground());
                        this.setRightForeground(Color.GRAY);
                        this.setRightText(projectStructureElementUsage.getPresentableLocationInElement());
                    }
                };
            }
        }.show(relativePoint);
    }

    @Nullable
    protected abstract ProjectStructureElement getSelectedElement();

    protected StructureConfigurableContext getContext() {
        return ModuleStructureConfigurable.getInstance(this.b).getContext();
    }

    protected abstract RelativePoint getPointToShowResults();
}

