/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsComponent;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureLibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryConfigurable
extends ProjectStructureElementConfigurable<Library> {
    private LibraryRootsComponent a;
    private final Library c;
    private final StructureLibraryTableModifiableModelProvider h;
    private final StructureConfigurableContext b;
    private final Project e;
    private final LibraryProjectStructureElement f;
    private boolean d;
    private boolean g;

    protected LibraryConfigurable(StructureLibraryTableModifiableModelProvider structureLibraryTableModifiableModelProvider, Library library, StructureConfigurableContext structureConfigurableContext, Runnable runnable) {
        super(true, runnable);
        this.h = structureLibraryTableModifiableModelProvider;
        this.b = structureConfigurableContext;
        this.e = structureConfigurableContext.getProject();
        this.c = library;
        this.f = new LibraryProjectStructureElement(structureConfigurableContext, this.c);
    }

    public JComponent createOptionsPanel() {
        this.a = new LibraryRootsComponent(this.e, (Computable<LibraryEditor>)((Computable)() -> this.getLibraryEditor()));
        this.a.addListener(() -> {
            this.b.getDaemonAnalyzer().queueUpdate(this.f);
            this.updateName();
        });
        return this.a.getComponent();
    }

    public boolean isModified() {
        boolean bl2;
        block5: {
            block4: {
                try {
                    try {
                        if (this.a == null || !this.a.hasChanges()) break block4;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw LibraryConfigurable.b(illegalStateException);
                    }
                    bl2 = true;
                    break block5;
                }
                catch (IllegalStateException illegalStateException) {
                    throw LibraryConfigurable.b(illegalStateException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    @Override
    @NotNull
    public ProjectStructureElement getProjectStructureElement() {
        LibraryProjectStructureElement libraryProjectStructureElement;
        try {
            libraryProjectStructureElement = this.f;
            if (libraryProjectStructureElement == null) {
                LibraryConfigurable.a(0);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw LibraryConfigurable.b(illegalStateException);
        }
        return libraryProjectStructureElement;
    }

    public void apply() {
        this.d();
    }

    public void reset() {
        this.a();
    }

    public void disposeUIResources() {
        try {
            if (this.a != null) {
                Disposer.dispose((Disposable)this.a);
                this.a = null;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw LibraryConfigurable.b(illegalStateException);
        }
    }

    public void setDisplayName(String string) {
        block4: {
            block5: {
                try {
                    try {
                        if (this.d) break block4;
                        this.getLibraryEditor().setName(string);
                        if (this.a == null) break block5;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw LibraryConfigurable.b(illegalStateException);
                    }
                    this.a.onLibraryRenamed();
                }
                catch (IllegalStateException illegalStateException) {
                    throw LibraryConfigurable.b(illegalStateException);
                }
            }
            this.b.getDaemonAnalyzer().queueUpdateForAllElementsWithErrors();
        }
    }

    protected LibraryEditor getLibraryEditor() {
        return this.h.getModifiableModel().getLibraryEditor(this.c);
    }

    public void updateName() {
        this.d = true;
        try {
            super.updateName();
        }
        finally {
            this.d = false;
        }
    }

    public Library getEditableObject() {
        return this.c;
    }

    public String getBannerSlogan() {
        String string;
        LibraryTable libraryTable = this.c.getTable();
        try {
            string = libraryTable == null ? ProjectBundle.message((String)"module.library.display.name", (Object[])new Object[]{1}) : libraryTable.getPresentation().getDisplayName(false);
        }
        catch (IllegalStateException illegalStateException) {
            throw LibraryConfigurable.b(illegalStateException);
        }
        String string2 = string;
        return ProjectBundle.message((String)"project.roots.library.banner.text", (Object[])new Object[]{this.getDisplayName(), string2});
    }

    public String getDisplayName() {
        try {
            if (this.h.getModifiableModel().hasLibraryEditor(this.c)) {
                return this.getLibraryEditor().getName();
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw LibraryConfigurable.b(illegalStateException);
        }
        return this.c.getName();
    }

    public void onSelected() {
        this.a();
    }

    public void onUnselected() {
        this.d();
    }

    private void a() {
        try {
            if (this.a != null) {
                this.a.updatePropertiesLabel();
                this.a.resetProperties();
                this.g = true;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw LibraryConfigurable.b(illegalStateException);
        }
    }

    private void d() {
        block4: {
            try {
                try {
                    if (this.a == null || !this.g) break block4;
                }
                catch (IllegalStateException illegalStateException) {
                    throw LibraryConfigurable.b(illegalStateException);
                }
                this.a.applyProperties();
                this.g = false;
            }
            catch (IllegalStateException illegalStateException) {
                throw LibraryConfigurable.b(illegalStateException);
            }
        }
    }

    public Icon getIcon(boolean bl2) {
        return LibraryPresentationManager.getInstance().getNamedLibraryIcon(this.c, this.b);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "preferences.jdkGlobalLibs";
    }

    public void updateComponent() {
        try {
            if (this.a != null) {
                this.a.updateRootsTree();
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw LibraryConfigurable.b(illegalStateException);
        }
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibraryConfigurable", "getProjectStructureElement"));
    }

    private static IllegalStateException b(IllegalStateException illegalStateException) {
        return illegalStateException;
    }
}

