/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibraryConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ConfigurationErrorQuickFix;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructureBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

/*
 * Exception performing whole class analysis ignored.
 */
public class LibraryProjectStructureElement
extends ProjectStructureElement {
    private final Library a;

    public LibraryProjectStructureElement(@NotNull StructureConfigurableContext structureConfigurableContext, @NotNull Library library) {
        if (structureConfigurableContext == null) {
            LibraryProjectStructureElement.b(0);
        }
        if (library == null) {
            LibraryProjectStructureElement.b(1);
        }
        super(structureConfigurableContext);
        this.a = library;
    }

    public Library getLibrary() {
        return this.a;
    }

    @Override
    public void check(ProjectStructureProblemsHolder projectStructureProblemsHolder) {
        block12: {
            LibraryEx libraryEx;
            block11: {
                try {
                    if (((LibraryEx)this.a).isDisposed()) {
                        return;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw LibraryProjectStructureElement.a(illegalArgumentException);
                }
                libraryEx = (LibraryEx)this.myContext.getLibraryModel(this.a);
                try {
                    try {
                        if (libraryEx != null && !libraryEx.isDisposed()) break block11;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw LibraryProjectStructureElement.a(illegalArgumentException);
                    }
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw LibraryProjectStructureElement.a(illegalArgumentException);
                }
            }
            this.a(projectStructureProblemsHolder, libraryEx, OrderRootType.CLASSES, "classes", ProjectStructureProblemType.error("library-invalid-classes-path"));
            String string = libraryEx.getName();
            try {
                try {
                    if (string != null && string.startsWith("Maven: ")) break block12;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw LibraryProjectStructureElement.a(illegalArgumentException);
                }
                this.a(projectStructureProblemsHolder, libraryEx, OrderRootType.SOURCES, "sources", ProjectStructureProblemType.warning("library-invalid-source-javadoc-path"));
                this.a(projectStructureProblemsHolder, libraryEx, JavadocOrderRootType.getInstance(), "javadoc", ProjectStructureProblemType.warning("library-invalid-source-javadoc-path"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw LibraryProjectStructureElement.a(illegalArgumentException);
            }
        }
    }

    private void a(ProjectStructureProblemsHolder projectStructureProblemsHolder, LibraryEx libraryEx, @NotNull OrderRootType orderRootType, String string, ProjectStructureProblemType projectStructureProblemType) {
        try {
            if (orderRootType == null) {
                LibraryProjectStructureElement.b(2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LibraryProjectStructureElement.a(illegalArgumentException);
        }
        List list = libraryEx.getInvalidRootUrls(orderRootType);
        if (!list.isEmpty()) {
            ProjectStructureProblemDescription.ProblemLevel problemLevel;
            String string2 = LibraryProjectStructureElement.a(list, string, libraryEx.getName());
            PlaceInProjectStructure placeInProjectStructure = this.b();
            String string3 = ProjectBundle.message((String)"project.roots.error.message.invalid.roots", (Object[])new Object[]{string, list.size()});
            try {
                problemLevel = libraryEx.getTable().getTableLevel().equals("project") ? ProjectStructureProblemDescription.ProblemLevel.PROJECT : ProjectStructureProblemDescription.ProblemLevel.GLOBAL;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw LibraryProjectStructureElement.a(illegalArgumentException);
            }
            ProjectStructureProblemDescription.ProblemLevel problemLevel2 = problemLevel;
            projectStructureProblemsHolder.registerProblem(new ProjectStructureProblemDescription(string3, string2, placeInProjectStructure, projectStructureProblemType, problemLevel2, Collections.singletonList(new RemoveInvalidRootsQuickFix((Library)libraryEx, orderRootType, list)), true));
        }
    }

    private static String a(List<String> list, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = StringUtil.escapeXml((String)string2);
        stringBuilder.append("Library ");
        stringBuilder.append("<a href='http://library/").append(string3).append("'>").append(string3).append("</a>");
        stringBuilder.append(" has broken " + string + " " + StringUtil.pluralize((String)"path", (int)list.size()) + ":");
        for (String string4 : list) {
            stringBuilder.append("<br>&nbsp;&nbsp;");
            stringBuilder.append(PathUtil.toPresentableUrl((String)string4));
        }
        return XmlStringUtil.wrapInHtml((CharSequence)stringBuilder);
    }

    @NotNull
    private PlaceInProjectStructure b() {
        PlaceInProjectStructureBase placeInProjectStructureBase;
        Project project2 = this.myContext.getProject();
        try {
            placeInProjectStructureBase = new PlaceInProjectStructureBase(project2, ProjectStructureConfigurable.getInstance(project2).createProjectOrGlobalLibraryPlace(this.a), this);
            if (placeInProjectStructureBase == null) {
                LibraryProjectStructureElement.b(3);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LibraryProjectStructureElement.a(illegalArgumentException);
        }
        return placeInProjectStructureBase;
    }

    @Override
    public List<ProjectStructureElementUsage> getUsagesInElement() {
        return Collections.emptyList();
    }

    @Override
    public boolean equals(Object object) {
        boolean bl2;
        try {
            if (this == object) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LibraryProjectStructureElement.a(illegalArgumentException);
        }
        try {
            if (!(object instanceof LibraryProjectStructureElement)) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LibraryProjectStructureElement.a(illegalArgumentException);
        }
        try {
            bl2 = this.a() == ((LibraryProjectStructureElement)object).a();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LibraryProjectStructureElement.a(illegalArgumentException);
        }
        return bl2;
    }

    public ActionCallback navigate() {
        return this.b().navigate();
    }

    @NotNull
    private Library a() {
        Library library;
        Library library2;
        Library library3;
        Library library4;
        InvocationHandler invocationHandler;
        try {
            invocationHandler = Proxy.isProxyClass(this.a.getClass()) ? Proxy.getInvocationHandler(this.a) : null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LibraryProjectStructureElement.a(illegalArgumentException);
        }
        InvocationHandler invocationHandler2 = invocationHandler;
        try {
            library4 = invocationHandler2 instanceof ModuleEditor.ProxyDelegateAccessor ? (Library)((ModuleEditor.ProxyDelegateAccessor)((Object)invocationHandler2)).getDelegate() : this.a;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LibraryProjectStructureElement.a(illegalArgumentException);
        }
        Library library5 = library4;
        try {
            library3 = library5 instanceof LibraryImpl ? ((LibraryImpl)library5).getSource() : null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LibraryProjectStructureElement.a(illegalArgumentException);
        }
        Library library6 = library3;
        try {
            library2 = library6 != null ? library6 : this.a;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LibraryProjectStructureElement.a(illegalArgumentException);
        }
        try {
            library = library2;
            if (library2 == null) {
                LibraryProjectStructureElement.b(4);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LibraryProjectStructureElement.a(illegalArgumentException);
        }
        return library;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this.a());
    }

    @Override
    public boolean shouldShowWarningIfUnused() {
        LibraryTable libraryTable = this.a.getTable();
        try {
            if (libraryTable == null) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LibraryProjectStructureElement.a(illegalArgumentException);
        }
        return "project".equals(libraryTable.getTableLevel());
    }

    @Override
    public ProjectStructureProblemDescription createUnusedElementWarning() {
        List<ConfigurationErrorQuickFix> list = Arrays.asList(new AddLibraryToDependenciesFix(), new RemoveLibraryFix(), new RemoveAllUnusedLibrariesFix());
        String string = StringUtil.escapeXml((String)this.a.getName());
        String string2 = "<a href='http://library/" + string + "'>" + string + "</a>";
        return new ProjectStructureProblemDescription(XmlStringUtil.wrapInHtml((CharSequence)("Library " + string2 + " is not used")), null, this.b(), ProjectStructureProblemType.unused("unused-library"), ProjectStructureProblemDescription.ProblemLevel.PROJECT, list, false);
    }

    @Override
    public String getPresentableName() {
        return this.a.getName();
    }

    @Override
    public String getTypeName() {
        return "Library";
    }

    @Override
    public String getId() {
        return "library:" + this.a.getTable().getTableLevel() + ":" + this.a.getName();
    }

    /*
     * Exception decompiling
     */
    private static /* synthetic */ void b(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private class RemoveAllUnusedLibrariesFix
    extends ConfigurationErrorQuickFix {
        private RemoveAllUnusedLibrariesFix() {
            super("Remove All Unused Libraries");
        }

        @Override
        public void performFix() {
            BaseLibrariesConfigurable baseLibrariesConfigurable = BaseLibrariesConfigurable.getInstance(LibraryProjectStructureElement.this.myContext.getProject(), "project");
            Library[] libraryArray = baseLibrariesConfigurable.getModelProvider().getModifiableModel().getLibraries();
            ArrayList<LibraryProjectStructureElement> arrayList = new ArrayList<LibraryProjectStructureElement>();
            for (Library library : libraryArray) {
                LibraryProjectStructureElement libraryProjectStructureElement = new LibraryProjectStructureElement(LibraryProjectStructureElement.this.myContext, library);
                if (!LibraryProjectStructureElement.this.myContext.getDaemonAnalyzer().getUsages(libraryProjectStructureElement).isEmpty()) continue;
                arrayList.add(libraryProjectStructureElement);
            }
            baseLibrariesConfigurable.removeLibraries(arrayList);
        }
    }

    private class RemoveLibraryFix
    extends ConfigurationErrorQuickFix {
        private RemoveLibraryFix() {
            super("Remove Library");
        }

        @Override
        public void performFix() {
            BaseLibrariesConfigurable.getInstance(LibraryProjectStructureElement.this.myContext.getProject(), LibraryProjectStructureElement.this.a.getTable().getTableLevel()).removeLibrary(LibraryProjectStructureElement.this);
        }
    }

    private class AddLibraryToDependenciesFix
    extends ConfigurationErrorQuickFix {
        private AddLibraryToDependenciesFix() {
            super("Add to Dependencies...");
        }

        @Override
        public void performFix() {
            LibraryEditingUtil.showDialogAndAddLibraryToDependencies(LibraryProjectStructureElement.this.a, LibraryProjectStructureElement.this.myContext.getProject(), false);
        }
    }

    private class RemoveInvalidRootsQuickFix
    extends ConfigurationErrorQuickFix {
        private final Library d;
        private final OrderRootType b;
        private final List<String> c;

        public RemoveInvalidRootsQuickFix(Library library, OrderRootType orderRootType, List<String> list) {
            super("Remove invalid " + StringUtil.pluralize((String)"root", (int)list.size()));
            this.d = library;
            this.b = orderRootType;
            this.c = list;
        }

        @Override
        public void performFix() {
            LibraryTable.ModifiableModel modifiableModel = LibraryProjectStructureElement.this.myContext.getModifiableLibraryTable(this.d.getTable());
            if (modifiableModel instanceof LibrariesModifiableModel) {
                for (String string : this.c) {
                    ExistingLibraryEditor existingLibraryEditor = ((LibrariesModifiableModel)modifiableModel).getLibraryEditor(this.d);
                    existingLibraryEditor.removeRoot(string, this.b);
                }
                LibraryProjectStructureElement.this.myContext.getDaemonAnalyzer().queueUpdate(LibraryProjectStructureElement.this);
                Object object = ProjectStructureConfigurable.getInstance(LibraryProjectStructureElement.this.myContext.getProject());
                LibraryProjectStructureElement.this.navigate().doWhenDone(() -> {
                    NamedConfigurable namedConfigurable = object.getConfigurableFor(this.d).getSelectedConfigurable();
                    if (namedConfigurable instanceof LibraryConfigurable) {
                        ((LibraryConfigurable)namedConfigurable).updateComponent();
                    }
                });
            }
        }
    }
}

