/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.checkout.CheckoutListener;
import com.intellij.openapi.vcs.checkout.ProjectCheckoutListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportProvider;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewProjectCheckoutListener
implements CheckoutListener {
    private static final Logger a = Logger.getInstance(NewProjectCheckoutListener.class);

    public boolean processCheckedOutDirectory(Project project2, File file) {
        boolean bl2;
        Logger logger;
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        try {
            logger = a;
            bl2 = virtualFile != null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw NewProjectCheckoutListener.a(illegalArgumentException);
        }
        logger.assertTrue(bl2, (Object)("Can't find " + file));
        int n2 = Messages.showYesNoDialog((Project)project2, (String)VcsBundle.message((String)"checkout.create.project.prompt", (Object[])new Object[]{ProjectCheckoutListener.getProductNameWithArticle(), file.getAbsolutePath()}), (String)VcsBundle.message((String)"checkout.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        if (n2 == 0) {
            AddModuleWizard addModuleWizard = this.createImportWizard(virtualFile);
            try {
                if (addModuleWizard == null) {
                    return false;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw NewProjectCheckoutListener.a(illegalArgumentException);
            }
            try {
                if (addModuleWizard.showAndGet()) {
                    ImportModuleAction.createFromWizard(null, addModuleWizard);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw NewProjectCheckoutListener.a(illegalArgumentException);
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected AddModuleWizard createImportWizard(@NotNull VirtualFile virtualFile) {
        try {
            if (virtualFile == null) {
                NewProjectCheckoutListener.a(0);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw NewProjectCheckoutListener.a(illegalArgumentException);
        }
        return ImportModuleAction.createImportWizard(null, null, virtualFile, (ProjectImportProvider[])ProjectImportProvider.PROJECT_IMPORT_PROVIDER.getExtensions());
    }

    public void processOpenedProject(Project project2) {
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/checkout/NewProjectCheckoutListener", "createImportWizard"));
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }
}

