/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.checkout.CheckoutListener;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.Icon;
import org.apache.oro.io.GlobFilenameFilter;

public class ProjectCheckoutListener
implements CheckoutListener {
    public boolean processCheckedOutDirectory(Project project2, File file) {
        File[] fileArray = file.listFiles((FilenameFilter)new GlobFilenameFilter("*.ipr"));
        if (fileArray != null && fileArray.length > 0) {
            String string = VcsBundle.message((String)"checkout.open.project.prompt", (Object[])new Object[]{ProjectCheckoutListener.getProductNameWithArticle(), fileArray[0].getPath()});
            if (Messages.showYesNoDialog((Project)project2, (String)string, (String)VcsBundle.message((String)"checkout.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                ProjectUtil.openProject((String)fileArray[0].getPath(), (Project)project2, (boolean)false);
            }
            return true;
        }
        return false;
    }

    public void processOpenedProject(Project project2) {
    }

    static String getProductNameWithArticle() {
        String string = ApplicationNamesInfo.getInstance().getFullProductName();
        String string2 = StringUtil.isVowel((char)Character.toLowerCase(string.charAt(0))) ? "an " : "a ";
        return string2 + string;
    }
}

