/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.checkout.CheckoutListener;
import com.intellij.openapi.vcs.checkout.ProjectCheckoutListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import java.io.File;
import javax.swing.Icon;

public class ProjectImporterCheckoutListener
implements CheckoutListener {
    public boolean processCheckedOutDirectory(Project project2, File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            for (File file2 : fileArray) {
                ProjectOpenProcessor projectOpenProcessor;
                VirtualFile virtualFile;
                if (file2.isDirectory() || (virtualFile = localFileSystem.findFileByIoFile(file2)) == null || (projectOpenProcessor = ProjectOpenProcessor.getImportProvider((VirtualFile)virtualFile)) == null) continue;
                int n2 = Messages.showYesNoDialog((Project)project2, (String)VcsBundle.message((String)"checkout.open.project.prompt", (Object[])new Object[]{ProjectCheckoutListener.getProductNameWithArticle(), file2.getPath()}), (String)VcsBundle.message((String)"checkout.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                if (n2 == 0) {
                    projectOpenProcessor.doOpenProject(virtualFile, project2, false);
                }
                return true;
            }
        }
        return false;
    }

    public void processOpenedProject(Project project2) {
    }
}

