/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.module;

import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.newProjectWizard.modes.CreateFromSourcesMode;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.impl.module.CloudModuleBuilder;
import com.intellij.remoteServer.impl.module.CloudModuleBuilderContribution;
import com.intellij.remoteServer.impl.module.CloudSourceApplicationConfigurable;
import com.intellij.remoteServer.impl.module.CloudSourceApplicationConfiguration;
import com.intellij.remoteServer.util.CloudAccountSelectionEditor;
import com.intellij.remoteServer.util.CloudBundle;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.remoteServer.util.CloudConnectionTask;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.CloudNotifier;
import com.intellij.remoteServer.util.CloudRunConfigurationUtil;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.remoteServer.util.ssh.SshKeyChecker;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CloudModuleBuilderSourceContribution<SC extends CloudConfigurationBase, DC extends CloudDeploymentNameConfiguration, AC extends CloudSourceApplicationConfiguration, SR extends CloudMultiSourceServerRuntimeInstance<DC, ?, ?, ?>>
extends CloudModuleBuilderContribution {
    private CloudNotifier d;

    public CloudModuleBuilderSourceContribution(CloudModuleBuilder cloudModuleBuilder, ServerType<SC> serverType) {
        super(cloudModuleBuilder, serverType);
    }

    @Override
    public void configureModule(final Module module2) {
        final CloudModuleBuilder cloudModuleBuilder = this.getModuleBuilder();
        RemoteServer<?> remoteServer = cloudModuleBuilder.getAccount();
        final CloudSourceApplicationConfiguration cloudSourceApplicationConfiguration = (CloudSourceApplicationConfiguration)cloudModuleBuilder.getApplicationConfiguration();
        DC DC = this.createDeploymentConfiguration();
        if (cloudSourceApplicationConfiguration.isExisting()) {
            DC.setDefaultDeploymentName(false);
            DC.setDeploymentName(cloudSourceApplicationConfiguration.getExistingAppName());
        }
        final DeployToServerRunConfiguration deployToServerRunConfiguration = CloudRunConfigurationUtil.createRunConfiguration(remoteServer, (Module)module2, DC);
        ServerType serverType = remoteServer.getType();
        final Project project2 = module2.getProject();
        new CloudConnectionTask<Object, SC, DC, SR>(project2, CloudBundle.getText((String)"cloud.support", (Object[])new Object[]{serverType.getPresentableName()}), remoteServer){
            boolean myFirstAttempt;
            {
                super(project22, string, remoteServer);
                this.myFirstAttempt = true;
            }

            protected Object run(SR SR) throws ServerRuntimeException {
                CloudModuleBuilderSourceContribution.this.doConfigureModule(cloudSourceApplicationConfiguration, deployToServerRunConfiguration, this.myFirstAttempt, SR);
                return null;
            }

            protected void runtimeErrorOccurred(@NotNull String string) {
                try {
                    if (string == null) {
                        1.a(0);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 1.a(illegalArgumentException);
                }
                this.myFirstAttempt = false;
                new SshKeyChecker().checkServerError(string, CloudModuleBuilderSourceContribution.this.a(), project2, (CloudConnectionTask)this);
            }

            protected void postPerform(Object object) {
                CloudModuleBuilderSourceContribution.this.a(module2, cloudModuleBuilder.getContentEntryPath());
            }

            protected boolean shouldStartInBackground() {
                return false;
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/impl/module/CloudModuleBuilderSourceContribution$1", "runtimeErrorOccurred"));
            }

            private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
                return illegalArgumentException;
            }
        }.performAsync();
    }

    private CloudNotifier a() {
        if (this.d == null) {
            this.d = new CloudNotifier(this.getCloudType().getPresentableName());
        }
        return this.d;
    }

    private void a(Module module2, final String string) {
        final CreateFromSourcesMode createFromSourcesMode = new CreateFromSourcesMode(){

            @Override
            public boolean isAvailable(WizardContext wizardContext) {
                return true;
            }

            @Override
            public void addSteps(WizardContext wizardContext, ModulesProvider modulesProvider, StepSequence stepSequence, String string2) {
                super.addSteps(wizardContext, modulesProvider, stepSequence, string2);
                this.myProjectBuilder.setFileToImport(string);
            }
        };
        final Project project2 = module2.getProject();
        final WizardContext wizardContext = new WizardContext(project2);
        final StepSequence stepSequence = createFromSourcesMode.getSteps(wizardContext, DefaultModulesProvider.createForProject((Project)wizardContext.getProject()));
        if (stepSequence == null) {
            return;
        }
        Disposer.register((Disposable)project2, (Disposable)new Disposable(){

            public void dispose() {
                for (ModuleWizardStep moduleWizardStep : stepSequence.getAllSteps()) {
                    moduleWizardStep.disposeUIResources();
                }
            }
        });
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, CloudBundle.getText((String)"detect.module.structure", (Object[])new Object[]{this.getCloudType().getPresentableName()}), false){

            public void run(@NotNull ProgressIndicator progressIndicator) {
                try {
                    if (progressIndicator == null) {
                        4.a(0);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 4.a(illegalArgumentException);
                }
                ModuleWizardStep moduleWizardStep = (ModuleWizardStep)ContainerUtil.getFirstItem(stepSequence.getSelectedSteps());
                while (true) {
                    block9: {
                        block8: {
                            try {
                                try {
                                    if (moduleWizardStep == null) break;
                                    if (!(moduleWizardStep instanceof AbstractStepWithProgress)) break block8;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw 4.a(illegalArgumentException);
                                }
                                ((AbstractStepWithProgress)moduleWizardStep).performStep();
                                break block9;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw 4.a(illegalArgumentException);
                            }
                        }
                        moduleWizardStep.updateDataModel();
                    }
                    moduleWizardStep = stepSequence.getNextStep(moduleWizardStep);
                }
                CloudAccountSelectionEditor.unsetAccountOnContext((WizardContext)wizardContext, CloudModuleBuilderSourceContribution.this.getCloudType());
            }

            public boolean shouldStartInBackground() {
                return false;
            }

            public void onSuccess() {
                ProjectBuilder projectBuilder = createFromSourcesMode.getModuleBuilder();
                try {
                    if (projectBuilder == null) {
                        return;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 4.a(illegalArgumentException);
                }
                projectBuilder.commit(project2);
                CloudModuleBuilderSourceContribution.this.a().showMessage(CloudBundle.getText((String)"cloud.support.added", (Object[])new Object[]{CloudModuleBuilderSourceContribution.this.getCloudType().getPresentableName()}), MessageType.INFO);
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/remoteServer/impl/module/CloudModuleBuilderSourceContribution$4", "run"));
            }

            private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
                return illegalArgumentException;
            }
        });
    }

    @Override
    protected abstract CloudSourceApplicationConfigurable<SC, DC, SR, AC> createApplicationConfigurable(@Nullable Project var1, Disposable var2);

    protected abstract DC createDeploymentConfiguration();

    protected abstract void doConfigureModule(AC var1, DeployToServerRunConfiguration<SC, DC> var2, boolean var3, SR var4) throws ServerRuntimeException;
}

