/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialPromptDialog;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.remote.AuthType;
import com.intellij.remote.BaseRemoteProcessHandler;
import com.intellij.remote.RemoteCancelledException;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteFile;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.ExecBuilder;
import com.intellij.ssh.ProcessBuilder;
import com.intellij.ssh.RemoteCredentialsUtil$WhenMappings;
import com.intellij.ssh.config.OpenSSHConfigService;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.ssh.interaction.ConnectionOwnerFactory;
import com.intellij.ssh.interaction.RemoteProcessUserInfo;
import com.intellij.ssh.legacy.SftpIdentityInfo;
import com.intellij.ssh.process.CommandLineUtil;
import com.intellij.ssh.process.SshProcess;
import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0007\u001a$\u0010\u0006\u001a\u00020\u0007*\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007\u001a(\u0010\r\u001a\u00020\u000e*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0012H\u0002\u001a\u0012\u0010\u0014\u001a\u00020\u0015*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010\u001a\f\u0010\u0016\u001a\u00020\u0001*\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"JETBRAINS_REMOTE_RUN", "", "sendRootPasswordToProcessStdin", "", "process", "Lcom/intellij/ssh/process/SshProcess;", "connectionBuilder", "Lcom/intellij/ssh/ConnectionBuilder;", "Lcom/intellij/remote/RemoteCredentials;", "project", "Lcom/intellij/openapi/project/Project;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "execBuilder", "Lcom/intellij/ssh/ExecBuilder;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "changeDir", "", "sudo", "processBuilder", "Lcom/intellij/ssh/ProcessBuilder;", "toCommandLineArg", "ssh"})
@JvmName(name="RemoteCredentialsUtil")
public final class RemoteCredentialsUtil {
    private static final String a = "JETBRAINS_REMOTE_RUN";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmOverloads
    @NotNull
    public static final ConnectionBuilder connectionBuilder(@NotNull RemoteCredentials remoteCredentials, @Nullable Project project2, @Nullable ProgressIndicator progressIndicator) {
        Intrinsics.checkParameterIsNotNull((Object)remoteCredentials, (String)"$receiver");
        ConnectionOwner connectionOwner = ConnectionOwnerFactory.createConnectionOwnerWithDialogMessages(project2);
        RemoteProcessUserInfo remoteProcessUserInfo = new RemoteProcessUserInfo(connectionOwner, remoteCredentials, progressIndicator);
        String string = remoteCredentials.getHost();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"host");
        ConnectionBuilder connectionBuilder = new ConnectionBuilder(string, remoteCredentials.getPort());
        String string2 = remoteCredentials.getUserName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"userName");
        ConnectionBuilder connectionBuilder2 = connectionBuilder.withUsername(string2).withUserInfo(remoteProcessUserInfo);
        try {
            switch (RemoteCredentialsUtil$WhenMappings.$EnumSwitchMapping$0[remoteCredentials.getAuthType().ordinal()]) {
                case 1: {
                    connectionBuilder2.withPassword(remoteCredentials.getPassword());
                    return connectionBuilder2.withIgnoreAuthAgent(Intrinsics.areEqual((Object)remoteCredentials.getAuthType(), (Object)AuthType.OPEN_SSH) ^ true);
                }
                case 2: {
                    byte[] byArray;
                    SftpIdentityInfo sftpIdentityInfo;
                    ConnectionBuilder connectionBuilder3 = connectionBuilder2;
                    SftpIdentityInfo sftpIdentityInfo2 = sftpIdentityInfo;
                    SftpIdentityInfo sftpIdentityInfo3 = sftpIdentityInfo;
                    File file = new File(remoteCredentials.getPrivateKeyFile());
                    File file2 = null;
                    String string3 = remoteCredentials.getPassphrase();
                    if (string3 != null) {
                        String string4 = string3;
                        File file3 = file2;
                        File file4 = file;
                        SftpIdentityInfo sftpIdentityInfo4 = sftpIdentityInfo2;
                        SftpIdentityInfo sftpIdentityInfo5 = sftpIdentityInfo3;
                        ConnectionBuilder connectionBuilder4 = connectionBuilder3;
                        Charset charset = Charsets.UTF_8;
                        String string5 = string4;
                        if (string5 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        byte[] byArray2 = string5.getBytes(charset);
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
                        byte[] byArray3 = byArray2;
                        connectionBuilder3 = connectionBuilder4;
                        sftpIdentityInfo3 = sftpIdentityInfo5;
                        sftpIdentityInfo2 = sftpIdentityInfo4;
                        file = file4;
                        file2 = file3;
                        byArray = byArray3;
                    } else {
                        byArray = null;
                    }
                    sftpIdentityInfo2(file, file2, byArray, 2, null);
                    connectionBuilder3.withIdentity(sftpIdentityInfo3);
                    return connectionBuilder2.withIgnoreAuthAgent(Intrinsics.areEqual((Object)remoteCredentials.getAuthType(), (Object)AuthType.OPEN_SSH) ^ true);
                }
                case 3: {
                    connectionBuilder2.withOpenSSHConfig(OpenSSHConfigService.Companion.getInstance().getConfig());
                    return connectionBuilder2.withIgnoreAuthAgent(Intrinsics.areEqual((Object)remoteCredentials.getAuthType(), (Object)AuthType.OPEN_SSH) ^ true);
                }
                default: {
                    return connectionBuilder2.withIgnoreAuthAgent(Intrinsics.areEqual((Object)remoteCredentials.getAuthType(), (Object)AuthType.OPEN_SSH) ^ true);
                }
            }
        }
        catch (TypeCastException typeCastException) {
            throw RemoteCredentialsUtil.b(typeCastException);
        }
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ ConnectionBuilder connectionBuilder$default(RemoteCredentials remoteCredentials, Project project2, ProgressIndicator progressIndicator, int n2, Object object) {
        if ((n2 & 1) != 0) {
            project2 = null;
        }
        if ((n2 & 2) != 0) {
            progressIndicator = null;
        }
        return RemoteCredentialsUtil.connectionBuilder(remoteCredentials, project2, progressIndicator);
    }

    @JvmOverloads
    @NotNull
    public static final ConnectionBuilder connectionBuilder(@NotNull RemoteCredentials remoteCredentials, @Nullable Project project2) {
        return RemoteCredentialsUtil.connectionBuilder$default(remoteCredentials, project2, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public static final ConnectionBuilder connectionBuilder(@NotNull RemoteCredentials remoteCredentials) {
        return RemoteCredentialsUtil.connectionBuilder$default(remoteCredentials, null, null, 3, null);
    }

    @NotNull
    public static final ProcessBuilder processBuilder(@NotNull ConnectionBuilder connectionBuilder, @NotNull GeneralCommandLine generalCommandLine) {
        Intrinsics.checkParameterIsNotNull((Object)connectionBuilder, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)generalCommandLine, (String)"commandLine");
        return new ProcessBuilder(connectionBuilder, generalCommandLine);
    }

    private static final ExecBuilder a(@NotNull ConnectionBuilder connectionBuilder, GeneralCommandLine generalCommandLine, boolean bl2, boolean bl3) {
        String string;
        block4: {
            generalCommandLine.getEnvironment().put(a, "1");
            string = generalCommandLine.getCommandLineString();
            if (!RemoteFile.isWindowsPath((String)generalCommandLine.getExePath())) {
                String string2 = string;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"command");
                string = CommandLineUtil.addEnvCommand(generalCommandLine, string2);
                if (bl3) {
                    string = "sudo -S -p '' " + string;
                }
            }
            try {
                if (!bl2 || generalCommandLine.getWorkDirectory() == null) break block4;
            }
            catch (TypeCastException typeCastException) {
                throw RemoteCredentialsUtil.b(typeCastException);
            }
            String string3 = generalCommandLine.getWorkDirectory().getPath();
            string3 = RemoteFile.detectSystemByPath((String)generalCommandLine.getExePath()).createRemoteFile(string3).getPath();
            string = "cd " + RemoteCredentialsUtil.toCommandLineArg(string3) + "; " + string;
        }
        String string4 = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"command");
        return connectionBuilder.execBuilder(string4);
    }

    static /* bridge */ /* synthetic */ ExecBuilder execBuilder$default(ConnectionBuilder connectionBuilder, GeneralCommandLine generalCommandLine, boolean bl2, boolean bl3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl2 = true;
        }
        if ((n2 & 4) != 0) {
            bl3 = false;
        }
        return RemoteCredentialsUtil.a(connectionBuilder, generalCommandLine, bl2, bl3);
    }

    @NotNull
    public static final String toCommandLineArg(@NotNull String string) {
        String string2;
        try {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"$receiver");
            string2 = StringsKt.contains$default((CharSequence)string, (CharSequence)" ", (boolean)false, (int)2, null) ? '\"' + string + '\"' : string;
        }
        catch (TypeCastException typeCastException) {
            throw RemoteCredentialsUtil.b(typeCastException);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void sendRootPasswordToProcessStdin(@NotNull SshProcess<?> sshProcess) throws RemoteCancelledException {
        Intrinsics.checkParameterIsNotNull(sshProcess, (String)"process");
        String string = sshProcess.getSession().getUserName();
        String string2 = sshProcess.getSession().getHost();
        int n2 = sshProcess.getSession().getPort();
        String string3 = "ssh://" + string + '@' + string2 + ':' + n2;
        String string4 = CredentialPromptDialog.askPassword$default(null, (String)"Enter Root Password", (String)("Sudo password for host \"" + string2 + "\":"), (CredentialAttributes)CredentialAttributesKt.CredentialAttributes(BaseRemoteProcessHandler.class, (String)string3), (boolean)false, null, (int)48, null);
        if (string4 != null) {
            Closeable closeable = new PrintWriter(sshProcess.getOutputStream());
            Throwable throwable = null;
            try {
                PrintWriter printWriter = (PrintWriter)closeable;
                printWriter.println(string4);
                printWriter = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            throw (Throwable)new RemoteCancelledException("Sudo password dialog cancelled.");
        }
    }

    static {
        a = a;
    }

    @NotNull
    public static final /* synthetic */ ExecBuilder access$execBuilder(@NotNull ConnectionBuilder connectionBuilder, @NotNull GeneralCommandLine generalCommandLine, boolean bl2, boolean bl3) {
        return RemoteCredentialsUtil.a(connectionBuilder, generalCommandLine, bl2, bl3);
    }

    private static TypeCastException b(TypeCastException typeCastException) {
        return typeCastException;
    }
}

