/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.ProxyCommand;
import com.intellij.ssh.SessionConfig;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.config.OpenSSHClientConfig;
import com.intellij.ssh.config.OpenSSHConfigUtil;
import com.intellij.ssh.impl.agent.CompositeIdentityRepository;
import com.intellij.ssh.legacy.SftpIdentityInfo;
import com.intellij.ssh.legacy.SftpIdentityRepositoryFactory;
import com.intellij.ssh.sockets.SocketUtils;
import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u0098\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0012\n\u0002\b\u0004\u001a-\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&H\u0000\u00a2\u0006\u0002\u0010(\u001a(\u0010)\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00012\u0006\u0010-\u001a\u00020\u0001H\u0002\u001a\u0018\u0010.\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010/\u001a\u00020'H\u0002\u001a(\u00100\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u00101\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\u00012\u0006\u0010-\u001a\u00020\u0001H\u0002\u001a/\u00102\u001a\u00020\u00062\b\u00103\u001a\u0004\u0018\u00010\u00012\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&2\b\u00104\u001a\u0004\u0018\u000105\u00a2\u0006\u0002\u00106\u001a\u0006\u00107\u001a\u000208\u001a\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0000\u001a\u001a\u0010=\u001a\u00020\u00012\b\u0010>\u001a\u0004\u0018\u00010\u00012\u0006\u0010?\u001a\u00020\u0001H\u0000\u001a\b\u0010@\u001a\u00020$H\u0002\u001a\u0018\u0010A\u001a\u00020 2\u0006\u0010B\u001a\u00020\u00012\u0006\u0010C\u001a\u00020DH\u0002\u001a\"\u0010E\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010F\u001a\u0004\u0018\u00010$H\u0002\u001a\u0018\u0010G\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010F\u001a\u00020$H\u0002\u001a\u001c\u0010H\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010+\u0012\u0004\u0012\u00020J0I2\u0006\u0010;\u001a\u00020<\u001a\u0016\u0010K\u001a\u00020\u00062\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020O\u001a$\u0010P\u001a\u00020 *\u00020J2\u0006\u0010*\u001a\u00020+2\u0006\u0010Q\u001a\u00020\u00012\u0006\u0010?\u001a\u00020\u0001H\u0002\u001a\n\u0010R\u001a\u00020 *\u00020:\u001a#\u0010S\u001a\u0004\u0018\u00010 *\u00020J2\u0006\u0010T\u001a\u00020+2\u0006\u0010U\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010V\u001a\u000e\u0010W\u001a\u0004\u0018\u00010\u0001*\u00020XH\u0000\u001a\u001b\u0010Y\u001a\u0004\u0018\u00010\u0006*\u00020+2\u0006\u0010Q\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010Z\u001a\f\u0010[\u001a\u00020\u0001*\u00020\\H\u0000\u001a\u000e\u0010]\u001a\u00020^*\u0004\u0018\u00010_H\u0002\u001a\u0016\u0010`\u001a\u0004\u0018\u00010\u0001*\u00020+2\u0006\u0010a\u001a\u00020\u0001H\u0002\u001a\f\u0010b\u001a\u00020\u0001*\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000b\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0018\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0019\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001a\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u001b\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\r\"\u0014\u0010\u001d\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\r\u00a8\u0006c"}, d2={"CLEAR_ALL_FORWARDINGS", "", "CONNECT_TIMEOUT", "DEFAULT_HOST_KEY_ALGORITHMS", "DEFAULT_KEX_ALGORITHMS", "DEFAULT_SERVER_ALIVE_COUNT_MAX", "", "getDEFAULT_SERVER_ALIVE_COUNT_MAX", "()I", "DEPLOYMENT_LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "EXEC_CHANNEL_TYPE", "getEXEC_CHANNEL_TYPE", "()Ljava/lang/String;", "FORWARD_AGENT", "HOST_KEY_ALGORITHMS", "HOST_KEY_ALIAS", "KEX_ALGORITHMS", "LOCAL_FORWARD", "LOG", "MAX_AUTH_TRIES", "PROXY_COMMAND", "PROXY_COMMAND_NONE", "PROXY_JUMP", "REMOTE_FORWARD", "SERVER_ALIVE_COUNT_MAX", "SERVER_ALIVE_INTERVAL", "SFTP_CHANNEL_TYPE", "getSFTP_CHANNEL_TYPE", "SHELL_CHANNEL_TYPE", "getSHELL_CHANNEL_TYPE", "addIdentities", "", "jsch", "Lcom/jcraft/jsch/JSch;", "sshDir", "Ljava/io/File;", "identities", "", "Lcom/intellij/ssh/legacy/SftpIdentityInfo;", "(Lcom/jcraft/jsch/JSch;Ljava/io/File;[Lcom/intellij/ssh/legacy/SftpIdentityInfo;)V", "addIdentitiesFromHostConfig", "hostConfig", "Lcom/jcraft/jsch/ConfigRepository$Config;", "remoteHost", "remoteUser", "addIdentity", "info", "addIdentityFromOpenSSHConfig", "identityFile", "calcIdentitiesHashCode", "password", "identityRepositoryFactory", "Lcom/intellij/ssh/legacy/SftpIdentityRepositoryFactory;", "(Ljava/lang/String;[Lcom/intellij/ssh/legacy/SftpIdentityInfo;Lcom/intellij/ssh/legacy/SftpIdentityRepositoryFactory;)I", "createConfig", "Ljava/util/Properties;", "createSshSession", "Lcom/intellij/ssh/SshSession;", "sessionConfig", "Lcom/intellij/ssh/SessionConfig;", "extendCSVParameter", "value", "defaultValue", "findSshDir", "logPortForwardingException", "portForwarding", "e", "Lcom/jcraft/jsch/JSchException;", "setKnownHosts", "knownHostsFile", "setKnownHostsFile", "setUpSession", "Lkotlin/Pair;", "Lcom/jcraft/jsch/Session;", "toTimeoutInMillis", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "applyCSVParameter", "key", "applyPortForwardings", "checkConfig", "config", "s", "(Lcom/jcraft/jsch/Session;Lcom/jcraft/jsch/ConfigRepository$Config;Ljava/lang/String;)Lkotlin/Unit;", "getEffectiveProxyCommand", "Lcom/intellij/ssh/config/OpenSSHClientConfig$HostConfig;", "getIntValue", "(Lcom/jcraft/jsch/ConfigRepository$Config;Ljava/lang/String;)Ljava/lang/Integer;", "id", "", "isNullOrEmpty", "", "", "resolveHostName", "host", "unquoteSingleArgumentValue", "ssh"})
@JvmName(name="SshConnectionUtil")
public final class SshConnectionUtil {
    private static final String i = "ServerAliveCountMax";
    private static final String f = "ServerAliveInterval";
    private static final String t = "ConnectTimeout";
    private static final String h = "ClearAllForwardings";
    private static final String q = "MaxAuthTries";
    private static final String g = "HostKeyAlias";
    private static final String n = "ForwardAgent";
    private static final String r = "LocalForward";
    private static final String d = "RemoteForward";
    @NotNull
    public static final String PROXY_COMMAND = "ProxyCommand";
    @NotNull
    public static final String PROXY_JUMP = "ProxyJump";
    private static final String m = "none";
    private static final String a = "KexAlgorithms";
    private static final String c = "ecdh-sha2-nistp256,ecdh-sha2-nistp384,ecdh-sha2-nistp521,diffie-hellman-group14-sha1,diffie-hellman-group-exchange-sha256,diffie-hellman-group-exchange-sha1";
    private static final String k = "HostKeyAlgorithms";
    private static final String b = "ecdsa-sha2-nistp256,ecdsa-sha2-nistp384,ecdsa-sha2-nistp521,ssh-ed25519,ssh-rsa";
    private static final int l = 1000;
    private static final Logger e;
    private static final Logger p;
    @NotNull
    private static final String s = "shell";
    @NotNull
    private static final String o = "exec";
    @NotNull
    private static final String j = "sftp";

    public static final int getDEFAULT_SERVER_ALIVE_COUNT_MAX() {
        return l;
    }

    public static final int calcIdentitiesHashCode(@Nullable String string, @Nullable SftpIdentityInfo[] sftpIdentityInfoArray, @Nullable SftpIdentityRepositoryFactory sftpIdentityRepositoryFactory) {
        int n2;
        int n3;
        int n4;
        int n5;
        try {
            String string2 = string;
            n5 = string2 != null ? string2.hashCode() : 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw SshConnectionUtil.a(illegalArgumentException);
        }
        int n6 = n5;
        int n7 = 31 * n6;
        if (sftpIdentityInfoArray != null) {
            SftpIdentityInfo[] sftpIdentityInfoArray2 = sftpIdentityInfoArray;
            int n8 = n7;
            SftpIdentityInfo[] sftpIdentityInfoArray3 = sftpIdentityInfoArray2;
            int n9 = Arrays.hashCode(sftpIdentityInfoArray3);
            n7 = n8;
            n4 = n9;
        } else {
            n4 = 0;
        }
        n6 = n7 + n4;
        try {
            n3 = 31 * n6;
            SftpIdentityRepositoryFactory sftpIdentityRepositoryFactory2 = sftpIdentityRepositoryFactory;
            n2 = sftpIdentityRepositoryFactory2 != null ? sftpIdentityRepositoryFactory2.hashCode() : 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw SshConnectionUtil.a(illegalArgumentException);
        }
        n6 = n3 + n2;
        return n6;
    }

    private static final boolean a(@Nullable byte[] byArray) {
        boolean bl2;
        block5: {
            block4: {
                try {
                    try {
                        if (byArray != null && byArray.length != 0) break block4;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw SshConnectionUtil.a(illegalArgumentException);
                    }
                    bl2 = true;
                    break block5;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw SshConnectionUtil.a(illegalArgumentException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    @NotNull
    public static final SshSession createSshSession(@NotNull SessionConfig sessionConfig) {
        Intrinsics.checkParameterIsNotNull((Object)sessionConfig, (String)"sessionConfig");
        Pair<ConfigRepository.Config, Session> pair2 = SshConnectionUtil.setUpSession(sessionConfig);
        ConfigRepository.Config config = (ConfigRepository.Config)pair2.component1();
        Session session = (Session)pair2.component2();
        session.connect();
        return new SshSession(session, config);
    }

    @NotNull
    public static final Pair<ConfigRepository.Config, Session> setUpSession(@NotNull SessionConfig sessionConfig) {
        Object object;
        OpenSSHClientConfig.HostConfig hostConfig;
        block99: {
            String string;
            block102: {
                block101: {
                    String string2;
                    Object object3;
                    Object object4;
                    Properties properties;
                    IdentityRepository identityRepository;
                    block100: {
                        Object object5;
                        Object object6;
                        SftpIdentityInfo[] sftpIdentityInfoArray;
                        block98: {
                            String string3;
                            Integer n2;
                            block97: {
                                block96: {
                                    int n3;
                                    Integer n4;
                                    Object object2;
                                    block95: {
                                        block94: {
                                            Integer n5;
                                            block93: {
                                                block92: {
                                                    block91: {
                                                        Object object7;
                                                        block90: {
                                                            SocketFactory socketFactory;
                                                            block89: {
                                                                block88: {
                                                                    JSch jSch;
                                                                    block87: {
                                                                        OpenSSHClientConfig.HostConfig hostConfig2;
                                                                        Object object8;
                                                                        block86: {
                                                                            block85: {
                                                                                OpenSSHClientConfig.HostConfig hostConfig3;
                                                                                Intrinsics.checkParameterIsNotNull((Object)sessionConfig, (String)"sessionConfig");
                                                                                jSch = new JSch();
                                                                                File file = SshConnectionUtil.a();
                                                                                SshConnectionUtil.a(jSch, file, sessionConfig.getKnownHostsFile());
                                                                                sftpIdentityInfoArray = sessionConfig.getIdentities();
                                                                                try {
                                                                                    if (sftpIdentityInfoArray != null) {
                                                                                        SshConnectionUtil.addIdentities(jSch, file, sftpIdentityInfoArray);
                                                                                    }
                                                                                }
                                                                                catch (IllegalArgumentException illegalArgumentException) {
                                                                                    throw SshConnectionUtil.a(illegalArgumentException);
                                                                                }
                                                                                try {
                                                                                    OpenSSHClientConfig openSSHClientConfig = sessionConfig.getOpenSSHConfig();
                                                                                    hostConfig3 = openSSHClientConfig != null ? openSSHClientConfig.getConfig(sessionConfig.getHost()) : null;
                                                                                }
                                                                                catch (IllegalArgumentException illegalArgumentException) {
                                                                                    throw SshConnectionUtil.a(illegalArgumentException);
                                                                                }
                                                                                hostConfig = hostConfig3;
                                                                                try {
                                                                                    try {
                                                                                        jSch.setConfigRepository((ConfigRepository)null);
                                                                                        object8 = hostConfig;
                                                                                        if (object8 == null || (object8 = SshConnectionUtil.a((ConfigRepository.Config)object8, sessionConfig.getHost())) == null) break block85;
                                                                                        break block86;
                                                                                    }
                                                                                    catch (IllegalArgumentException illegalArgumentException) {
                                                                                        throw SshConnectionUtil.a(illegalArgumentException);
                                                                                    }
                                                                                }
                                                                                catch (IllegalArgumentException illegalArgumentException) {
                                                                                    throw SshConnectionUtil.a(illegalArgumentException);
                                                                                }
                                                                            }
                                                                            object8 = sessionConfig.getHost();
                                                                        }
                                                                        object6 = object8;
                                                                        try {
                                                                            try {
                                                                                if (sftpIdentityInfoArray != null || sessionConfig.getPassword() != null) break block87;
                                                                            }
                                                                            catch (IllegalArgumentException illegalArgumentException) {
                                                                                throw SshConnectionUtil.a(illegalArgumentException);
                                                                            }
                                                                            hostConfig2 = hostConfig;
                                                                            if (hostConfig2 == null) break block87;
                                                                        }
                                                                        catch (IllegalArgumentException illegalArgumentException) {
                                                                            throw SshConnectionUtil.a(illegalArgumentException);
                                                                        }
                                                                        object5 = hostConfig2;
                                                                        object = object5;
                                                                        SshConnectionUtil.a(jSch, (ConfigRepository.Config)object, (String)object6, sessionConfig.getUsername());
                                                                    }
                                                                    if ((object5 = sessionConfig.getIdentityRepositoryFactory()) != null && (object = object5.create(jSch)) != null) {
                                                                        IdentityRepository identityRepository2 = identityRepository = jSch.getIdentityRepository();
                                                                        Intrinsics.checkExpressionValueIsNotNull((Object)identityRepository2, (String)"localIdentityRepository");
                                                                        jSch.setIdentityRepository((IdentityRepository)new CompositeIdentityRepository(identityRepository2, (IdentityRepository)object));
                                                                    }
                                                                    object = jSch.getSession(sessionConfig.getUsername(), (String)object6, sessionConfig.getPort());
                                                                    try {
                                                                        if (sessionConfig.getPassword() != null) {
                                                                            object.setPassword(sessionConfig.getPassword());
                                                                        }
                                                                    }
                                                                    catch (IllegalArgumentException illegalArgumentException) {
                                                                        throw SshConnectionUtil.a(illegalArgumentException);
                                                                    }
                                                                    try {
                                                                        if (sessionConfig.getUserInfo() != null) {
                                                                            object.setUserInfo(sessionConfig.getUserInfo());
                                                                        }
                                                                    }
                                                                    catch (IllegalArgumentException illegalArgumentException) {
                                                                        throw SshConnectionUtil.a(illegalArgumentException);
                                                                    }
                                                                    try {
                                                                        if (sessionConfig.getProxy() != null) {
                                                                            object.setProxy(sessionConfig.getProxy());
                                                                        }
                                                                    }
                                                                    catch (IllegalArgumentException illegalArgumentException) {
                                                                        throw SshConnectionUtil.a(illegalArgumentException);
                                                                    }
                                                                    try {
                                                                        socketFactory = sessionConfig.getSocketFactory();
                                                                        if (socketFactory == null) break block88;
                                                                        break block89;
                                                                    }
                                                                    catch (IllegalArgumentException illegalArgumentException) {
                                                                        throw SshConnectionUtil.a(illegalArgumentException);
                                                                    }
                                                                }
                                                                socketFactory = SocketUtils.getSftpSocketFactory(sessionConfig.getHost());
                                                            }
                                                            identityRepository = socketFactory;
                                                            try {
                                                                if (identityRepository != null) {
                                                                    object.setSocketFactory((SocketFactory)identityRepository);
                                                                }
                                                            }
                                                            catch (IllegalArgumentException illegalArgumentException) {
                                                                throw SshConnectionUtil.a(illegalArgumentException);
                                                            }
                                                            try {
                                                                if (hostConfig != null) {
                                                                    SshConnectionUtil.a((Session)object, (ConfigRepository.Config)hostConfig, a, c);
                                                                    SshConnectionUtil.a((Session)object, (ConfigRepository.Config)hostConfig, k, b);
                                                                    SshConnectionUtil.a((Session)object, hostConfig, "cipher.c2s");
                                                                    SshConnectionUtil.a((Session)object, hostConfig, "cipher.s2c");
                                                                    SshConnectionUtil.a((Session)object, hostConfig, "mac.c2s");
                                                                    SshConnectionUtil.a((Session)object, hostConfig, "mac.s2c");
                                                                    SshConnectionUtil.a((Session)object, hostConfig, "compression.c2s");
                                                                    SshConnectionUtil.a((Session)object, hostConfig, "compression.s2c");
                                                                    SshConnectionUtil.a((Session)object, hostConfig, "compression_level");
                                                                    SshConnectionUtil.a((Session)object, hostConfig, q);
                                                                    SshConnectionUtil.a((Session)object, hostConfig, h);
                                                                    SshConnectionUtil.a((Session)object, hostConfig, n);
                                                                }
                                                            }
                                                            catch (IllegalArgumentException illegalArgumentException) {
                                                                throw SshConnectionUtil.a(illegalArgumentException);
                                                            }
                                                            properties = sessionConfig.getConfig();
                                                            try {
                                                                try {
                                                                    if (properties == null || properties.size() <= 0) break block90;
                                                                }
                                                                catch (IllegalArgumentException illegalArgumentException) {
                                                                    throw SshConnectionUtil.a(illegalArgumentException);
                                                                }
                                                                object.setConfig(properties);
                                                            }
                                                            catch (IllegalArgumentException illegalArgumentException) {
                                                                throw SshConnectionUtil.a(illegalArgumentException);
                                                            }
                                                        }
                                                        try {
                                                            object7 = hostConfig;
                                                            if (object7 == null || (object7 = ((OpenSSHClientConfig.HostConfig)object7).getValue(g)) == null) break block91;
                                                        }
                                                        catch (IllegalArgumentException illegalArgumentException) {
                                                            throw SshConnectionUtil.a(illegalArgumentException);
                                                        }
                                                        object3 = object4 = object7;
                                                        object.setHostKeyAlias((String)object3);
                                                    }
                                                    try {
                                                        n5 = sessionConfig.getServerAliveInterval();
                                                        if (n5 == null) break block92;
                                                        break block93;
                                                    }
                                                    catch (IllegalArgumentException illegalArgumentException) {
                                                        throw SshConnectionUtil.a(illegalArgumentException);
                                                    }
                                                }
                                                try {
                                                    OpenSSHClientConfig.HostConfig hostConfig4 = hostConfig;
                                                    n5 = hostConfig4 != null ? SshConnectionUtil.b(hostConfig4, f) : null;
                                                }
                                                catch (IllegalArgumentException illegalArgumentException) {
                                                    throw SshConnectionUtil.a(illegalArgumentException);
                                                }
                                            }
                                            object4 = n5;
                                            try {
                                                if (object4 != null) {
                                                    object.setServerAliveInterval(((Integer)object4).intValue());
                                                }
                                            }
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw SshConnectionUtil.a(illegalArgumentException);
                                            }
                                            try {
                                                object2 = object;
                                                n4 = sessionConfig.getServerAliveCountMax();
                                                if (n4 == null) break block94;
                                                break block95;
                                            }
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw SshConnectionUtil.a(illegalArgumentException);
                                            }
                                        }
                                        try {
                                            OpenSSHClientConfig.HostConfig hostConfig5 = hostConfig;
                                            n4 = hostConfig5 != null ? SshConnectionUtil.b(hostConfig5, i) : null;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw SshConnectionUtil.a(illegalArgumentException);
                                        }
                                    }
                                    try {
                                        n3 = n4 != null ? n4 : l;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw SshConnectionUtil.a(illegalArgumentException);
                                    }
                                    try {
                                        object2.setServerAliveCountMax(n3);
                                        n2 = sessionConfig.getTimeout();
                                        if (n2 == null) break block96;
                                        break block97;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw SshConnectionUtil.a(illegalArgumentException);
                                    }
                                }
                                try {
                                    OpenSSHClientConfig.HostConfig hostConfig6 = hostConfig;
                                    n2 = hostConfig6 != null ? SshConnectionUtil.b(hostConfig6, t) : null;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw SshConnectionUtil.a(illegalArgumentException);
                                }
                            }
                            object3 = n2;
                            try {
                                if (object3 != null) {
                                    object.setTimeout(((Integer)object3).intValue());
                                }
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw SshConnectionUtil.a(illegalArgumentException);
                            }
                            try {
                                OpenSSHClientConfig.HostConfig hostConfig7 = hostConfig;
                                string3 = hostConfig7 != null ? SshConnectionUtil.getEffectiveProxyCommand(hostConfig7) : null;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw SshConnectionUtil.a(illegalArgumentException);
                            }
                            string2 = string3;
                            try {
                                try {
                                    if (string2 == null || !(Intrinsics.areEqual((Object)SshConnectionUtil.a(string2), (Object)m) ^ true)) break block98;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw SshConnectionUtil.a(illegalArgumentException);
                                }
                                String string4 = object.getUserName();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"session.userName");
                                object.setProxy((Proxy)new ProxyCommand(string2, string4));
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw SshConnectionUtil.a(illegalArgumentException);
                            }
                        }
                        try {
                            object.setDaemonThread(sessionConfig.getDaemonThread());
                            if (!e.isDebugEnabled() && !p.isDebugEnabled()) break block99;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw SshConnectionUtil.a(illegalArgumentException);
                        }
                        string = "Setting up ssh connection to " + (String)object6 + ':' + sessionConfig.getPort() + " for " + sessionConfig.getUsername();
                        if (sessionConfig.getPassword() != null) {
                            string = string + ", with password";
                        }
                        if (object5 != null) {
                            string = string + ", with identityRepositoryFactory " + object5;
                        }
                        if (sftpIdentityInfoArray != null) {
                            string = string + ", with identities";
                            int n6 = sftpIdentityInfoArray.length;
                            for (int i2 = 0; i2 < n6; ++i2) {
                                String string5;
                                StringBuilder stringBuilder;
                                SftpIdentityInfo object22 = sftpIdentityInfoArray[i2];
                                try {
                                    stringBuilder = new StringBuilder().append(string).append(" {").append(object22.getPrivateKey()).append(", ").append(object22.getPublicKey()).append(", ");
                                    string5 = object22.getPassPhrase() == null ? "no" : "***";
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw SshConnectionUtil.a(illegalArgumentException);
                                }
                                string = stringBuilder.append(string5).append('}').toString();
                            }
                        }
                        try {
                            if (sftpIdentityInfoArray != null || sessionConfig.getPassword() != null) break block100;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw SshConnectionUtil.a(illegalArgumentException);
                        }
                        string = string + ", without identities and password, adding identities from OpenSSH config";
                    }
                    if (sessionConfig.getProxy() != null) {
                        string = string + ", with proxy " + sessionConfig.getProxy();
                    }
                    if (identityRepository != null) {
                        string = string + ", with socketFactory " + identityRepository;
                    }
                    if (object4 != null) {
                        string = string + ", with keepAliveTimeout " + object4;
                    }
                    string = string + ", with serverAliveCountMax " + object.getServerAliveCountMax();
                    string = string + ", with timeout " + object3;
                    if (string2 != null) {
                        string = string + ", with proxyCommand " + string2;
                    }
                    string = string + ", with daemonThread " + sessionConfig.getDaemonThread();
                    if (hostConfig != null) {
                        string = string + "\nWith openSSH config ";
                        for (String string6 : new String[]{a, k, "cipher.c2s", "cipher.s2c", "mac.c2s", "mac.s2c", "compression.c2s", "compression.s2c", "compression_level", q, h, n}) {
                            String string7;
                            if (hostConfig.getValue(string6) == null) continue;
                            String string8 = string7;
                            string = string + ", " + string6 + '=' + string8;
                        }
                        String string9 = hostConfig.getValue(g);
                        if (string9 != null) {
                            String string10;
                            String object10 = string10 = string9;
                            string = string + " with hostKeyAlias " + object10;
                        }
                    }
                    try {
                        if (properties == null || properties.size() <= 0) break block101;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw SshConnectionUtil.a(illegalArgumentException);
                    }
                    string = string + "\nWith config";
                    Map map = properties;
                    for (Map.Entry entry : map.entrySet()) {
                        string = string + ' ' + entry.getKey() + " = " + entry.getValue() + ',';
                    }
                }
                try {
                    if (!e.isDebugEnabled()) break block102;
                    e.debug(string);
                    break block99;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw SshConnectionUtil.a(illegalArgumentException);
                }
            }
            p.debug(string);
        }
        return new Pair((Object)hostConfig, object);
    }

    @Nullable
    public static final String getEffectiveProxyCommand(@NotNull OpenSSHClientConfig.HostConfig hostConfig) {
        Intrinsics.checkParameterIsNotNull((Object)hostConfig, (String)"$receiver");
        Iterator iterator = hostConfig.stream().iterator();
        while (iterator.hasNext()) {
            Pair pair2 = (Pair)iterator.next();
            String string = (String)pair2.component1();
            String string2 = (String)pair2.component2();
            try {
                if (StringsKt.equals((String)PROXY_COMMAND, (String)string, (boolean)true)) {
                    return string2;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw SshConnectionUtil.a(illegalArgumentException);
            }
            if (!StringsKt.equals((String)PROXY_JUMP, (String)string, (boolean)true)) continue;
            String string3 = OpenSSHConfigUtil.toProxyCommand(OpenSSHConfigUtil.parseJump(string2));
            e.debug("Setting implicit ProxyCommand from ProxyJump: " + string3);
            return string3;
        }
        return null;
    }

    private static final void a(@NotNull Session session, ConfigRepository.Config config, String string, String string2) {
        session.setConfig(string, SshConnectionUtil.extendCSVParameter(config.getValue(string), string2));
    }

    @NotNull
    public static final String extendCSVParameter(@Nullable String string, @NotNull String string2) {
        String string3;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"defaultValue");
        if (string == null) {
            string3 = string2;
        } else if (StringsKt.startsWith$default((String)string, (String)"+", (boolean)false, (int)2, null)) {
            String string4 = string;
            int n2 = 1;
            String string5 = string4.substring(n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            String string6 = string5;
            string3 = string2 + "," + string6;
        } else {
            string3 = string;
        }
        return string3;
    }

    private static final String a(@NotNull ConfigRepository.Config config, String string) {
        String string2;
        String string3 = config.getValue("HostName");
        if (string3 != null) {
            String string4;
            String string5 = string4 = string3;
            string2 = OpenSSHConfigUtil.resolveHostName(string5, string);
        } else {
            string2 = null;
        }
        return string2;
    }

    public static final void applyPortForwardings(@NotNull SshSession sshSession) {
        block14: {
            String[] stringArray;
            String string;
            block13: {
                String[] stringArray2;
                try {
                    Intrinsics.checkParameterIsNotNull((Object)sshSession, (String)"$receiver");
                    if (Intrinsics.areEqual((Object)sshSession.getRawSession().getConfig(h), (Object)"yes")) {
                        return;
                    }
                }
                catch (JSchException jSchException) {
                    throw SshConnectionUtil.a((Exception)((Object)jSchException));
                }
                try {
                    stringArray2 = sshSession.getHostConfig$ssh();
                    if (stringArray2 == null || (stringArray2 = stringArray2.getValues(r)) == null) break block13;
                }
                catch (JSchException jSchException) {
                    throw SshConnectionUtil.a((Exception)((Object)jSchException));
                }
                for (Object object : (Object[])stringArray2) {
                    string = (String)object;
                    try {
                        sshSession.getRawSession().setPortForwardingL(string);
                    }
                    catch (JSchException jSchException) {
                        SshConnectionUtil.a("" + r + " \"" + string + '\"', jSchException);
                    }
                }
            }
            try {
                stringArray = sshSession.getHostConfig$ssh();
                if (stringArray == null || (stringArray = stringArray.getValues(d)) == null) break block14;
            }
            catch (JSchException jSchException) {
                throw SshConnectionUtil.a((Exception)((Object)jSchException));
            }
            for (Object object : (Object[])stringArray) {
                string = (String)object;
                try {
                    sshSession.getRawSession().setPortForwardingR(string);
                }
                catch (JSchException jSchException) {
                    SshConnectionUtil.a("" + d + " \"" + string + '\"', jSchException);
                }
            }
        }
    }

    private static final void a(String string, JSchException jSchException) {
        block6: {
            block8: {
                try {
                    try {
                        String string2 = jSchException.getMessage();
                        if (string2 != null && StringsKt.contains$default((CharSequence)string2, (CharSequence)" is already registered.", (boolean)false, (int)2, null)) break block6;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw SshConnectionUtil.a(illegalArgumentException);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw SshConnectionUtil.a(illegalArgumentException);
                }
                try {
                    if (!e.isDebugEnabled()) break block8;
                    e.debug("Failed to apply OpenSSH " + string, (Throwable)jSchException);
                    break block6;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw SshConnectionUtil.a(illegalArgumentException);
                }
            }
            e.info("Failed to apply OpenSSH " + string + ": " + jSchException.getMessage());
        }
    }

    private static final Unit a(@NotNull Session session, ConfigRepository.Config config, String string) {
        Unit unit;
        String string2 = config.getValue(string);
        if (string2 != null) {
            String string3;
            String string4 = string3 = string2;
            session.setConfig(string, string4);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private static final void a(JSch jSch, ConfigRepository.Config config, String string, String string2) {
        Object object;
        String[] stringArray = config.getValues("IdentityFile");
        Object object2 = object = (Object[])stringArray;
        Collection collection = new ArrayList(((Object[])object).length);
        for (Object object3 : object2) {
            String string3 = (String)object3;
            Collection collection2 = collection;
            String string4 = SshConnectionUtil.a(string3);
            collection2.add(string4);
        }
        object = (List)collection;
        object2 = object.iterator();
        while (object2.hasNext()) {
            collection = object2.next();
            String string5 = (String)((Object)collection);
            SshConnectionUtil.a(jSch, string5, string, string2);
        }
    }

    private static final String a(@NotNull String string) {
        String string2 = StringUtil.unquoteString((String)string, (char)'\"');
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringUtil.unquoteString(this, '\"')");
        return string2;
    }

    private static final void a(JSch jSch, String string, String string2, String string3) {
        try {
            String string4 = OpenSSHConfigUtil.resolveIdentityFile(string, string2, string3);
            jSch.addIdentity(string4);
        }
        catch (Exception exception) {
            block4: {
                try {
                    if (!e.isDebugEnabled()) break block4;
                    e.debug("Identity file " + string + " cannot be added and will be ignored", (Throwable)exception);
                }
                catch (Exception exception2) {
                    throw SshConnectionUtil.a(exception2);
                }
            }
            e.info("Identity file " + string + " cannot be added and will be ignored: " + exception.getMessage());
        }
    }

    @NotNull
    public static final Properties createConfig() {
        Properties properties = new Properties();
        properties.setProperty("compression.s2c", "zlib,none");
        properties.setProperty("compression.c2s", "zlib,none");
        properties.setProperty("HashKnownHosts", "no");
        properties.setProperty("StrictHostKeyChecking", "no");
        return properties;
    }

    public static final int toTimeoutInMillis(long l2, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
        long l3 = TimeUnit.MILLISECONDS.convert(l2, timeUnit);
        try {
            if (l3 < 0L) {
                throw (Throwable)new IllegalArgumentException("Invalid timeout value: " + l3);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw SshConnectionUtil.a(illegalArgumentException);
        }
        try {
            if (l3 > (long)Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw SshConnectionUtil.a(illegalArgumentException);
        }
        return (int)l3;
    }

    @NotNull
    public static final String getSHELL_CHANNEL_TYPE() {
        return s;
    }

    @NotNull
    public static final String getEXEC_CHANNEL_TYPE() {
        return o;
    }

    @NotNull
    public static final String getSFTP_CHANNEL_TYPE() {
        return j;
    }

    @NotNull
    public static final String id(@NotNull Object object) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"$receiver");
        return '@' + Integer.toHexString(object.hashCode());
    }

    public static final void addIdentities(@NotNull JSch jSch, @NotNull File file, @Nullable SftpIdentityInfo[] sftpIdentityInfoArray) {
        block11: {
            Intrinsics.checkParameterIsNotNull((Object)jSch, (String)"jsch");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"sshDir");
            if (sftpIdentityInfoArray != null) {
                int n2 = 0;
                int n3 = ((Object[])sftpIdentityInfoArray).length;
                int n4 = n3 - 1;
                if (n2 <= n4) {
                    while (true) {
                        SftpIdentityInfo sftpIdentityInfo = sftpIdentityInfoArray[n2];
                        try {
                            SshConnectionUtil.a(jSch, sftpIdentityInfo);
                            if (n2 != n4) {
                                ++n2;
                                continue;
                            }
                            break;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw SshConnectionUtil.a(illegalArgumentException);
                        }
                    }
                }
            } else {
                File file2 = new File(file, "id_rsa");
                try {
                    try {
                        if (!file2.isFile() || !file2.canRead()) break block11;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw SshConnectionUtil.a(illegalArgumentException);
                    }
                    SshConnectionUtil.a(jSch, new SftpIdentityInfo(file2, null, null, 6, null));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw SshConnectionUtil.a(illegalArgumentException);
                }
            }
        }
    }

    private static final void a(JSch jSch, SftpIdentityInfo sftpIdentityInfo) {
        try {
            String string;
            String string2;
            try {
                string2 = sftpIdentityInfo.getPrivateKey() != null ? sftpIdentityInfo.getPrivateKey().getAbsolutePath() : null;
            }
            catch (JSchException jSchException) {
                throw SshConnectionUtil.a((Exception)((Object)jSchException));
            }
            String string3 = string2;
            try {
                string = sftpIdentityInfo.getPublicKey() != null ? sftpIdentityInfo.getPublicKey().getAbsolutePath() : null;
            }
            catch (JSchException jSchException) {
                throw SshConnectionUtil.a((Exception)((Object)jSchException));
            }
            String string4 = string;
            jSch.addIdentity(string3, string4, sftpIdentityInfo.getPassPhrase());
        }
        catch (JSchException jSchException) {
            throw (Throwable)new SshTransportException("Failed to load identity file", jSchException);
        }
    }

    private static final File a() {
        File file;
        String string = System.getProperty("vfs.sftp.sshdir");
        if (string != null) {
            file = new File(string);
            try {
                if (file.exists()) {
                    return file;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw SshConnectionUtil.a(illegalArgumentException);
            }
        }
        file = new File(System.getProperty("user.home"), ".ssh");
        try {
            if (file.exists()) {
                return file;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw SshConnectionUtil.a(illegalArgumentException);
        }
        if (SystemInfo.isWindows) {
            String string2 = System.getProperty("user.name");
            file = new File("C:\\cygwin\\home\\" + string2 + "\\.ssh");
            try {
                if (file.exists()) {
                    return file;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw SshConnectionUtil.a(illegalArgumentException);
            }
        }
        return new File("");
    }

    private static final void a(JSch jSch, File file, File file2) {
        block7: {
            block6: {
                try {
                    if (file2 == null) break block6;
                    SshConnectionUtil.a(jSch, file2);
                    break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw SshConnectionUtil.a(illegalArgumentException);
                }
            }
            File file3 = new File(file, "known_hosts");
            try {
                try {
                    if (!file3.isFile() || !file3.canRead()) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw SshConnectionUtil.a(illegalArgumentException);
                }
                SshConnectionUtil.a(jSch, file3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw SshConnectionUtil.a(illegalArgumentException);
            }
        }
    }

    private static final void a(JSch jSch, File file) {
        try {
            jSch.setKnownHosts(file.getAbsolutePath());
        }
        catch (JSchException jSchException) {
            throw (Throwable)new SshTransportException("Using of known_hosts file " + file.getAbsolutePath() + " failed", jSchException);
        }
    }

    private static final Integer b(@NotNull ConfigRepository.Config config, String string) {
        Void void_;
        String string2 = config.getValue(string);
        if (string2 != null) {
            String string3;
            String string4 = string3 = string2;
            try {
                Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            void_ = null;
        } else {
            void_ = null;
        }
        return (Integer)((Object)void_);
    }

    static {
        i = i;
        f = f;
        t = t;
        h = h;
        q = q;
        g = g;
        n = n;
        r = r;
        d = d;
        l = 1000;
        e = Logger.getInstance((String)"#com.intellij.ssh.SshConnectionUtil");
        p = Logger.getInstance((String)"#com.jetbrains.plugins.webDeployment");
        s = s;
        o = o;
        j = j;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

