/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.ArrayUtil;
import java.lang.management.ManagementFactory;
import java.math.BigInteger;
import java.util.stream.LongStream;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class CpuTimings {
    final long[] rawData;
    final long average;
    final double stdDev;
    final int attempt;

    private CpuTimings(long[] lArray, int n2) {
        this.rawData = lArray;
        this.attempt = n2;
        this.average = ArrayUtil.averageAmongMedians((long[])lArray, (int)2);
        this.stdDev = CpuTimings.a(lArray);
    }

    private static double a(long[] lArray) {
        double d2 = LongStream.of(lArray).mapToDouble(l2 -> l2).average().getAsDouble();
        double d3 = 0.0;
        for (long l3 : lArray) {
            d3 += Math.pow(d2 - (double)l3, 2.0);
        }
        return Math.sqrt(d3 / d2);
    }

    public String toString() {
        return this.average + ", sd=" + this.stdDev + ", attempt=" + this.attempt;
    }

    static CpuTimings calcStableCpuTiming() {
        int n2;
        try {
            n2 = UsefulTestCase.IS_UNDER_TEAMCITY ? 100 : 10;
        }
        catch (RuntimeException runtimeException) {
            throw CpuTimings.b(runtimeException);
        }
        int n3 = n2;
        int n4 = 0;
        while (true) {
            CpuTimings cpuTimings = CpuTimings.a(20, CpuTimings::a, n4);
            try {
                if (cpuTimings.stdDev < 1.8) {
                    return cpuTimings;
                }
            }
            catch (RuntimeException runtimeException) {
                throw CpuTimings.b(runtimeException);
            }
            try {
                if (n4 == n3) {
                    System.out.printf("CPU Timings: %d, sd=%.2f; not stable enough, giving up%n", cpuTimings.average, cpuTimings.stdDev);
                    return cpuTimings;
                }
            }
            catch (RuntimeException runtimeException) {
                throw CpuTimings.b(runtimeException);
            }
            try {
                if (n4 > 3) {
                    System.out.printf("CPU Timings: %d, sd=%.2f; unstable (getProcessCpuLoad() = %s; getSystemCpuLoad() = %s)%n", cpuTimings.average, cpuTimings.stdDev, CpuTimings.getProcessCpuLoad(), CpuTimings.getSystemCpuLoad());
                }
            }
            catch (RuntimeException runtimeException) {
                throw CpuTimings.b(runtimeException);
            }
            System.gc();
            PlatformTestUtil.waitForAllBackgroundActivityToCalmDown();
            ++n4;
        }
    }

    private static CpuTimings a(int n2, Runnable runnable, int n3) {
        long[] lArray = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = System.currentTimeMillis();
            runnable.run();
            lArray[i2] = System.currentTimeMillis() - l2;
        }
        return new CpuTimings(lArray, n3);
    }

    private static void a() {
        BigInteger bigInteger = new BigInteger("1");
        for (int i2 = 0; i2 < 1000000; ++i2) {
            bigInteger = bigInteger.add(new BigInteger("1"));
        }
    }

    private static void c() {
        long l2 = 241L;
        int n2 = 0;
        while (true) {
            long l3;
            block6: {
                block5: {
                    try {
                        try {
                            if (n2 >= 22222222) break;
                            if (n2 % 10 != 3) break block5;
                        }
                        catch (RuntimeException runtimeException) {
                            throw CpuTimings.b(runtimeException);
                        }
                        l3 = l2 * 239L;
                        break block6;
                    }
                    catch (RuntimeException runtimeException) {
                        throw CpuTimings.b(runtimeException);
                    }
                }
                l3 = l2 % 12342L;
            }
            l2 = l3;
            ++n2;
        }
        CpuTimings.b(l2);
    }

    private static void b(long l2) {
        try {
            if (l2 % 2L == 0L) {
                throw new AssertionError((Object)"Should be an odd value");
            }
        }
        catch (RuntimeException runtimeException) {
            throw CpuTimings.b(runtimeException);
        }
    }

    private static void b() {
        int n2;
        int[] nArray = new int[240000];
        try {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray[n2] = n2 * 42 + 1;
            }
        }
        catch (RuntimeException runtimeException) {
            throw CpuTimings.b(runtimeException);
        }
        n2 = 241;
        for (int i2 = 0; i2 < 5750000; ++i2) {
            n2 *= nArray[Math.abs(n2) % nArray.length];
        }
        CpuTimings.b(n2);
    }

    public static double getProcessCpuLoad() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = ObjectName.getInstance("java.lang:type=OperatingSystem");
            AttributeList attributeList = mBeanServer.getAttributes(objectName, new String[]{"ProcessCpuLoad"});
            if (attributeList.isEmpty()) {
                return Double.NaN;
            }
            Attribute attribute = (Attribute)attributeList.get(0);
            Double d2 = (Double)attribute.getValue();
            if (d2 == -1.0) {
                return Double.NaN;
            }
            return (double)((int)(d2 * 1000.0)) / 10.0;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static double getSystemCpuLoad() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = ObjectName.getInstance("java.lang:type=OperatingSystem");
            AttributeList attributeList = mBeanServer.getAttributes(objectName, new String[]{"SystemCpuLoad"});
            if (attributeList.isEmpty()) {
                return Double.NaN;
            }
            Attribute attribute = (Attribute)attributeList.get(0);
            Double d2 = (Double)attribute.getValue();
            if (d2 == -1.0) {
                return Double.NaN;
            }
            return (double)((int)(d2 * 1000.0)) / 10.0;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void main(String[] stringArray) {
        try {
            for (int i2 = 0; i2 < 20; ++i2) {
            }
        }
        catch (RuntimeException runtimeException) {
            throw CpuTimings.b(runtimeException);
        }
    }

    private static RuntimeException b(RuntimeException runtimeException) {
        return runtimeException;
    }
}

