/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExpectedHighlightingData {
    private static final String n = "error";
    private static final String h = "warning";
    private static final String l = "weak_warning";
    private static final String e = "info";
    private static final String p = "EOLError";
    private static final String k = "EOLWarning";
    private static final String f = "inject";
    private static final String o = "symbolName";
    private static final String d = "lineMarker";
    private static final String a = "*";
    private static final HighlightInfoType c;
    private final Map<String, ExpectedHighlightingSet> j;
    private final Map<RangeMarker, LineMarkerInfo> b;
    private final Document m;
    private final PsiFile q;
    private final String g;
    private boolean i;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ExpectedHighlightingData(@NotNull Document document, boolean bl2, boolean bl3) {
        if (document == null) {
            ExpectedHighlightingData.a(0);
        }
        this(document, bl2, false, bl3);
    }

    public ExpectedHighlightingData(@NotNull Document document, boolean bl2, boolean bl3, boolean bl4) {
        if (document == null) {
            ExpectedHighlightingData.a(1);
        }
        this(document, bl2, bl3, bl4, null);
    }

    public ExpectedHighlightingData(@NotNull Document document, boolean bl2, boolean bl3, boolean bl4, @Nullable PsiFile psiFile) {
        if (document == null) {
            ExpectedHighlightingData.a(2);
        }
        this(document, bl2, bl3, bl4, false, psiFile);
    }

    public ExpectedHighlightingData(@NotNull Document document, boolean bl2, boolean bl3, boolean bl4, boolean bl5, @Nullable PsiFile psiFile) {
        if (document == null) {
            ExpectedHighlightingData.a(3);
        }
        this(document, psiFile);
        this.i = bl5;
        if (bl2) {
            this.checkWarnings();
        }
        try {
            if (bl3) {
                this.checkWeakWarnings();
            }
        }
        catch (RuntimeException runtimeException) {
            throw ExpectedHighlightingData.a(runtimeException);
        }
        try {
            if (bl4) {
                this.checkInfos();
            }
        }
        catch (RuntimeException runtimeException) {
            throw ExpectedHighlightingData.a(runtimeException);
        }
    }

    public ExpectedHighlightingData(@NotNull Document document, @Nullable PsiFile psiFile) {
        if (document == null) {
            ExpectedHighlightingData.a(4);
        }
        this.j = new LinkedHashMap<String, ExpectedHighlightingSet>();
        this.b = new THashMap();
        this.m = document;
        this.q = psiFile;
        this.g = document.getText();
        this.registerHighlightingType("error", new ExpectedHighlightingSet(HighlightSeverity.ERROR, false, true));
        this.registerHighlightingType("warning", new ExpectedHighlightingSet(HighlightSeverity.WARNING, false, false));
        this.registerHighlightingType("weak_warning", new ExpectedHighlightingSet(HighlightSeverity.WEAK_WARNING, false, false));
        this.registerHighlightingType("inject", new ExpectedHighlightingSet(HighlightInfoType.INJECTED_FRAGMENT_SEVERITY, false, false));
        this.registerHighlightingType("info", new ExpectedHighlightingSet(HighlightSeverity.INFORMATION, false, false));
        this.registerHighlightingType("symbolName", new ExpectedHighlightingSet(HighlightInfoType.SYMBOL_TYPE_SEVERITY, false, false));
        for (SeveritiesProvider severitiesProvider : (SeveritiesProvider[])Extensions.getExtensions((ExtensionPointName)SeveritiesProvider.EP_NAME)) {
            for (HighlightInfoType highlightInfoType : severitiesProvider.getSeveritiesHighlightInfoTypes()) {
                HighlightSeverity highlightSeverity = highlightInfoType.getSeverity(null);
                this.registerHighlightingType(highlightSeverity.getName(), new ExpectedHighlightingSet(highlightSeverity, false, true));
            }
        }
        this.registerHighlightingType("EOLError", new ExpectedHighlightingSet(HighlightSeverity.ERROR, true, true));
        this.registerHighlightingType("EOLWarning", new ExpectedHighlightingSet(HighlightSeverity.WARNING, true, false));
    }

    public boolean hasLineMarkers() {
        boolean bl2;
        try {
            bl2 = !this.b.isEmpty();
        }
        catch (RuntimeException runtimeException) {
            throw ExpectedHighlightingData.a(runtimeException);
        }
        return bl2;
    }

    public void init() {
        WriteCommandAction.writeCommandAction(null).run(() -> {
            this.b(this.m);
            this.a(this.m);
            this.a();
        });
    }

    public void checkWarnings() {
        this.registerHighlightingType("warning", new ExpectedHighlightingSet(HighlightSeverity.WARNING, false, true));
        this.registerHighlightingType("EOLWarning", new ExpectedHighlightingSet(HighlightSeverity.WARNING, true, true));
    }

    public void checkWeakWarnings() {
        this.registerHighlightingType("weak_warning", new ExpectedHighlightingSet(HighlightSeverity.WEAK_WARNING, false, true));
    }

    public void checkInfos() {
        this.registerHighlightingType("info", new ExpectedHighlightingSet(HighlightSeverity.INFORMATION, false, true));
        this.registerHighlightingType("inject", new ExpectedHighlightingSet(HighlightInfoType.INJECTED_FRAGMENT_SEVERITY, false, true));
    }

    public void checkSymbolNames() {
        this.registerHighlightingType("symbolName", new ExpectedHighlightingSet(HighlightInfoType.SYMBOL_TYPE_SEVERITY, false, true));
    }

    public void registerHighlightingType(@NotNull String string, @NotNull ExpectedHighlightingSet expectedHighlightingSet) {
        try {
            if (string == null) {
                ExpectedHighlightingData.a(5);
            }
        }
        catch (RuntimeException runtimeException) {
            throw ExpectedHighlightingData.a(runtimeException);
        }
        try {
            if (expectedHighlightingSet == null) {
                ExpectedHighlightingData.a(6);
            }
        }
        catch (RuntimeException runtimeException) {
            throw ExpectedHighlightingData.a(runtimeException);
        }
        this.j.put(string, expectedHighlightingSet);
    }

    private void a() {
        for (Map.Entry<RangeMarker, LineMarkerInfo> entry : this.b.entrySet()) {
            PsiElement psiElement;
            LineMarkerInfo lineMarkerInfo;
            int n2;
            int n3;
            block5: {
                RangeMarker rangeMarker = entry.getKey();
                n3 = rangeMarker.getStartOffset();
                n2 = rangeMarker.getEndOffset();
                lineMarkerInfo = entry.getValue();
                psiElement = lineMarkerInfo.getElement();
                try {
                    try {
                        if ($assertionsDisabled || psiElement != null) break block5;
                    }
                    catch (RuntimeException runtimeException) {
                        throw ExpectedHighlightingData.a(runtimeException);
                    }
                    throw new AssertionError(lineMarkerInfo);
                }
                catch (RuntimeException runtimeException) {
                    throw ExpectedHighlightingData.a(runtimeException);
                }
            }
            TextRange textRange = new TextRange(n3, n2);
            String string = lineMarkerInfo.getLineMarkerTooltip();
            MyLineMarkerInfo myLineMarkerInfo = new MyLineMarkerInfo(psiElement, textRange, lineMarkerInfo.updatePass, GutterIconRenderer.Alignment.RIGHT, string);
            entry.setValue(myLineMarkerInfo);
        }
    }

    private void b(Document document) {
        String string = document.getText();
        String string2 = ".*?((<lineMarker)(?: descr=\"((?:[^\"\\\\]|\\\\\")*)\")?>)(.*)";
        Pattern pattern = Pattern.compile(string2, 32);
        Pattern pattern2 = Pattern.compile("(.*?)(</lineMarker>)(.*)", 32);
        while (true) {
            String string3;
            Matcher matcher = pattern.matcher(string);
            try {
                if (!matcher.matches()) {
                    break;
                }
            }
            catch (RuntimeException runtimeException) {
                throw ExpectedHighlightingData.a(runtimeException);
            }
            int n2 = matcher.start(1);
            try {
                string3 = matcher.group(3) != null ? matcher.group(3) : "*";
            }
            catch (RuntimeException runtimeException) {
                throw ExpectedHighlightingData.a(runtimeException);
            }
            String string4 = string3;
            String string5 = matcher.group(4);
            Matcher matcher2 = pattern2.matcher(string5);
            try {
                if (!matcher2.matches()) {
                    Assert.fail((String)"Cannot find closing </lineMarker>");
                }
            }
            catch (RuntimeException runtimeException) {
                throw ExpectedHighlightingData.a(runtimeException);
            }
            document.replaceString(n2, matcher.end(1), (CharSequence)"");
            String string6 = matcher2.group(1);
            int n3 = n2 + matcher2.start(3);
            String string7 = matcher2.group(2);
            document.replaceString(n2, n3, (CharSequence)string6);
            PsiElement psiElement = Objects.requireNonNull(this.q.findElementAt(n2));
            TextRange textRange = new TextRange(n2, n3 -= string7.length());
            String string8 = StringUtil.unescapeStringCharacters((String)string4);
            MyLineMarkerInfo myLineMarkerInfo = new MyLineMarkerInfo(psiElement, textRange, 11, GutterIconRenderer.Alignment.RIGHT, string8);
            this.b.put(document.createRangeMarker(n2, n3), myLineMarkerInfo);
            string = document.getText();
        }
    }

    private void a(Document document) {
        String string = document.getText();
        Set<String> set = this.j.keySet();
        String string2 = "(?:" + StringUtil.join(set, (String)")|(?:") + ")";
        String string3 = "<(" + string2 + ")(?:\\s+descr=\"((?:[^\"]|\\\\\"|\\\\\\\\\"|\\\\\\[|\\\\])*)\")?(?:\\s+type=\"([0-9A-Z_]+)\")?(?:\\s+foreground=\"([0-9xa-f]+)\")?(?:\\s+background=\"([0-9xa-f]+)\")?(?:\\s+effectcolor=\"([0-9xa-f]+)\")?(?:\\s+effecttype=\"([A-Z]+)\")?(?:\\s+fonttype=\"([0-9]+)\")?(?:\\s+textAttributesKey=\"((?:[^\"]|\\\\\"|\\\\\\\\\"|\\\\\\[|\\\\])*)\")?(?:\\s+bundleMsg=\"((?:[^\"]|\\\\\"|\\\\\\\\\")*)\")?(/)?>";
        Matcher matcher = Pattern.compile(string3).matcher(string);
        int n2 = 0;
        Ref ref = Ref.create((Object)0);
        while (matcher.find(n2)) {
            ref.set((Object)((Integer)ref.get() + matcher.start() - n2));
            n2 = this.a(matcher, string, document, (Ref<Integer>)ref);
        }
    }

    private int a(Matcher matcher, String string, Document document, Ref<Integer> ref) {
        int n2;
        block37: {
            List list;
            TextAttributesKey textAttributesKey;
            ExpectedHighlightingSet expectedHighlightingSet;
            Matcher matcher2;
            int n3;
            TextAttributes textAttributes;
            HighlightInfoType highlightInfoType;
            String string2;
            String string3;
            block39: {
                String string4;
                block38: {
                    boolean bl2;
                    document.deleteString(((Integer)ref.get()).intValue(), (Integer)ref.get() + matcher.end() - matcher.start());
                    int n4 = 1;
                    String string5 = matcher.group(n4++);
                    string3 = matcher.group(n4++);
                    String string6 = matcher.group(n4++);
                    String string7 = matcher.group(n4++);
                    String string8 = matcher.group(n4++);
                    String string9 = matcher.group(n4++);
                    String string10 = matcher.group(n4++);
                    String string11 = matcher.group(n4++);
                    string4 = matcher.group(n4++);
                    string2 = matcher.group(n4++);
                    try {
                        boolean bl3 = bl2 = matcher.group(n4) != null;
                    }
                    catch (Exception exception) {
                        throw ExpectedHighlightingData.a(exception);
                    }
                    if (string3 == null) {
                        string3 = "*";
                    } else if (string3.equals("null")) {
                        string3 = null;
                    }
                    if (string3 != null) {
                        string3 = string3.replaceAll("\\\\\\\\\"", "\"");
                        string3 = string3.replaceAll("\\\\\"", "\"");
                    }
                    highlightInfoType = c;
                    if (string6 != null) {
                        try {
                            highlightInfoType = this.getTypeByName(string6);
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(exception);
                        }
                        try {
                            if (highlightInfoType == null) {
                                Assert.fail((String)("Wrong highlight type: " + string6));
                            }
                        }
                        catch (Exception exception) {
                            throw ExpectedHighlightingData.a(exception);
                        }
                    }
                    textAttributes = null;
                    if (string7 != null) {
                        n3 = Integer.parseInt(string11);
                        textAttributes = new TextAttributes(Color.decode(string7), Color.decode(string8), Color.decode(string9), EffectType.valueOf((String)string10), n3);
                    }
                    n3 = (Integer)ref.get();
                    if (bl2) {
                        n2 = matcher.end();
                    } else {
                        int n5 = matcher.end();
                        matcher2 = Pattern.compile("</" + string5 + ">").matcher(string);
                        while (true) {
                            int n6;
                            if (!matcher2.find(n5)) {
                                n2 = n5;
                                break;
                            }
                            try {
                                int n7 = n6 = matcher.find(n5) ? matcher.start() : string.length();
                            }
                            catch (Exception exception) {
                                throw ExpectedHighlightingData.a(exception);
                            }
                            if (matcher2.start() < n6) {
                                ref.set((Object)((Integer)ref.get() + matcher2.start() - n5));
                                document.deleteString(((Integer)ref.get()).intValue(), (Integer)ref.get() + matcher2.end() - matcher2.start());
                                n2 = matcher2.end();
                                break;
                            }
                            ref.set((Object)((Integer)ref.get() + n6 - n5));
                            n5 = this.a(matcher, string, document, ref);
                        }
                    }
                    expectedHighlightingSet = this.j.get(string5);
                    try {
                        try {
                            if (!ExpectedHighlightingSet.access$000(expectedHighlightingSet)) break block37;
                            if (string4 != null) break block38;
                        }
                        catch (Exception exception) {
                            throw ExpectedHighlightingData.a(exception);
                        }
                        textAttributesKey = null;
                        break block39;
                    }
                    catch (Exception exception) {
                        throw ExpectedHighlightingData.a(exception);
                    }
                }
                textAttributesKey = TextAttributesKey.createTextAttributesKey((String)string4);
            }
            matcher2 = textAttributesKey;
            HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(n3, ((Integer)ref.get()).intValue()).severity(ExpectedHighlightingSet.access$100(expectedHighlightingSet));
            try {
                if (textAttributes != null) {
                    builder2.textAttributes(textAttributes);
                }
            }
            catch (Exception exception) {
                throw ExpectedHighlightingData.a(exception);
            }
            try {
                if (matcher2 != null) {
                    builder2.textAttributes((TextAttributesKey)matcher2);
                }
            }
            catch (Exception exception) {
                throw ExpectedHighlightingData.a(exception);
            }
            if (string2 != null) {
                list = StringUtil.split((String)string2, (String)"|");
                ResourceBundle resourceBundle = ResourceBundle.getBundle((String)list.get(0));
                string3 = CommonBundle.message((ResourceBundle)resourceBundle, (String)((String)list.get(1)), (Object[])list.stream().skip(2L).toArray());
            }
            try {
                if (string3 != null) {
                    builder2.description(string3);
                    builder2.unescapedToolTip(string3);
                }
            }
            catch (Exception exception) {
                throw ExpectedHighlightingData.a(exception);
            }
            try {
                if (ExpectedHighlightingSet.access$200(expectedHighlightingSet)) {
                    builder2.endOfLine();
                }
            }
            catch (Exception exception) {
                throw ExpectedHighlightingData.a(exception);
            }
            list = builder2.createUnconditionally();
            ExpectedHighlightingSet.access$300(expectedHighlightingSet).add(list);
        }
        return n2;
    }

    protected HighlightInfoType getTypeByName(String string) throws Exception {
        Field field = HighlightInfoType.class.getField(string);
        return (HighlightInfoType)field.get(null);
    }

    public void checkLineMarkers(@NotNull Collection<LineMarkerInfo> collection, @NotNull String string) {
        String string2;
        try {
            if (collection == null) {
                ExpectedHighlightingData.a(7);
            }
        }
        catch (RuntimeException runtimeException) {
            throw ExpectedHighlightingData.a(runtimeException);
        }
        try {
            if (string == null) {
                ExpectedHighlightingData.a(8);
            }
        }
        catch (RuntimeException runtimeException) {
            throw ExpectedHighlightingData.a(runtimeException);
        }
        try {
            string2 = this.q == null ? "" : this.q.getName() + ": ";
        }
        catch (RuntimeException runtimeException) {
            throw ExpectedHighlightingData.a(runtimeException);
        }
        String string3 = string2;
        StringBuilder stringBuilder = new StringBuilder();
        for (LineMarkerInfo lineMarkerInfo : collection) {
            block23: {
                try {
                    try {
                        if (ExpectedHighlightingData.a(lineMarkerInfo, this.b.values())) continue;
                        if (stringBuilder.length() <= 0) break block23;
                    }
                    catch (RuntimeException runtimeException) {
                        throw ExpectedHighlightingData.a(runtimeException);
                    }
                    stringBuilder.append('\n');
                }
                catch (RuntimeException runtimeException) {
                    throw ExpectedHighlightingData.a(runtimeException);
                }
            }
            stringBuilder.append(string3).append("extra ").append(ExpectedHighlightingData.a(string, lineMarkerInfo.startOffset, lineMarkerInfo.endOffset)).append(": '").append(lineMarkerInfo.getLineMarkerTooltip()).append('\'');
        }
        for (LineMarkerInfo lineMarkerInfo : this.b.values()) {
            block24: {
                try {
                    try {
                        try {
                            if (!collection.isEmpty() && ExpectedHighlightingData.a(lineMarkerInfo, collection)) continue;
                        }
                        catch (RuntimeException runtimeException) {
                            throw ExpectedHighlightingData.a(runtimeException);
                        }
                        if (stringBuilder.length() <= 0) break block24;
                    }
                    catch (RuntimeException runtimeException) {
                        throw ExpectedHighlightingData.a(runtimeException);
                    }
                    stringBuilder.append('\n');
                }
                catch (RuntimeException runtimeException) {
                    throw ExpectedHighlightingData.a(runtimeException);
                }
            }
            stringBuilder.append(string3).append("missing ").append(ExpectedHighlightingData.a(string, lineMarkerInfo.startOffset, lineMarkerInfo.endOffset)).append(": '").append(lineMarkerInfo.getLineMarkerTooltip()).append('\'');
        }
        try {
            if (stringBuilder.length() > 0) {
                Assert.fail((String)stringBuilder.toString());
            }
        }
        catch (RuntimeException runtimeException) {
            throw ExpectedHighlightingData.a(runtimeException);
        }
    }

    private static boolean a(LineMarkerInfo lineMarkerInfo, Collection<LineMarkerInfo> collection) {
        String string = lineMarkerInfo.getLineMarkerTooltip();
        for (LineMarkerInfo lineMarkerInfo2 : collection) {
            try {
                if (lineMarkerInfo2.startOffset != lineMarkerInfo.startOffset || lineMarkerInfo2.endOffset != lineMarkerInfo.endOffset) continue;
            }
            catch (RuntimeException runtimeException) {
                throw ExpectedHighlightingData.a(runtimeException);
            }
            String string2 = lineMarkerInfo2.getLineMarkerTooltip();
            try {
                block9: {
                    try {
                        try {
                            if (Comparing.equal((String)string, (String)string2) || "*".equals(string2)) break block9;
                        }
                        catch (RuntimeException runtimeException) {
                            throw ExpectedHighlightingData.a(runtimeException);
                        }
                        if (!"*".equals(string)) continue;
                    }
                    catch (RuntimeException runtimeException) {
                        throw ExpectedHighlightingData.a(runtimeException);
                    }
                }
                return true;
            }
            catch (RuntimeException runtimeException) {
                throw ExpectedHighlightingData.a(runtimeException);
            }
        }
        return false;
    }

    public void checkResult(Collection<HighlightInfo> collection, String string) {
        this.checkResult(collection, string, null);
    }

    public void checkResult(Collection<HighlightInfo> collection, String string, @Nullable String string2) {
        block25: {
            StringBuilder stringBuilder;
            block26: {
                String string3;
                try {
                    string3 = this.q == null ? "" : this.q.getName() + ": ";
                }
                catch (RuntimeException runtimeException) {
                    throw ExpectedHighlightingData.a(runtimeException);
                }
                String string4 = string3;
                stringBuilder = new StringBuilder();
                for (HighlightInfo object2 : ExpectedHighlightingData.a(collection)) {
                    try {
                        if (this.a(object2) || this.i) continue;
                    }
                    catch (RuntimeException runtimeException) {
                        throw ExpectedHighlightingData.a(runtimeException);
                    }
                    int n2 = object2.startOffset;
                    int n3 = object2.endOffset;
                    String string5 = string.substring(n2, n3);
                    String string6 = object2.getDescription();
                    try {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append('\n');
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw ExpectedHighlightingData.a(runtimeException);
                    }
                    try {
                        stringBuilder.append(string4).append("extra ").append(ExpectedHighlightingData.a(string, n2, n3)).append(": '").append(string5).append('\'');
                        if (string6 != null) {
                            stringBuilder.append(" (").append(string6).append(')');
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw ExpectedHighlightingData.a(runtimeException);
                    }
                    stringBuilder.append(" [").append(object2.type).append(']');
                }
                Collection<ExpectedHighlightingSet> collection2 = this.j.values();
                for (ExpectedHighlightingSet expectedHighlightingSet : ExpectedHighlightingData.a(collection2)) {
                    Set set = ExpectedHighlightingSet.access$300(expectedHighlightingSet);
                    for (String string6 : set) {
                        try {
                            if (ExpectedHighlightingData.a(collection, (HighlightInfo)string6) || !ExpectedHighlightingSet.access$000(expectedHighlightingSet)) continue;
                        }
                        catch (RuntimeException runtimeException) {
                            throw ExpectedHighlightingData.a(runtimeException);
                        }
                        int n4 = ((HighlightInfo)string6).startOffset;
                        int n5 = ((HighlightInfo)string6).endOffset;
                        String string7 = string.substring(n4, n5);
                        String string8 = string6.getDescription();
                        try {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append('\n');
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            throw ExpectedHighlightingData.a(runtimeException);
                        }
                        try {
                            stringBuilder.append(string4).append("missing ").append(ExpectedHighlightingData.a(string, n4, n5)).append(": '").append(string7).append('\'');
                            if (string8 == null) continue;
                            stringBuilder.append(" (").append(string8).append(")");
                        }
                        catch (RuntimeException runtimeException) {
                            throw ExpectedHighlightingData.a(runtimeException);
                        }
                    }
                }
                try {
                    try {
                        if (stringBuilder.length() <= 0) break block25;
                        if (string2 != null) break block26;
                    }
                    catch (RuntimeException runtimeException) {
                        throw ExpectedHighlightingData.a(runtimeException);
                    }
                    if (this.q == null) break block26;
                }
                catch (RuntimeException runtimeException) {
                    throw ExpectedHighlightingData.a(runtimeException);
                }
                VirtualFile virtualFile = this.q.getVirtualFile();
                if (virtualFile != null) {
                    string2 = (String)virtualFile.getUserData(VfsTestUtil.TEST_DATA_FILE_PATH);
                }
            }
            stringBuilder.append('\n');
            this.a(collection, string, stringBuilder.toString(), string2);
        }
    }

    private static <T> List<T> a(Collection<T> collection) {
        List<Object> list;
        try {
            list = collection instanceof List ? (List<Object>)collection : new ArrayList<T>(collection);
        }
        catch (RuntimeException runtimeException) {
            throw ExpectedHighlightingData.a(runtimeException);
        }
        return ContainerUtil.reverse((List)list);
    }

    private void a(Collection<HighlightInfo> collection, String string, String string2, @Nullable String string3) {
        String string4;
        block4: {
            string4 = ExpectedHighlightingData.composeText(this.j, collection, string);
            try {
                try {
                    if (string3 == null || this.g.equals(string4)) break block4;
                }
                catch (RuntimeException runtimeException) {
                    throw ExpectedHighlightingData.a(runtimeException);
                }
                throw new FileComparisonFailure(string2, this.g, string4, string3);
            }
            catch (RuntimeException runtimeException) {
                throw ExpectedHighlightingData.a(runtimeException);
            }
        }
        Assert.assertEquals((String)(string2 + "\n"), (Object)this.g, (Object)string4);
        Assert.fail((String)string2);
    }

    private static String b(Map<String, ExpectedHighlightingSet> map, HighlightInfo highlightInfo) {
        String string;
        Map.Entry entry2 = (Map.Entry)ContainerUtil.find(map.entrySet(), entry -> {
            boolean bl2;
            block7: {
                block6: {
                    try {
                        try {
                            try {
                                if (!ExpectedHighlightingSet.access$000((ExpectedHighlightingSet)entry.getValue()) || ExpectedHighlightingSet.access$100((ExpectedHighlightingSet)entry.getValue()) != highlightInfo.getSeverity()) break block6;
                            }
                            catch (RuntimeException runtimeException) {
                                throw ExpectedHighlightingData.a(runtimeException);
                            }
                            if (ExpectedHighlightingSet.access$200((ExpectedHighlightingSet)entry.getValue()) != highlightInfo.isAfterEndOfLine()) break block6;
                        }
                        catch (RuntimeException runtimeException) {
                            throw ExpectedHighlightingData.a(runtimeException);
                        }
                        bl2 = true;
                        break block7;
                    }
                    catch (RuntimeException runtimeException) {
                        throw ExpectedHighlightingData.a(runtimeException);
                    }
                }
                bl2 = false;
            }
            return bl2;
        });
        try {
            string = entry2 != null ? (String)entry2.getKey() : null;
        }
        catch (RuntimeException runtimeException) {
            throw ExpectedHighlightingData.a(runtimeException);
        }
        return string;
    }

    public static String composeText(Map<String, ExpectedHighlightingSet> map, Collection<HighlightInfo> collection, String string) {
        List<Pair<String, HighlightInfo>> list = collection.stream().map(highlightInfo -> Pair.pair((Object)ExpectedHighlightingData.b(map, highlightInfo), (Object)highlightInfo)).filter(pair2 -> {
            boolean bl2;
            try {
                bl2 = pair2.first != null;
            }
            catch (RuntimeException runtimeException) {
                throw ExpectedHighlightingData.a(runtimeException);
            }
            return bl2;
        }).collect(Collectors.toList());
        boolean bl2 = map.values().stream().flatMap(expectedHighlightingSet -> ExpectedHighlightingSet.access$300(expectedHighlightingSet).stream()).anyMatch(highlightInfo -> {
            boolean bl2;
            try {
                bl2 = highlightInfo.forcedTextAttributesKey != null;
            }
            catch (RuntimeException runtimeException) {
                throw ExpectedHighlightingData.a(runtimeException);
            }
            return bl2;
        });
        Collections.sort(list, (pair2, pair3) -> {
            int n2;
            HighlightInfo highlightInfo;
            HighlightInfo highlightInfo2;
            block15: {
                block14: {
                    highlightInfo2 = (HighlightInfo)pair2.second;
                    highlightInfo = (HighlightInfo)pair3.second;
                    int n3 = highlightInfo.endOffset - highlightInfo2.endOffset;
                    try {
                        if (n3 != 0) {
                            return n3;
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw ExpectedHighlightingData.a(runtimeException);
                    }
                    try {
                        if (highlightInfo2.isAfterEndOfLine() || highlightInfo.isAfterEndOfLine()) break block14;
                    }
                    catch (RuntimeException runtimeException) {
                        throw ExpectedHighlightingData.a(runtimeException);
                    }
                    n2 = highlightInfo2.startOffset - highlightInfo.startOffset;
                    try {
                        if (n2 != 0) {
                            return n2;
                        }
                        break block15;
                    }
                    catch (RuntimeException runtimeException) {
                        throw ExpectedHighlightingData.a(runtimeException);
                    }
                }
                n2 = Comparing.compare((boolean)highlightInfo.isAfterEndOfLine(), (boolean)highlightInfo2.isAfterEndOfLine());
                try {
                    if (n2 != 0) {
                        return n2;
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw ExpectedHighlightingData.a(runtimeException);
                }
            }
            n2 = highlightInfo.getSeverity().compareTo(highlightInfo2.getSeverity());
            try {
                if (n2 != 0) {
                    return n2;
                }
            }
            catch (RuntimeException runtimeException) {
                throw ExpectedHighlightingData.a(runtimeException);
            }
            return Comparing.compare((Comparable)((Object)highlightInfo2.getDescription()), (Comparable)((Object)highlightInfo.getDescription()));
        });
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray = ExpectedHighlightingData.a(stringBuilder, list, 0, string, string.length(), -1, bl2);
        stringBuilder.insert(0, string.substring(0, nArray[1]));
        return stringBuilder.toString();
    }

    private static int[] a(StringBuilder stringBuilder, List<Pair<String, HighlightInfo>> list, int n2, String string, int n3, int n4, boolean bl2) {
        int n5;
        for (n5 = n2; n5 < list.size(); ++n5) {
            Object object;
            String string2;
            HighlightInfo highlightInfo;
            block9: {
                HighlightInfo highlightInfo2;
                Pair<String, HighlightInfo> pair2 = list.get(n5);
                highlightInfo = (HighlightInfo)pair2.second;
                try {
                    if (highlightInfo.endOffset <= n4) {
                        break;
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw ExpectedHighlightingData.a(runtimeException);
                }
                string2 = (String)pair2.first;
                try {
                    highlightInfo2 = n5 < list.size() - 1 ? (HighlightInfo)list.get((int)(n5 + 1)).second : null;
                }
                catch (RuntimeException runtimeException) {
                    throw ExpectedHighlightingData.a(runtimeException);
                }
                HighlightInfo highlightInfo3 = highlightInfo2;
                stringBuilder.insert(0, string.substring(highlightInfo.endOffset, n3));
                stringBuilder.insert(0, "</" + string2 + '>');
                n3 = highlightInfo.endOffset;
                try {
                    if (highlightInfo3 == null || highlightInfo3.endOffset <= highlightInfo.startOffset) break block9;
                }
                catch (RuntimeException runtimeException) {
                    throw ExpectedHighlightingData.a(runtimeException);
                }
                object = ExpectedHighlightingData.a(stringBuilder, list, n5 + 1, string, n3, highlightInfo.startOffset, bl2);
                n5 = object[0] - 1;
                n3 = object[1];
            }
            stringBuilder.insert(0, string.substring(highlightInfo.startOffset, n3));
            object = '<' + string2 + " descr=\"" + StringUtil.escapeQuotes((String)String.valueOf(highlightInfo.getDescription())) + '\"';
            if (bl2) {
                object = (String)object + " textAttributesKey=\"" + highlightInfo.forcedTextAttributesKey + '\"';
            }
            object = (String)object + '>';
            stringBuilder.insert(0, (String)object);
            n3 = highlightInfo.startOffset;
        }
        return new int[]{n5, n3};
    }

    private static boolean a(Collection<HighlightInfo> collection, HighlightInfo highlightInfo) {
        for (HighlightInfo highlightInfo2 : collection) {
            try {
                if (!ExpectedHighlightingData.a(highlightInfo, highlightInfo2)) continue;
                return true;
            }
            catch (RuntimeException runtimeException) {
                throw ExpectedHighlightingData.a(runtimeException);
            }
        }
        return false;
    }

    private boolean a(HighlightInfo highlightInfo) {
        try {
            if (highlightInfo.getTextAttributes(null, null) == TextAttributes.ERASE_MARKER) {
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            throw ExpectedHighlightingData.a(runtimeException);
        }
        Collection<ExpectedHighlightingSet> collection = this.j.values();
        for (ExpectedHighlightingSet expectedHighlightingSet : collection) {
            try {
                if (ExpectedHighlightingSet.access$100(expectedHighlightingSet) != highlightInfo.getSeverity()) {
                    continue;
                }
            }
            catch (RuntimeException runtimeException) {
                throw ExpectedHighlightingData.a(runtimeException);
            }
            try {
                if (!ExpectedHighlightingSet.access$000(expectedHighlightingSet)) {
                    return true;
                }
            }
            catch (RuntimeException runtimeException) {
                throw ExpectedHighlightingData.a(runtimeException);
            }
            Set set = ExpectedHighlightingSet.access$300(expectedHighlightingSet);
            for (HighlightInfo highlightInfo2 : set) {
                try {
                    if (!ExpectedHighlightingData.a(highlightInfo2, highlightInfo)) continue;
                    return true;
                }
                catch (RuntimeException runtimeException) {
                    throw ExpectedHighlightingData.a(runtimeException);
                }
            }
        }
        return false;
    }

    private static boolean a(HighlightInfo highlightInfo, HighlightInfo highlightInfo2) {
        boolean bl2;
        block32: {
            block27: {
                try {
                    if (highlightInfo == highlightInfo2) {
                        return true;
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw ExpectedHighlightingData.a(runtimeException);
                }
                try {
                    block31: {
                        try {
                            try {
                                block30: {
                                    try {
                                        try {
                                            block29: {
                                                try {
                                                    try {
                                                        block28: {
                                                            try {
                                                                try {
                                                                    try {
                                                                        try {
                                                                            try {
                                                                                if (highlightInfo2.getSeverity() != highlightInfo.getSeverity() || highlightInfo2.startOffset != highlightInfo.startOffset) break block27;
                                                                            }
                                                                            catch (RuntimeException runtimeException) {
                                                                                throw ExpectedHighlightingData.a(runtimeException);
                                                                            }
                                                                            if (highlightInfo2.endOffset != highlightInfo.endOffset) break block27;
                                                                        }
                                                                        catch (RuntimeException runtimeException) {
                                                                            throw ExpectedHighlightingData.a(runtimeException);
                                                                        }
                                                                        if (highlightInfo2.isAfterEndOfLine() != highlightInfo.isAfterEndOfLine()) break block27;
                                                                    }
                                                                    catch (RuntimeException runtimeException) {
                                                                        throw ExpectedHighlightingData.a(runtimeException);
                                                                    }
                                                                    if (highlightInfo.type == c) break block28;
                                                                }
                                                                catch (RuntimeException runtimeException) {
                                                                    throw ExpectedHighlightingData.a(runtimeException);
                                                                }
                                                                if (!highlightInfo.type.equals(highlightInfo2.type)) break block27;
                                                            }
                                                            catch (RuntimeException runtimeException) {
                                                                throw ExpectedHighlightingData.a(runtimeException);
                                                            }
                                                        }
                                                        if (Comparing.strEqual((String)"*", (String)highlightInfo.getDescription())) break block29;
                                                    }
                                                    catch (RuntimeException runtimeException) {
                                                        throw ExpectedHighlightingData.a(runtimeException);
                                                    }
                                                    if (!Comparing.strEqual((String)highlightInfo2.getDescription(), (String)highlightInfo.getDescription())) break block27;
                                                }
                                                catch (RuntimeException runtimeException) {
                                                    throw ExpectedHighlightingData.a(runtimeException);
                                                }
                                            }
                                            if (highlightInfo.forcedTextAttributes == null) break block30;
                                        }
                                        catch (RuntimeException runtimeException) {
                                            throw ExpectedHighlightingData.a(runtimeException);
                                        }
                                        if (!Comparing.equal((Object)highlightInfo.getTextAttributes(null, null), (Object)highlightInfo2.getTextAttributes(null, null))) break block27;
                                    }
                                    catch (RuntimeException runtimeException) {
                                        throw ExpectedHighlightingData.a(runtimeException);
                                    }
                                }
                                if (highlightInfo.forcedTextAttributesKey == null) break block31;
                            }
                            catch (RuntimeException runtimeException) {
                                throw ExpectedHighlightingData.a(runtimeException);
                            }
                            if (!highlightInfo.forcedTextAttributesKey.equals((Object)highlightInfo2.forcedTextAttributesKey)) break block27;
                        }
                        catch (RuntimeException runtimeException) {
                            throw ExpectedHighlightingData.a(runtimeException);
                        }
                    }
                    bl2 = true;
                    break block32;
                }
                catch (RuntimeException runtimeException) {
                    throw ExpectedHighlightingData.a(runtimeException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    private static String a(String string, int n2, int n3) {
        int n4 = StringUtil.offsetToLineNumber((CharSequence)string, (int)n2);
        int n5 = StringUtil.offsetToLineNumber((CharSequence)string, (int)n3);
        int n6 = n2 - StringUtil.lineColToOffset((CharSequence)string, (int)n4, (int)0);
        int n7 = n3 - StringUtil.lineColToOffset((CharSequence)string, (int)n5, (int)0);
        try {
            if (n4 == n5) {
                return String.format("(%d:%d/%d)", n4 + 1, n6 + 1, n7 - n6);
            }
        }
        catch (RuntimeException runtimeException) {
            throw ExpectedHighlightingData.a(runtimeException);
        }
        return String.format("(%d:%d..%d:%d)", n4 + 1, n5 + 1, n6 + 1, n7 + 1);
    }

    static {
        boolean bl2;
        try {
            bl2 = !ExpectedHighlightingData.class.desiredAssertionStatus();
        }
        catch (RuntimeException runtimeException) {
            throw ExpectedHighlightingData.a(runtimeException);
        }
        $assertionsDisabled = bl2;
        c = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, HighlighterColors.TEXT);
    }

    /*
     * Exception decompiling
     */
    private static /* synthetic */ void a(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Exception a(Exception exception) {
        return exception;
    }

    private static class MyLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private final String a;

        public MyLineMarkerInfo(PsiElement psiElement, TextRange textRange, int n2, GutterIconRenderer.Alignment alignment, String string) {
            super(psiElement, textRange, null, n2, null, null, alignment);
            this.a = string;
        }

        public String getLineMarkerTooltip() {
            return this.a;
        }
    }

    public static class ExpectedHighlightingSet {
        private final HighlightSeverity d;
        private final boolean a;
        private final boolean c;
        private final Set<HighlightInfo> b;

        public ExpectedHighlightingSet(@NotNull HighlightSeverity highlightSeverity, boolean bl2, boolean bl3) {
            if (highlightSeverity == null) {
                ExpectedHighlightingSet.a(0);
            }
            this.d = highlightSeverity;
            this.a = bl2;
            this.c = bl3;
            this.b = new THashSet();
        }

        static /* synthetic */ boolean access$000(ExpectedHighlightingSet expectedHighlightingSet) {
            return expectedHighlightingSet.c;
        }

        static /* synthetic */ HighlightSeverity access$100(ExpectedHighlightingSet expectedHighlightingSet) {
            return expectedHighlightingSet.d;
        }

        static /* synthetic */ boolean access$200(ExpectedHighlightingSet expectedHighlightingSet) {
            return expectedHighlightingSet.a;
        }

        static /* synthetic */ Set access$300(ExpectedHighlightingSet expectedHighlightingSet) {
            return expectedHighlightingSet.b;
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/testFramework/ExpectedHighlightingData$ExpectedHighlightingSet", "<init>"));
        }
    }
}

