/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.mock.MockApplicationEx;
import com.intellij.mock.MockProjectEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.MutablePicoContainer;

public abstract class PlatformLiteFixture
extends UsefulTestCase {
    protected MockProjectEx myProject;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Extensions.cleanRootArea((Disposable)this.getTestRootDisposable());
    }

    public static MockApplicationEx getApplication() {
        return (MockApplicationEx)ApplicationManager.getApplication();
    }

    public void initApplication() {
        MockApplicationEx mockApplicationEx = new MockApplicationEx(this.getTestRootDisposable());
        ApplicationManager.setApplication((Application)mockApplicationEx, () -> FileTypeManager.getInstance(), (Disposable)this.getTestRootDisposable());
        PlatformLiteFixture.getApplication().registerService(EncodingManager.class, EncodingManagerImpl.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.myProject = null;
        try {
            super.tearDown();
        }
        finally {
            PlatformLiteFixture.clearFields((Object)this);
        }
    }

    protected <T> void registerExtension(ExtensionPointName<T> extensionPointName, @NotNull T t2) {
        try {
            if (t2 == null) {
                PlatformLiteFixture.b(0);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PlatformLiteFixture.a(illegalArgumentException);
        }
        this.registerExtension(Extensions.getRootArea(), extensionPointName, t2);
    }

    public <T> void registerExtension(ExtensionsArea extensionsArea, ExtensionPointName<T> extensionPointName, T t2) {
        this.registerExtensionPoint(extensionsArea, extensionPointName, t2.getClass());
        PlatformTestUtil.registerExtension(extensionsArea, extensionPointName, t2, this.getTestRootDisposable());
    }

    protected <T> void registerExtensionPoint(ExtensionPointName<T> extensionPointName, Class<T> clazz) {
        this.registerExtensionPoint(Extensions.getRootArea(), extensionPointName, clazz);
    }

    protected <T> void registerExtensionPoint(ExtensionsArea extensionsArea, ExtensionPointName<T> extensionPointName, Class<? extends T> clazz) {
        block6: {
            ExtensionPoint.Kind kind;
            String string;
            block9: {
                block8: {
                    string = extensionPointName.getName();
                    try {
                        block7: {
                            try {
                                try {
                                    if (extensionsArea.hasExtensionPoint(string)) break block6;
                                    if (clazz.isInterface()) break block7;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw PlatformLiteFixture.a(illegalArgumentException);
                                }
                                if ((clazz.getModifiers() & 0x400) == 0) break block8;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw PlatformLiteFixture.a(illegalArgumentException);
                            }
                        }
                        kind = ExtensionPoint.Kind.INTERFACE;
                        break block9;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw PlatformLiteFixture.a(illegalArgumentException);
                    }
                }
                kind = ExtensionPoint.Kind.BEAN_CLASS;
            }
            ExtensionPoint.Kind kind2 = kind;
            extensionsArea.registerExtensionPoint(string, clazz.getName(), kind2);
        }
    }

    protected void registerComponentImplementation(MutablePicoContainer mutablePicoContainer, Class<?> clazz, Class<?> clazz2) {
        mutablePicoContainer.unregisterComponent(clazz);
        mutablePicoContainer.registerComponentImplementation(clazz, clazz2);
    }

    public static <T> T registerComponentInstance(MutablePicoContainer mutablePicoContainer, Class<T> clazz, T t2) {
        Object object = mutablePicoContainer.getComponentInstance(clazz);
        mutablePicoContainer.unregisterComponent(clazz);
        mutablePicoContainer.registerComponentInstance(clazz, t2);
        return (T)object;
    }

    public static <T> T registerComponentInstance(ComponentManager componentManager, Class<T> clazz, T t2) {
        return PlatformLiteFixture.registerComponentInstance((MutablePicoContainer)componentManager.getPicoContainer(), clazz, t2);
    }

    private static /* synthetic */ void b(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/testFramework/PlatformLiteFixture", "registerExtension"));
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }
}

